/*
 * Decompiled with CFR 0.152.
 */
package xsbt.boot.internal.shaded.coursier.util.shaded.org.jsoup.parser;

import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.jspecify.annotations.Nullable;
import xsbt.boot.internal.shaded.coursier.util.shaded.org.jsoup.helper.Validate;
import xsbt.boot.internal.shaded.coursier.util.shaded.org.jsoup.nodes.Attributes;
import xsbt.boot.internal.shaded.coursier.util.shaded.org.jsoup.nodes.Document;
import xsbt.boot.internal.shaded.coursier.util.shaded.org.jsoup.nodes.Element;
import xsbt.boot.internal.shaded.coursier.util.shaded.org.jsoup.nodes.Node;
import xsbt.boot.internal.shaded.coursier.util.shaded.org.jsoup.nodes.Range;
import xsbt.boot.internal.shaded.coursier.util.shaded.org.jsoup.parser.CharacterReader;
import xsbt.boot.internal.shaded.coursier.util.shaded.org.jsoup.parser.ParseError;
import xsbt.boot.internal.shaded.coursier.util.shaded.org.jsoup.parser.ParseErrorList;
import xsbt.boot.internal.shaded.coursier.util.shaded.org.jsoup.parser.ParseSettings;
import xsbt.boot.internal.shaded.coursier.util.shaded.org.jsoup.parser.Parser;
import xsbt.boot.internal.shaded.coursier.util.shaded.org.jsoup.parser.Tag;
import xsbt.boot.internal.shaded.coursier.util.shaded.org.jsoup.parser.Token;
import xsbt.boot.internal.shaded.coursier.util.shaded.org.jsoup.parser.Tokeniser;
import xsbt.boot.internal.shaded.coursier.util.shaded.org.jsoup.select.NodeVisitor;

abstract class TreeBuilder {
    protected Parser parser;
    CharacterReader reader;
    Tokeniser tokeniser;
    Document doc;
    ArrayList<Element> stack;
    String baseUri;
    Token currentToken;
    ParseSettings settings;
    Map<String, Tag> seenTags;
    @Nullable NodeVisitor nodeListener;
    private Token.StartTag start;
    private final Token.EndTag end = new Token.EndTag(this);
    boolean trackSourceRange;

    TreeBuilder() {
    }

    abstract ParseSettings defaultSettings();

    /*
     * WARNING - void declaration
     */
    void initialiseParse(Reader input, String baseUri, Parser parser) {
        void var2_2;
        void var3_3;
        void var1_1;
        Validate.notNullParam(input, "input");
        Validate.notNullParam(baseUri, "baseUri");
        Validate.notNull(parser);
        this.doc = new Document(parser.defaultNamespace(), baseUri);
        this.doc.parser(parser);
        this.parser = parser;
        this.settings = parser.settings();
        this.reader = new CharacterReader((Reader)var1_1);
        this.trackSourceRange = parser.isTrackPosition();
        this.reader.trackNewlines(var3_3.isTrackErrors() || this.trackSourceRange);
        this.tokeniser = new Tokeniser(this);
        this.stack = new ArrayList(32);
        this.seenTags = new HashMap<String, Tag>();
        this.start = new Token.StartTag(this);
        this.currentToken = this.start;
        this.baseUri = var2_2;
    }

    void completeParse() {
        if (this.reader == null) {
            return;
        }
        this.reader.close();
        this.reader = null;
        this.tokeniser = null;
        this.stack = null;
        this.seenTags = null;
    }

    /*
     * WARNING - void declaration
     */
    Document parse(Reader input, String baseUri, Parser parser) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.initialiseParse((Reader)var1_1, (String)var2_2, (Parser)var3_3);
        this.runParser();
        return this.doc;
    }

    void runParser() {
        while (this.stepParser()) {
        }
        this.completeParse();
    }

    /*
     * WARNING - void declaration
     */
    boolean stepParser() {
        void var1_1;
        Token token;
        if (this.currentToken.type == Token.TokenType.EOF) {
            if (this.stack == null || this.stack.isEmpty()) {
                return false;
            }
            this.pop();
            return true;
        }
        this.currentToken = token = this.tokeniser.read();
        this.process(token);
        var1_1.reset();
        return true;
    }

    abstract boolean process(Token var1);

    /*
     * WARNING - void declaration
     */
    boolean processStartTag(String name) {
        void var1_1;
        void var2_2;
        Token.StartTag start = this.start;
        if (this.currentToken == start) {
            return this.process(new Token.StartTag(this).name(name));
        }
        return this.process(var2_2.reset().name((String)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    boolean processStartTag(String name, Attributes attrs) {
        void var3_3;
        void var2_2;
        void var1_1;
        Token.StartTag start = this.start;
        if (this.currentToken == start) {
            return this.process(new Token.StartTag(this).nameAttr(name, attrs));
        }
        start.reset();
        start.nameAttr((String)var1_1, (Attributes)var2_2);
        return this.process((Token)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    boolean processEndTag(String name) {
        void var1_1;
        if (this.currentToken == this.end) {
            return this.process(new Token.EndTag(this).name(name));
        }
        TreeBuilder treeBuilder = this;
        return treeBuilder.process(treeBuilder.end.reset().name((String)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    final Element pop() {
        void var1_2;
        int size = this.stack.size();
        Element removed = this.stack.remove(size - 1);
        this.onNodeClosed(removed);
        return var1_2;
    }

    /*
     * WARNING - void declaration
     */
    final void push(Element element) {
        void var1_1;
        this.stack.add(element);
        this.onNodeInserted((Node)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    Element currentElement() {
        int size = this.stack.size();
        if (size > 0) {
            void var1_1;
            return this.stack.get((int)(var1_1 - true));
        }
        return this.doc;
    }

    /*
     * WARNING - void declaration
     */
    boolean currentElementIs(String normalName) {
        void var2_2;
        void var1_1;
        if (this.stack.size() == 0) {
            return false;
        }
        Element current = this.currentElement();
        return current != null && current.normalName().equals(var1_1) && var2_2.tag().namespace().equals("http://www.w3.org/1999/xhtml");
    }

    /*
     * WARNING - void declaration
     */
    boolean currentElementIs(String normalName, String namespace) {
        void var2_2;
        void var3_3;
        void var1_1;
        if (this.stack.size() == 0) {
            return false;
        }
        Element current = this.currentElement();
        return current != null && current.normalName().equals(var1_1) && var3_3.tag().namespace().equals(var2_2);
    }

    /*
     * WARNING - void declaration
     */
    void error(String msg, Object ... args) {
        ParseErrorList errors = this.parser.getErrors();
        if (errors.canAddError()) {
            void var2_2;
            void var1_1;
            void var3_3;
            var3_3.add(new ParseError(this.reader, (String)var1_1, (Object[])var2_2));
        }
    }

    boolean isContentForTagData(String normalName) {
        return false;
    }

    /*
     * WARNING - void declaration
     */
    Tag tagFor(String tagName, String namespace, ParseSettings settings) {
        Tag cached = this.seenTags.get(tagName);
        if (cached == null || !cached.namespace().equals(namespace)) {
            void var2_2;
            void var1_1;
            void var3_3;
            Tag tag = Tag.valueOf(tagName, namespace, (ParseSettings)var3_3);
            this.seenTags.put((String)var1_1, tag);
            return var2_2;
        }
        return cached;
    }

    /*
     * WARNING - void declaration
     */
    Tag tagFor(String tagName, ParseSettings settings) {
        void var2_2;
        void var1_1;
        return this.tagFor((String)var1_1, this.defaultNamespace(), (ParseSettings)var2_2);
    }

    String defaultNamespace() {
        return "http://www.w3.org/1999/xhtml";
    }

    /*
     * WARNING - void declaration
     */
    void onNodeInserted(Node node) {
        this.trackNodePosition(node, true);
        if (this.nodeListener != null) {
            void var1_1;
            this.nodeListener.head((Node)var1_1, this.stack.size());
        }
    }

    /*
     * WARNING - void declaration
     */
    void onNodeClosed(Node node) {
        this.trackNodePosition(node, false);
        if (this.nodeListener != null) {
            void var1_1;
            this.nodeListener.tail((Node)var1_1, this.stack.size());
        }
    }

    /*
     * WARNING - void declaration
     */
    private void trackNodePosition(Node node, boolean isStart) {
        void var3_3;
        void var2_2;
        void var1_1;
        if (!this.trackSourceRange) {
            return;
        }
        Token token = this.currentToken;
        int startPos = token.startPos();
        int endPos = token.endPos();
        if (node instanceof Element) {
            Element el = (Element)node;
            if (token.isEOF()) {
                if (el.endSourceRange().isTracked()) {
                    return;
                }
                startPos = endPos = this.reader.pos();
            } else if (isStart) {
                if (!token.isStartTag() || !el.normalName().equals(token.asStartTag().normalName)) {
                    endPos = startPos;
                }
            } else if (!(el.tag().isEmpty() || el.tag().isSelfClosing() || token.isEndTag() && el.normalName().equals(token.asEndTag().normalName))) {
                endPos = startPos;
            }
        }
        Range.Position startPosition = new Range.Position(startPos, this.reader.lineNumber(startPos), this.reader.columnNumber(startPos));
        Range.Position endPosition = new Range.Position(endPos, this.reader.lineNumber(endPos), this.reader.columnNumber(endPos));
        Range range = new Range(startPosition, endPosition);
        var1_1.attributes().userData(var2_2 != false ? "jsoup.start" : "jsoup.end", var3_3);
    }
}

