/*=========================================================================
*
*  Copyright NumFOCUS
*
*  Licensed under the Apache License, Version 2.0 (the "License");
*  you may not use this file except in compliance with the License.
*  You may obtain a copy of the License at
*
*         http://www.apache.org/licenses/LICENSE-2.0.txt
*
*  Unless required by applicable law or agreed to in writing, software
*  distributed under the License is distributed on an "AS IS" BASIS,
*  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
*  See the License for the specific language governing permissions and
*  limitations under the License.
*
*=========================================================================*/
#ifndef sitkCheckerBoardImageFilter_h
#define sitkCheckerBoardImageFilter_h

/*
 * WARNING: DO NOT EDIT THIS FILE!
 * THIS FILE IS AUTOMATICALLY GENERATED BY THE SIMPLEITK BUILD PROCESS.
 * Please look at sitkImageFilterTemplate.h.in to make changes.
 */

#include <memory>

#include "sitkBasicFilters.h"
#include "sitkImageFilter.h"

namespace itk::simple {

    /**\class CheckerBoardImageFilter
\brief Combines two images in a checkerboard pattern.

CheckerBoardImageFilter takes two input images that must have the same dimension, size, origin and spacing and produces an output image of the same size by combining the pixels from the two input images in a checkerboard pattern. This filter is commonly used for visually comparing two images, in particular for evaluating the results of an image registration process.

This filter is implemented as a multithreaded filter. It provides a DynamicThreadedGenerateData() method for its implementation.
\sa itk::simple::CheckerBoard for the procedural interface
\sa itk::CheckerBoardImageFilter for the Doxygen on the original ITK class.
     */
    class SITKBasicFilters_EXPORT CheckerBoardImageFilter : public ImageFilter {
    public:
      using Self = CheckerBoardImageFilter;

      /** Destructor */
      virtual ~CheckerBoardImageFilter();

      /** Default Constructor that takes no arguments and initializes
       * default parameters */
      CheckerBoardImageFilter();

      /** Define the pixels types supported by this filter */
      using PixelIDTypeList = NonLabelPixelIDTypeList;
\

      /**
       * Set/Get the checker pattern array, i.e. the number of checker boxes per image dimension.
       */
      SITK_RETURN_SELF_TYPE_HEADER SetCheckerPattern ( std::vector<uint32_t> CheckerPattern ) { this->m_CheckerPattern = std::move(CheckerPattern); return *this; }

      /** Set the values of the CheckerPattern vector all to value */
      SITK_RETURN_SELF_TYPE_HEADER SetCheckerPattern( uint32_t value ) { this->m_CheckerPattern = std::vector<uint32_t>(3, value); return *this; }

      /**
       * Set/Get the checker pattern array, i.e. the number of checker boxes per image dimension.
       */
      std::vector<uint32_t> GetCheckerPattern() const { return this->m_CheckerPattern; }

      /** Name of this class */
      std::string GetName() const { return std::string ("CheckerBoardImageFilter"); }

      /** Print ourselves out */
      std::string ToString() const;


      /** Execute the filter on the input images */

      Image Execute ( const Image& image1, const Image& image2 );

    private:

      /** Setup for member function dispatching */

      using MemberFunctionType = Image (Self::*)( const Image& image1, const Image& image2 );
      template <class TImageType> Image ExecuteInternal ( const Image& image1, const Image& image2 );


      friend struct detail::MemberFunctionAddressor<MemberFunctionType>;

      std::unique_ptr<detail::MemberFunctionFactory<MemberFunctionType> > m_MemberFactory;


      std::vector<uint32_t>  m_CheckerPattern{std::vector<uint32_t>(3, 4)};


    };

    /**\
     * \brief Combines two images in a checkerboard pattern.
     *
     * This function directly calls the execute method of CheckerBoardImageFilter
     * in order to support a procedural API
     *
     * \sa itk::simple::CheckerBoardImageFilter for the object oriented interface
     * @{
     */

     SITKBasicFilters_EXPORT Image CheckerBoard ( const Image& image1, const Image& image2, std::vector<uint32_t> checkerPattern = std::vector<uint32_t>(3, 4) );

     /** @} */
}
#endif
