import { SvelteDocument } from '../SvelteDocument';
/**
 * Special svelte syntax tags that do template logic.
 */
export type SvelteLogicTag = 'each' | 'if' | 'await' | 'key' | 'snippet';
/**
 * Special svelte syntax tags.
 */
export type SvelteTag = SvelteLogicTag | 'html' | 'debug' | 'const' | 'render' | 'attach';
/**
 * For each tag, a documentation in markdown format.
 */
export declare const documentation: {
    await: string;
    each: string;
    if: string;
    key: string;
    snippet: string;
    render: string;
    html: string;
    debug: string;
    const: string;
    attach: string;
};
/**
 * Get the last tag that is opened but not closed.
 */
export declare function getLatestOpeningTag(svelteDoc: SvelteDocument, offset: number): SvelteLogicTag | null;
