/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texparserlib;

import com.dickimawbooks.texparserlib.AbstractTeXObject;
import com.dickimawbooks.texparserlib.MultiToken;
import com.dickimawbooks.texparserlib.SingleToken;
import com.dickimawbooks.texparserlib.TeXObjectList;
import com.dickimawbooks.texparserlib.TeXParser;
import com.dickimawbooks.texparserlib.TeXParserUtils;
import java.io.IOException;

public class SpecialToken
extends AbstractTeXObject
implements SingleToken {
    protected MultiToken object;
    protected int charCode;
    protected int catCode;

    public SpecialToken(MultiToken multiToken, int n, int n2) {
        this.object = multiToken;
        this.charCode = n;
        this.catCode = n2;
    }

    @Override
    public Object clone() {
        return new SpecialToken((MultiToken)this.object.clone(), this.charCode, this.catCode);
    }

    public MultiToken getObject() {
        return this.object;
    }

    @Override
    public int getCharCode() {
        return this.charCode;
    }

    @Override
    public int getCatCode() {
        return this.catCode;
    }

    @Override
    public boolean isSingleToken() {
        return true;
    }

    @Override
    public void process(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        this.object.reconstitute(teXParser, teXObjectList).process(teXParser, teXObjectList);
    }

    @Override
    public void process(TeXParser teXParser) throws IOException {
        this.object.reconstitute(teXParser, teXParser).process(teXParser);
    }

    @Override
    public String format() {
        return new String(Character.toChars(this.charCode));
    }

    @Override
    public String toString(TeXParser teXParser) {
        return this.format();
    }

    @Override
    public TeXObjectList string(TeXParser teXParser) throws IOException {
        return TeXParserUtils.createStack(teXParser, teXParser.getListener().getOther(this.charCode));
    }

    public String toString() {
        return String.format("%s[charcode=%d,catcode=%d,object=%s]", this.getClass().getSimpleName(), this.charCode, this.catCode, this.object.toString());
    }
}

