/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.tribes.group.interceptors;

import java.util.HashMap;
import java.util.Map;
import org.apache.catalina.tribes.ChannelException;
import org.apache.catalina.tribes.ChannelMessage;
import org.apache.catalina.tribes.Member;
import org.apache.catalina.tribes.UniqueId;
import org.apache.catalina.tribes.group.ChannelInterceptorBase;
import org.apache.catalina.tribes.group.InterceptorPayload;
import org.apache.catalina.tribes.util.Arrays;
import org.apache.catalina.tribes.util.StringManager;
import org.apache.catalina.tribes.util.UUIDGenerator;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;

public class TwoPhaseCommitInterceptor
extends ChannelInterceptorBase {
    private static final byte[] START_DATA = new byte[]{113, 1, -58, 2, -34, -60, 75, -78, -101, -12, 32, -29, 32, 111, -40, 4};
    private static final byte[] END_DATA = new byte[]{54, -13, 90, 110, 47, -31, 75, -24, -81, -29, 36, 52, -58, 77, -110, 56};
    private static final Log log = LogFactory.getLog(TwoPhaseCommitInterceptor.class);
    protected static final StringManager sm = StringManager.getManager(TwoPhaseCommitInterceptor.class);
    protected final HashMap<UniqueId, MapEntry> messages = new HashMap();
    protected long expire = 60000L;
    protected boolean deepclone = true;

    @Override
    public void sendMessage(Member[] memberArray, ChannelMessage channelMessage, InterceptorPayload interceptorPayload) throws ChannelException {
        if (this.okToProcess(channelMessage.getOptions())) {
            super.sendMessage(memberArray, channelMessage, null);
            ChannelMessage channelMessage2 = this.deepclone ? (ChannelMessage)channelMessage.deepclone() : (ChannelMessage)channelMessage.clone();
            channelMessage2.getMessage().reset();
            UUIDGenerator.randomUUID(false, channelMessage2.getUniqueId(), 0);
            channelMessage2.getMessage().append(START_DATA, 0, START_DATA.length);
            channelMessage2.getMessage().append(channelMessage.getUniqueId(), 0, channelMessage.getUniqueId().length);
            channelMessage2.getMessage().append(END_DATA, 0, END_DATA.length);
            super.sendMessage(memberArray, channelMessage2, interceptorPayload);
        } else {
            super.sendMessage(memberArray, channelMessage, interceptorPayload);
        }
    }

    @Override
    public void messageReceived(ChannelMessage channelMessage) {
        if (this.okToProcess(channelMessage.getOptions())) {
            if (channelMessage.getMessage().getLength() == START_DATA.length + channelMessage.getUniqueId().length + END_DATA.length && Arrays.contains(channelMessage.getMessage().getBytesDirect(), 0, START_DATA, 0, START_DATA.length) && Arrays.contains(channelMessage.getMessage().getBytesDirect(), START_DATA.length + channelMessage.getUniqueId().length, END_DATA, 0, END_DATA.length)) {
                UniqueId uniqueId = new UniqueId(channelMessage.getMessage().getBytesDirect(), START_DATA.length, channelMessage.getUniqueId().length);
                MapEntry mapEntry = this.messages.get(uniqueId);
                if (mapEntry != null) {
                    super.messageReceived(mapEntry.msg);
                    this.messages.remove(uniqueId);
                } else {
                    log.warn((Object)sm.getString("twoPhaseCommitInterceptor.originalMessage.missing", Arrays.toString(uniqueId.getBytes())));
                }
            } else {
                UniqueId uniqueId = new UniqueId(channelMessage.getUniqueId());
                MapEntry mapEntry = new MapEntry((ChannelMessage)channelMessage.deepclone(), uniqueId, System.currentTimeMillis());
                this.messages.put(uniqueId, mapEntry);
            }
        } else {
            super.messageReceived(channelMessage);
        }
    }

    public boolean getDeepclone() {
        return this.deepclone;
    }

    public long getExpire() {
        return this.expire;
    }

    public void setDeepclone(boolean bl) {
        this.deepclone = bl;
    }

    public void setExpire(long l) {
        this.expire = l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void heartbeat() {
        try {
            Map.Entry[] entryArray;
            long l = System.currentTimeMillis();
            for (Map.Entry entry : entryArray = this.messages.entrySet().toArray(new Map.Entry[0])) {
                MapEntry mapEntry = (MapEntry)entry.getValue();
                if (!mapEntry.expired(l, this.expire)) continue;
                log.info((Object)sm.getString("twoPhaseCommitInterceptor.expiredMessage", mapEntry.id));
                this.messages.remove(mapEntry.id);
            }
        }
        catch (Exception exception) {
            log.warn((Object)sm.getString("twoPhaseCommitInterceptor.heartbeat.failed"), (Throwable)exception);
        }
        finally {
            super.heartbeat();
        }
    }

    public static class MapEntry {
        public final ChannelMessage msg;
        public final UniqueId id;
        public final long timestamp;

        public MapEntry(ChannelMessage channelMessage, UniqueId uniqueId, long l) {
            this.msg = channelMessage;
            this.id = uniqueId;
            this.timestamp = l;
        }

        public boolean expired(long l, long l2) {
            return l - this.timestamp > l2;
        }
    }
}

