import { type NumericArgs } from "./modernExtend";
import type { ModernExtend } from "./types";
export interface DevelcoGenBasic {
    attributes: {
        develcoPrimarySwVersion: Buffer;
        develcoPrimaryHwVersion: Buffer;
        develcoLedControl: number;
        develcoTxPower: number;
    };
    commands: never;
    commandResponses: never;
}
export interface DevelcoAirQuality {
    attributes: {
        measuredValue: number;
        minMeasuredValue: number;
        maxMeasuredValue: number;
        resolution: number;
    };
    commands: never;
    commandResponses: never;
}
export interface DevelcoIasZone {
    attributes: {
        develcoZoneStatusInterval: number;
    };
    commands: never;
    commandResponses: never;
}
export declare const develcoModernExtend: {
    addCustomClusterManuSpecificDevelcoGenBasic: () => ModernExtend;
    addCustomClusterManuSpecificDevelcoIasZone: () => ModernExtend;
    addCustomClusterManuSpecificDevelcoAirQuality: () => ModernExtend;
    readGenBasicPrimaryVersions: () => ModernExtend;
    voc: (args?: Partial<NumericArgs<"manuSpecificDevelcoAirQuality", DevelcoAirQuality>>) => ModernExtend;
    airQuality: () => ModernExtend;
    batteryLowAA: () => ModernExtend;
    temperature: (args?: Partial<NumericArgs<"msTemperatureMeasurement">>) => ModernExtend;
    deviceTemperature: (args?: Partial<NumericArgs<"genDeviceTempCfg">>) => ModernExtend;
    currentSummation: (args?: Partial<NumericArgs<"seMetering">>) => ModernExtend;
    pulseConfiguration: (args?: Partial<NumericArgs<"seMetering">>) => ModernExtend;
    ledControl: () => ModernExtend;
    txPower: () => ModernExtend;
    zoneStatusInterval: () => ModernExtend;
    acConnected: () => ModernExtend;
};
//# sourceMappingURL=develco.d.ts.map