import { OTRCPDriver } from "zigbee-on-host";
import type { MACCapabilities, MACHeader } from "zigbee-on-host/dist/zigbee/mac";
import type { ZigbeeAPSHeader, ZigbeeAPSPayload } from "zigbee-on-host/dist/zigbee/zigbee-aps";
import type { ZigbeeNWKGPHeader } from "zigbee-on-host/dist/zigbee/zigbee-nwkgp";
import type { Backup } from "../../../models/backup";
import * as ZSpec from "../../../zspec";
import * as Zcl from "../../../zspec/zcl";
import * as Zdo from "../../../zspec/zdo";
import type * as ZdoTypes from "../../../zspec/zdo/definition/tstypes";
import { Adapter } from "../../adapter";
import type { ZclPayload } from "../../events";
import type * as TsType from "../../tstype";
interface StackConfig {
    /** if true, trigger serial dtr/rts flipping to skip bootloader (meant for TI hw) */
    tiSerialSkipBootloader: boolean;
    /** EUI64 used for the adapter */
    eui64: bigint;
    /** @see https://nerivec.github.io/zigbee-on-host/types/spinel_spinel.StreamRawConfig.html */
    ccaBackoffAttempts: number;
    /** @see https://nerivec.github.io/zigbee-on-host/types/spinel_spinel.StreamRawConfig.html */
    ccaRetries: number;
    /** @see https://nerivec.github.io/zigbee-on-host/types/spinel_spinel.StreamRawConfig.html */
    enableCSMACA: boolean;
}
export interface StackConfigJSON extends Partial<Omit<StackConfig, "eui64">> {
    /** 0x${hex} format */
    eui64?: string;
}
export declare const DEFAULT_STACK_CONFIG: Readonly<StackConfig>;
export declare class ZoHAdapter extends Adapter {
    private serialPort?;
    private socketPort?;
    /** True when adapter is currently closing */
    private closing;
    private interpanLock;
    readonly stackConfig: StackConfig;
    readonly driver: OTRCPDriver;
    private readonly queue;
    private readonly zclWaitress;
    private readonly zdoWaitress;
    constructor(networkOptions: TsType.NetworkOptions, serialPortOptions: TsType.SerialPortOptions, backupPath: string, adapterOptions: TsType.AdapterOptions);
    private loadStackConfig;
    /**
     * Init the serial or socket port and hook parser/writer.
     */
    initPort(): Promise<void>;
    /**
     * Handle port closing
     * @param err A boolean for Socket, an Error for serialport
     */
    private onPortClose;
    /**
     * Handle port error
     * @param error
     */
    private onPortError;
    closePort(): Promise<void>;
    start(): Promise<TsType.StartResult>;
    stop(): Promise<void>;
    getCoordinatorIEEE(): Promise<string>;
    getCoordinatorVersion(): Promise<TsType.CoordinatorVersion>;
    reset(type: "soft" | "hard"): Promise<void>;
    supportsBackup(): Promise<boolean>;
    backup(_ieeeAddressesInDatabase: string[]): Promise<Backup>;
    getNetworkParameters(): Promise<TsType.NetworkParameters>;
    addInstallCode(ieeeAddress: string, key: Buffer, hashed: boolean): Promise<void>;
    waitFor(networkAddress: number, endpoint: number, _frameType: Zcl.FrameType, _direction: Zcl.Direction, transactionSequenceNumber: number | undefined, clusterID: number, commandIdentifier: number, timeout: number): {
        promise: Promise<ZclPayload>;
        cancel: () => void;
    };
    sendZdo(ieeeAddress: string, networkAddress: number, clusterId: Zdo.ClusterId, payload: Buffer, disableResponse: true): Promise<void>;
    sendZdo<K extends keyof ZdoTypes.RequestToResponseMap>(ieeeAddress: string, networkAddress: number, clusterId: K, payload: Buffer, disableResponse: false): Promise<ZdoTypes.RequestToResponseMap[K]>;
    permitJoin(seconds: number, networkAddress?: number): Promise<void>;
    sendZclFrameToEndpoint(ieeeAddr: string, networkAddress: number, endpoint: number, zclFrame: Zcl.Frame, timeout: number, disableResponse: boolean, disableRecovery: boolean, sourceEndpoint?: number, profileId?: number): Promise<ZclPayload | undefined>;
    sendZclFrameToGroup(groupID: number, zclFrame: Zcl.Frame, sourceEndpoint?: number, profileId?: number): Promise<void>;
    sendZclFrameToAll(endpoint: number, zclFrame: Zcl.Frame, sourceEndpoint: number, destination: ZSpec.BroadcastAddress, profileId?: number): Promise<void>;
    setChannelInterPAN(channel: number): Promise<void>;
    sendZclFrameInterPANToIeeeAddr(zclFrame: Zcl.Frame, ieeeAddress: string): Promise<void>;
    sendZclFrameInterPANBroadcast(zclFrame: Zcl.Frame, timeout: number, disableResponse: false): Promise<ZclPayload>;
    sendZclFrameInterPANBroadcast(zclFrame: Zcl.Frame, timeout: number, disableResponse: true): Promise<undefined>;
    restoreChannelInterPAN(): Promise<void>;
    private checkInterpanLock;
    /**
     * @param sender16 If undefined, sender64 is expected defined
     * @param sender64 If undefined, sender16 is expected defined
     * @param apsHeader
     * @param apsPayload
     */
    onFrame(sender16: number | undefined, sender64: bigint | undefined, apsHeader: ZigbeeAPSHeader, apsPayload: ZigbeeAPSPayload, rssi: number): void;
    onGPFrame(cmdId: number, payload: Buffer, macHeader: MACHeader, nwkHeader: ZigbeeNWKGPHeader, rssi: number): void;
    onDeviceJoined(source16: number, source64: bigint, capabilities: MACCapabilities): void;
    onDeviceRejoined(source16: number, source64: bigint, _capabilities: MACCapabilities): void;
    onDeviceLeft(source16: number, source64: bigint): void;
    onDeviceAuthorized(_source16: number, _source64: bigint): void;
    private waitressTimeoutFormatter;
    private zclWaitressValidator;
    private zdoWaitressValidator;
}
export {};
//# sourceMappingURL=zohAdapter.d.ts.map