/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

/*****************************************************************************/
/* This is an automatically generated file. If you're not                    */
/* RootCertificateTelemetryUtils.cpp, you shouldn't be #including it.        */
/*****************************************************************************/

#define HASH_LEN 32
struct CertAuthorityHash {
  // See bug 1338873 about making these fields const.
  uint8_t hash[HASH_LEN];
  int32_t binNumber;
};

static const struct CertAuthorityHash ROOT_TABLE[] = {
  {
    /* DigiCert_TLS_ECC_P384_Root_G5 */
    { 0x01, 0x8E, 0x13, 0xF0, 0x77, 0x25, 0x32, 0xCF, 0x80, 0x9B, 0xD1, 0xB1, 0x72, 0x81, 0x86, 0x72,
      0x83, 0xFC, 0x48, 0xC6, 0xE1, 0x3B, 0xE9, 0xC6, 0x98, 0x12, 0x85, 0x4A, 0x49, 0x0C, 0x1B, 0x05 },
      93 /* Bin Number */
  },
  {
    /* CommScope_Public_Trust_RSA_Root_01 */
    { 0x02, 0xBD, 0xF9, 0x6E, 0x2A, 0x45, 0xDD, 0x9B, 0xF1, 0x8F, 0xC7, 0xE1, 0xDB, 0xDF, 0x21, 0xA0,
      0x37, 0x9B, 0xA3, 0xC9, 0xC2, 0x61, 0x03, 0x44, 0xCF, 0xD8, 0xD6, 0x06, 0xFE, 0xC1, 0xED, 0x81 },
      95 /* Bin Number */
  },
  {
    /* Entrust_Root_Certification_Authority___EC1 */
    { 0x02, 0xED, 0x0E, 0xB2, 0x8C, 0x14, 0xDA, 0x45, 0x16, 0x5C, 0x56, 0x67, 0x91, 0x70, 0x0D, 0x64,
      0x51, 0xD7, 0xFB, 0x56, 0xF0, 0xB2, 0xAB, 0x1D, 0x3B, 0x8E, 0xB0, 0x70, 0xE5, 0x6E, 0xDF, 0xF5 },
      2 /* Bin Number */
  },
  {
    /* AffirmTrust_Commercial */
    { 0x03, 0x76, 0xAB, 0x1D, 0x54, 0xC5, 0xF9, 0x80, 0x3C, 0xE4, 0xB2, 0xE2, 0x01, 0xA0, 0xEE, 0x7E,
      0xEF, 0x7B, 0x57, 0xB6, 0x36, 0xE8, 0xA9, 0x3C, 0x9B, 0x8D, 0x48, 0x60, 0xC9, 0x6F, 0x5F, 0xA7 },
      130 /* Bin Number */
  },
  {
    /* D_TRUST_BR_Root_CA_2_2023 */
    { 0x05, 0x52, 0xE6, 0xF8, 0x3F, 0xDF, 0x65, 0xE8, 0xFA, 0x96, 0x70, 0xE6, 0x66, 0xDF, 0x28, 0xA4,
      0xE2, 0x13, 0x40, 0xB5, 0x10, 0xCB, 0xE5, 0x25, 0x66, 0xF9, 0x7C, 0x4F, 0xB9, 0x4B, 0x2B, 0xD1 },
      154 /* Bin Number */
  },
  {
    /* D_TRUST_EV_Root_CA_1_2020 */
    { 0x08, 0x17, 0x0D, 0x1A, 0xA3, 0x64, 0x53, 0x90, 0x1A, 0x2F, 0x95, 0x92, 0x45, 0xE3, 0x47, 0xDB,
      0x0C, 0x8D, 0x37, 0xAB, 0xAA, 0xBC, 0x56, 0xB8, 0x1A, 0xA1, 0x00, 0xDC, 0x95, 0x89, 0x70, 0xDB },
      111 /* Bin Number */
  },
  {
    /* AffirmTrust_Networking */
    { 0x0A, 0x81, 0xEC, 0x5A, 0x92, 0x97, 0x77, 0xF1, 0x45, 0x90, 0x4A, 0xF3, 0x8D, 0x5D, 0x50, 0x9F,
      0x66, 0xB5, 0xE2, 0xC5, 0x8F, 0xCD, 0xB5, 0x31, 0x05, 0x8B, 0x0E, 0x17, 0xF3, 0xF0, 0xB4, 0x1B },
      129 /* Bin Number */
  },
  {
    /* COMODO_Certification_Authority */
    { 0x0C, 0x2C, 0xD6, 0x3D, 0xF7, 0x80, 0x6F, 0xA3, 0x99, 0xED, 0xE8, 0x09, 0x11, 0x6B, 0x57, 0x5B,
      0xF8, 0x79, 0x89, 0xF0, 0x65, 0x18, 0xF9, 0x80, 0x8C, 0x86, 0x05, 0x03, 0x17, 0x8B, 0xAF, 0x66 },
      26 /* Bin Number */
  },
  {
    /* CommScope_Public_Trust_ECC_Root_01 */
    { 0x11, 0x43, 0x7C, 0xDA, 0x7B, 0xB4, 0x5E, 0x41, 0x36, 0x5F, 0x45, 0xB3, 0x9A, 0x38, 0x98, 0x6B,
      0x0D, 0xE0, 0x0D, 0xEF, 0x34, 0x8E, 0x0C, 0x7B, 0xB0, 0x87, 0x36, 0x33, 0x80, 0x0B, 0xC3, 0x8B },
      97 /* Bin Number */
  },
  {
    /* emSign_Root_CA___C1 */
    { 0x12, 0x56, 0x09, 0xAA, 0x30, 0x1D, 0xA0, 0xA2, 0x49, 0xB9, 0x7A, 0x82, 0x39, 0xCB, 0x6A, 0x34,
      0x21, 0x6F, 0x44, 0xDC, 0xAC, 0x9F, 0x39, 0x54, 0xB1, 0x42, 0x92, 0xF2, 0xE8, 0xC8, 0x60, 0x8F },
      77 /* Bin Number */
  },
  {
    /* OU_Starfield_Class_2_Certification_Authority_O__Starfield_Technologies__Inc___C_US */
    { 0x14, 0x65, 0xFA, 0x20, 0x53, 0x97, 0xB8, 0x76, 0xFA, 0xA6, 0xF0, 0xA9, 0x95, 0x8E, 0x55, 0x90,
      0xE4, 0x0F, 0xCC, 0x7F, 0xAA, 0x4F, 0xB7, 0xC2, 0xC8, 0x67, 0x75, 0x21, 0xFB, 0x5F, 0xB6, 0x58 },
      47 /* Bin Number */
  },
  {
    /* Baltimore_CyberTrust_Root */
    { 0x16, 0xAF, 0x57, 0xA9, 0xF6, 0x76, 0xB0, 0xAB, 0x12, 0x60, 0x95, 0xAA, 0x5E, 0xBA, 0xDE, 0xF2,
      0x2A, 0xB3, 0x11, 0x19, 0xD6, 0x44, 0xAC, 0x95, 0xCD, 0x4B, 0x93, 0xDB, 0xF3, 0xF2, 0x6A, 0xEB },
      71 /* Bin Number */
  },
  {
    /* COMODO_ECC_Certification_Authority */
    { 0x17, 0x93, 0x92, 0x7A, 0x06, 0x14, 0x54, 0x97, 0x89, 0xAD, 0xCE, 0x2F, 0x8F, 0x34, 0xF7, 0xF0,
      0xB6, 0x6D, 0x0F, 0x3A, 0xE3, 0xA3, 0xB8, 0x4D, 0x21, 0xEC, 0x15, 0xDB, 0xBA, 0x4F, 0xAD, 0xC7 },
      18 /* Bin Number */
  },
  {
    /* GlobalSign */
    { 0x17, 0x9F, 0xBC, 0x14, 0x8A, 0x3D, 0xD0, 0x0F, 0xD2, 0x4E, 0xA1, 0x34, 0x58, 0xCC, 0x43, 0xBF,
      0xA7, 0xF5, 0x9C, 0x81, 0x82, 0xD7, 0x83, 0xA5, 0x13, 0xF6, 0xEB, 0xEC, 0x10, 0x0C, 0x89, 0x24 },
      85 /* Bin Number */
  },
  {
    /* Amazon_Root_CA_3 */
    { 0x18, 0xCE, 0x6C, 0xFE, 0x7B, 0xF1, 0x4E, 0x60, 0xB2, 0xE3, 0x47, 0xB8, 0xDF, 0xE8, 0x68, 0xCB,
      0x31, 0xD0, 0x2E, 0xBB, 0x3A, 0xDA, 0x27, 0x15, 0x69, 0xF5, 0x03, 0x43, 0xB4, 0x6D, 0xB3, 0xA4 },
      143 /* Bin Number */
  },
  {
    /* QuoVadis_Root_CA_3 */
    { 0x18, 0xF1, 0xFC, 0x7F, 0x20, 0x5D, 0xF8, 0xAD, 0xDD, 0xEB, 0x7F, 0xE0, 0x07, 0xDD, 0x57, 0xE3,
      0xAF, 0x37, 0x5A, 0x9C, 0x4D, 0x8D, 0x73, 0x54, 0x6B, 0xF4, 0xF1, 0xFE, 0xD1, 0xE1, 0x8D, 0x35 },
      127 /* Bin Number */
  },
  {
    /* Amazon_Root_CA_2 */
    { 0x1B, 0xA5, 0xB2, 0xAA, 0x8C, 0x65, 0x40, 0x1A, 0x82, 0x96, 0x01, 0x18, 0xF8, 0x0B, 0xEC, 0x4F,
      0x62, 0x30, 0x4D, 0x83, 0xCE, 0xC4, 0x71, 0x3A, 0x19, 0xC3, 0x9C, 0x01, 0x1E, 0xA4, 0x6D, 0xB4 },
      144 /* Bin Number */
  },
  {
    /* SSL_com_EV_Root_Certification_Authority_ECC */
    { 0x22, 0xA2, 0xC1, 0xF7, 0xBD, 0xED, 0x70, 0x4C, 0xC1, 0xE7, 0x01, 0xB5, 0xF4, 0x08, 0xC3, 0x10,
      0x88, 0x0F, 0xE9, 0x56, 0xB5, 0xDE, 0x2A, 0x4A, 0x44, 0xF9, 0x9C, 0x87, 0x3A, 0x25, 0xA7, 0xC8 },
      28 /* Bin Number */
  },
  {
    /* Telia_Root_CA_v2 */
    { 0x24, 0x2B, 0x69, 0x74, 0x2F, 0xCB, 0x1E, 0x5B, 0x2A, 0xBF, 0x98, 0x89, 0x8B, 0x94, 0x57, 0x21,
      0x87, 0x54, 0x4E, 0x5B, 0x4D, 0x99, 0x11, 0x78, 0x65, 0x73, 0x62, 0x1F, 0x6A, 0x74, 0xB8, 0x2C },
      131 /* Bin Number */
  },
  {
    /* Security_Communication_RootCA3 */
    { 0x24, 0xA5, 0x5C, 0x2A, 0xB0, 0x51, 0x44, 0x2D, 0x06, 0x17, 0x76, 0x65, 0x41, 0x23, 0x9A, 0x4A,
      0xD0, 0x32, 0xD7, 0xC5, 0x51, 0x75, 0xAA, 0x34, 0xFF, 0xDE, 0x2F, 0xBC, 0x4F, 0x5C, 0x52, 0x94 },
      69 /* Bin Number */
  },
  {
    /* Izenpe_com */
    { 0x25, 0x30, 0xCC, 0x8E, 0x98, 0x32, 0x15, 0x02, 0xBA, 0xD9, 0x6F, 0x9B, 0x1F, 0xBA, 0x1B, 0x09,
      0x9E, 0x2D, 0x29, 0x9E, 0x0F, 0x45, 0x48, 0xBB, 0x91, 0x4F, 0x36, 0x3B, 0xC0, 0xD4, 0x53, 0x1F },
      146 /* Bin Number */
  },
  {
    /* GlobalSign */
    { 0x2C, 0xAB, 0xEA, 0xFE, 0x37, 0xD0, 0x6C, 0xA2, 0x2A, 0xBA, 0x73, 0x91, 0xC0, 0x03, 0x3D, 0x25,
      0x98, 0x29, 0x52, 0xC4, 0x53, 0x64, 0x73, 0x49, 0x76, 0x3A, 0x3A, 0xB5, 0xAD, 0x6C, 0xCF, 0x69 },
      106 /* Bin Number */
  },
  {
    /* Starfield_Root_Certificate_Authority___G2 */
    { 0x2C, 0xE1, 0xCB, 0x0B, 0xF9, 0xD2, 0xF9, 0xE1, 0x02, 0x99, 0x3F, 0xBE, 0x21, 0x51, 0x52, 0xC3,
      0xB2, 0xDD, 0x0C, 0xAB, 0xDE, 0x1C, 0x68, 0xE5, 0x31, 0x9B, 0x83, 0x91, 0x54, 0xDB, 0xB7, 0xF5 },
      13 /* Bin Number */
  },
  {
    /* TunTrust_Root_CA */
    { 0x2E, 0x44, 0x10, 0x2A, 0xB5, 0x8C, 0xB8, 0x54, 0x19, 0x45, 0x1C, 0x8E, 0x19, 0xD9, 0xAC, 0xF3,
      0x66, 0x2C, 0xAF, 0xBC, 0x61, 0x4B, 0x6A, 0x53, 0x96, 0x0A, 0x30, 0xF7, 0xD0, 0xE2, 0xEB, 0x41 },
      62 /* Bin Number */
  },
  {
    /* SSL_com_EV_Root_Certification_Authority_RSA_R2 */
    { 0x2E, 0x7B, 0xF1, 0x6C, 0xC2, 0x24, 0x85, 0xA7, 0xBB, 0xE2, 0xAA, 0x86, 0x96, 0x75, 0x07, 0x61,
      0xB0, 0xAE, 0x39, 0xBE, 0x3B, 0x2F, 0xE9, 0xD0, 0xCC, 0x6D, 0x4E, 0xF7, 0x34, 0x91, 0x42, 0x5C },
      22 /* Bin Number */
  },
  {
    /* CommScope_Public_Trust_ECC_Root_02 */
    { 0x2F, 0xFB, 0x7F, 0x81, 0x3B, 0xBB, 0xB3, 0xC8, 0x9A, 0xB4, 0xE8, 0x16, 0x2D, 0x0F, 0x16, 0xD7,
      0x15, 0x09, 0xA8, 0x30, 0xCC, 0x9D, 0x73, 0xC2, 0x62, 0xE5, 0x14, 0x08, 0x75, 0xD1, 0xAD, 0x4A },
      96 /* Bin Number */
  },
  {
    /* IdenTrust_Public_Sector_Root_CA_1 */
    { 0x30, 0xD0, 0x89, 0x5A, 0x9A, 0x44, 0x8A, 0x26, 0x20, 0x91, 0x63, 0x55, 0x22, 0xD1, 0xF5, 0x20,
      0x10, 0xB5, 0x86, 0x7A, 0xCA, 0xE1, 0x2C, 0x78, 0xEF, 0x95, 0x8F, 0xD4, 0xF4, 0x38, 0x9F, 0x2F },
      101 /* Bin Number */
  },
  {
    /* vTrus_ECC_Root_CA */
    { 0x30, 0xFB, 0xBA, 0x2C, 0x32, 0x23, 0x8E, 0x2A, 0x98, 0x54, 0x7A, 0xF9, 0x79, 0x31, 0xE5, 0x50,
      0x42, 0x8B, 0x9B, 0x3F, 0x1C, 0x8E, 0xEB, 0x66, 0x33, 0xDC, 0xFA, 0x86, 0xC5, 0xB2, 0x7D, 0xD3 },
      120 /* Bin Number */
  },
  {
    /* DigiCert_Global_Root_G3 */
    { 0x31, 0xAD, 0x66, 0x48, 0xF8, 0x10, 0x41, 0x38, 0xC7, 0x38, 0xF3, 0x9E, 0xA4, 0x32, 0x01, 0x33,
      0x39, 0x3E, 0x3A, 0x18, 0xCC, 0x02, 0x29, 0x6E, 0xF9, 0x7C, 0x2A, 0xC9, 0xEF, 0x67, 0x31, 0xD0 },
      59 /* Bin Number */
  },
  {
    /* SSL_com_Root_Certification_Authority_ECC */
    { 0x34, 0x17, 0xBB, 0x06, 0xCC, 0x60, 0x07, 0xDA, 0x1B, 0x96, 0x1C, 0x92, 0x0B, 0x8A, 0xB4, 0xCE,
      0x3F, 0xAD, 0x82, 0x0E, 0x4A, 0xA3, 0x0B, 0x9A, 0xCB, 0xC4, 0xA7, 0x4E, 0xBD, 0xCE, 0xBC, 0x65 },
      31 /* Bin Number */
  },
  {
    /* GTS_Root_R4 */
    { 0x34, 0x9D, 0xFA, 0x40, 0x58, 0xC5, 0xE2, 0x63, 0x12, 0x3B, 0x39, 0x8A, 0xE7, 0x95, 0x57, 0x3C,
      0x4E, 0x13, 0x13, 0xC8, 0x3F, 0xE6, 0x8F, 0x93, 0x55, 0x6C, 0xD5, 0xE8, 0x03, 0x1B, 0x3C, 0x7D },
      116 /* Bin Number */
  },
  {
    /* GTS_Root_R3 */
    { 0x34, 0xD8, 0xA7, 0x3E, 0xE2, 0x08, 0xD9, 0xBC, 0xDB, 0x0D, 0x95, 0x65, 0x20, 0x93, 0x4B, 0x4E,
      0x40, 0xE6, 0x94, 0x82, 0x59, 0x6E, 0x8B, 0x6F, 0x73, 0xC8, 0x42, 0x6B, 0x01, 0x0A, 0x6F, 0x48 },
      117 /* Bin Number */
  },
  {
    /* Microsoft_ECC_Root_Certificate_Authority_2017 */
    { 0x35, 0x8D, 0xF3, 0x9D, 0x76, 0x4A, 0xF9, 0xE1, 0xB7, 0x66, 0xE9, 0xC9, 0x72, 0xDF, 0x35, 0x2E,
      0xE1, 0x5C, 0xFA, 0xC2, 0x27, 0xAF, 0x6A, 0xD1, 0xD7, 0x0E, 0x8E, 0x4A, 0x6E, 0xDC, 0xBA, 0x02 },
      50 /* Bin Number */
  },
  {
    /* DigiCert_TLS_RSA4096_Root_G5 */
    { 0x37, 0x1A, 0x00, 0xDC, 0x05, 0x33, 0xB3, 0x72, 0x1A, 0x7E, 0xEB, 0x40, 0xE8, 0x41, 0x9E, 0x70,
      0x79, 0x9D, 0x2B, 0x0A, 0x0F, 0x2C, 0x1D, 0x80, 0x69, 0x31, 0x65, 0xF7, 0xCE, 0xC4, 0xAD, 0x75 },
      100 /* Bin Number */
  },
  {
    /* Microsec_e_Szigno_Root_CA_2009 */
    { 0x3C, 0x5F, 0x81, 0xFE, 0xA5, 0xFA, 0xB8, 0x2C, 0x64, 0xBF, 0xA2, 0xEA, 0xEC, 0xAF, 0xCD, 0xE8,
      0xE0, 0x77, 0xFC, 0x86, 0x20, 0xA7, 0xCA, 0xE5, 0x37, 0x16, 0x3D, 0xF3, 0x6E, 0xDB, 0xF3, 0x78 },
      23 /* Bin Number */
  },
  {
    /* DigiCert_Assured_ID_Root_CA */
    { 0x3E, 0x90, 0x99, 0xB5, 0x01, 0x5E, 0x8F, 0x48, 0x6C, 0x00, 0xBC, 0xEA, 0x9D, 0x11, 0x1E, 0xE7,
      0x21, 0xFA, 0xBA, 0x35, 0x5A, 0x89, 0xBC, 0xF1, 0xDF, 0x69, 0x56, 0x1E, 0x3D, 0xC6, 0x32, 0x5C },
      53 /* Bin Number */
  },
  {
    /* SecureSign_Root_CA12 */
    { 0x3F, 0x03, 0x4B, 0xB5, 0x70, 0x4D, 0x44, 0xB2, 0xD0, 0x85, 0x45, 0xA0, 0x20, 0x57, 0xDE, 0x93,
      0xEB, 0xF3, 0x90, 0x5F, 0xCE, 0x72, 0x1A, 0xCB, 0xC7, 0x30, 0xC0, 0x6D, 0xDA, 0xEE, 0x90, 0x4E },
      151 /* Bin Number */
  },
  {
    /* TWCA_CYBER_Root_CA */
    { 0x3F, 0x63, 0xBB, 0x28, 0x14, 0xBE, 0x17, 0x4E, 0xC8, 0xB6, 0x43, 0x9C, 0xF0, 0x8D, 0x6D, 0x56,
      0xF0, 0xB7, 0xC4, 0x05, 0x88, 0x3A, 0x56, 0x48, 0xA3, 0x34, 0x42, 0x4D, 0x6B, 0x3E, 0xC5, 0x58 },
      152 /* Bin Number */
  },
  {
    /* HARICA_TLS_ECC_Root_CA_2021 */
    { 0x3F, 0x99, 0xCC, 0x47, 0x4A, 0xCF, 0xCE, 0x4D, 0xFE, 0xD5, 0x87, 0x94, 0x66, 0x5E, 0x47, 0x8D,
      0x15, 0x47, 0x73, 0x9F, 0x2E, 0x78, 0x0F, 0x1B, 0xB4, 0xCA, 0x9B, 0x13, 0x30, 0x97, 0xD4, 0x01 },
      43 /* Bin Number */
  },
  {
    /* emSign_Root_CA___G1 */
    { 0x40, 0xF6, 0xAF, 0x03, 0x46, 0xA9, 0x9A, 0xA1, 0xCD, 0x1D, 0x55, 0x5A, 0x4E, 0x9C, 0xCE, 0x62,
      0xC7, 0xF9, 0x63, 0x46, 0x03, 0xEE, 0x40, 0x66, 0x15, 0x83, 0x3D, 0xC8, 0xC8, 0xD0, 0x03, 0x67 },
      48 /* Bin Number */
  },
  {
    /* Secure_Global_CA */
    { 0x42, 0x00, 0xF5, 0x04, 0x3A, 0xC8, 0x59, 0x0E, 0xBB, 0x52, 0x7D, 0x20, 0x9E, 0xD1, 0x50, 0x30,
      0x29, 0xFB, 0xCB, 0xD4, 0x1C, 0xA1, 0xB5, 0x06, 0xEC, 0x27, 0xF1, 0x5A, 0xDE, 0x7D, 0xAC, 0x69 },
      108 /* Bin Number */
  },
  {
    /* DigiCert_Global_Root_CA */
    { 0x43, 0x48, 0xA0, 0xE9, 0x44, 0x4C, 0x78, 0xCB, 0x26, 0x5E, 0x05, 0x8D, 0x5E, 0x89, 0x44, 0xB4,
      0xD8, 0x4F, 0x96, 0x62, 0xBD, 0x26, 0xDB, 0x25, 0x7F, 0x89, 0x34, 0xA4, 0x43, 0xC7, 0x01, 0x61 },
      61 /* Bin Number */
  },
  {
    /* Entrust_Root_Certification_Authority___G2 */
    { 0x43, 0xDF, 0x57, 0x74, 0xB0, 0x3E, 0x7F, 0xEF, 0x5F, 0xE4, 0x0D, 0x93, 0x1A, 0x7B, 0xED, 0xF1,
      0xBB, 0x2E, 0x6B, 0x42, 0x73, 0x8C, 0x4E, 0x6D, 0x38, 0x41, 0x10, 0x3D, 0x3A, 0xA7, 0xF3, 0x39 },
      4 /* Bin Number */
  },
  {
    /* Hellenic_Academic_and_Research_Institutions_ECC_RootCA_2015 */
    { 0x44, 0xB5, 0x45, 0xAA, 0x8A, 0x25, 0xE6, 0x5A, 0x73, 0xCA, 0x15, 0xDC, 0x27, 0xFC, 0x36, 0xD2,
      0x4C, 0x1C, 0xB9, 0x95, 0x3A, 0x06, 0x65, 0x39, 0xB1, 0x15, 0x82, 0xDC, 0x48, 0x7B, 0x48, 0x33 },
      7 /* Bin Number */
  },
  {
    /* Go_Daddy_Root_Certificate_Authority___G2 */
    { 0x45, 0x14, 0x0B, 0x32, 0x47, 0xEB, 0x9C, 0xC8, 0xC5, 0xB4, 0xF0, 0xD7, 0xB5, 0x30, 0x91, 0xF7,
      0x32, 0x92, 0x08, 0x9E, 0x6E, 0x5A, 0x63, 0xE2, 0x74, 0x9D, 0xD3, 0xAC, 0xA9, 0x19, 0x8E, 0xDA },
      20 /* Bin Number */
  },
  {
    /* TUBITAK_Kamu_SM_SSL_Kok_Sertifikasi___Surum_1 */
    { 0x46, 0xED, 0xC3, 0x68, 0x90, 0x46, 0xD5, 0x3A, 0x45, 0x3F, 0xB3, 0x10, 0x4A, 0xB8, 0x0D, 0xCA,
      0xEC, 0x65, 0x8B, 0x26, 0x60, 0xEA, 0x16, 0x29, 0xDD, 0x7E, 0x86, 0x79, 0x90, 0x64, 0x87, 0x16 },
      1 /* Bin Number */
  },
  {
    /* D_TRUST_Root_Class_3_CA_2_2009 */
    { 0x49, 0xE7, 0xA4, 0x42, 0xAC, 0xF0, 0xEA, 0x62, 0x87, 0x05, 0x00, 0x54, 0xB5, 0x25, 0x64, 0xB6,
      0x50, 0xE4, 0xF4, 0x9E, 0x42, 0xE3, 0x48, 0xD6, 0xAA, 0x38, 0xE0, 0x39, 0xE9, 0x57, 0xB1, 0xC1 },
      102 /* Bin Number */
  },
  {
    /* SecureSign_Root_CA14 */
    { 0x4B, 0x00, 0x9C, 0x10, 0x34, 0x49, 0x4F, 0x9A, 0xB5, 0x6B, 0xBA, 0x3B, 0xA1, 0xD6, 0x27, 0x31,
      0xFC, 0x4D, 0x20, 0xD8, 0x95, 0x5A, 0xDC, 0xEC, 0x10, 0xA9, 0x25, 0x60, 0x72, 0x61, 0xE3, 0x38 },
      150 /* Bin Number */
  },
  {
    /* GlobalSign_Root_R46 */
    { 0x4F, 0xA3, 0x12, 0x6D, 0x8D, 0x3A, 0x11, 0xD1, 0xC4, 0x85, 0x5A, 0x4F, 0x80, 0x7C, 0xBA, 0xD6,
      0xCF, 0x91, 0x9D, 0x3A, 0x5A, 0x88, 0xB0, 0x3B, 0xEA, 0x2C, 0x63, 0x72, 0xD9, 0x3C, 0x40, 0xC9 },
      123 /* Bin Number */
  },
  {
    /* USERTrust_ECC_Certification_Authority */
    { 0x4F, 0xF4, 0x60, 0xD5, 0x4B, 0x9C, 0x86, 0xDA, 0xBF, 0xBC, 0xFC, 0x57, 0x12, 0xE0, 0x40, 0x0D,
      0x2B, 0xED, 0x3F, 0xBC, 0x4D, 0x4F, 0xBD, 0xAA, 0x86, 0xE0, 0x6A, 0xDC, 0xD2, 0xA9, 0xAD, 0x7A },
      15 /* Bin Number */
  },
  {
    /* OU_Security_Communication_RootCA2_O__SECOM_Trust_Systems_CO__LTD___C_JP */
    { 0x51, 0x3B, 0x2C, 0xEC, 0xB8, 0x10, 0xD4, 0xCD, 0xE5, 0xDD, 0x85, 0x39, 0x1A, 0xDF, 0xC6, 0xC2,
      0xDD, 0x60, 0xD8, 0x7B, 0xB7, 0x36, 0xD2, 0xB5, 0x21, 0x48, 0x4A, 0xA4, 0x7A, 0x0E, 0xBE, 0xF6 },
      68 /* Bin Number */
  },
  {
    /* COMODO_RSA_Certification_Authority */
    { 0x52, 0xF0, 0xE1, 0xC4, 0xE5, 0x8E, 0xC6, 0x29, 0x29, 0x1B, 0x60, 0x31, 0x7F, 0x07, 0x46, 0x71,
      0xB8, 0x5D, 0x7E, 0xA8, 0x0D, 0x5B, 0x07, 0x27, 0x34, 0x63, 0x53, 0x4B, 0x32, 0xB4, 0x02, 0x34 },
      17 /* Bin Number */
  },
  {
    /* DigiCert_Trusted_Root_G4 */
    { 0x55, 0x2F, 0x7B, 0xDC, 0xF1, 0xA7, 0xAF, 0x9E, 0x6C, 0xE6, 0x72, 0x01, 0x7F, 0x4F, 0x12, 0xAB,
      0xF7, 0x72, 0x40, 0xC7, 0x8E, 0x76, 0x1A, 0xC2, 0x03, 0xD1, 0xD9, 0xD2, 0x0A, 0xC8, 0x99, 0x88 },
      57 /* Bin Number */
  },
  {
    /* AC_RAIZ_FNMT_RCM_SERVIDORES_SEGUROS */
    { 0x55, 0x41, 0x53, 0xB1, 0x3D, 0x2C, 0xF9, 0xDD, 0xB7, 0x53, 0xBF, 0xBE, 0x1A, 0x4E, 0x0A, 0xE0,
      0x8D, 0x0A, 0xA4, 0x18, 0x70, 0x58, 0xFE, 0x60, 0xA2, 0xB8, 0x62, 0xB2, 0xE4, 0xB8, 0x7B, 0xCB },
      34 /* Bin Number */
  },
  {
    /* Trustwave_Global_ECC_P384_Certification_Authority */
    { 0x55, 0x90, 0x38, 0x59, 0xC8, 0xC0, 0xC3, 0xEB, 0xB8, 0x75, 0x9E, 0xCE, 0x4E, 0x25, 0x57, 0x22,
      0x5F, 0xF5, 0x75, 0x8B, 0xBD, 0x38, 0xEB, 0xD4, 0x82, 0x76, 0x60, 0x1E, 0x1B, 0xD5, 0x80, 0x97 },
      11 /* Bin Number */
  },
  {
    /* Actalis_Authentication_Root_CA */
    { 0x55, 0x92, 0x60, 0x84, 0xEC, 0x96, 0x3A, 0x64, 0xB9, 0x6E, 0x2A, 0xBE, 0x01, 0xCE, 0x0B, 0xA8,
      0x6A, 0x64, 0xFB, 0xFE, 0xBC, 0xC7, 0xAA, 0xB5, 0xAF, 0xC1, 0x55, 0xB3, 0x7F, 0xD7, 0x60, 0x66 },
      44 /* Bin Number */
  },
  {
    /* Starfield_Services_Root_Certificate_Authority___G2 */
    { 0x56, 0x8D, 0x69, 0x05, 0xA2, 0xC8, 0x87, 0x08, 0xA4, 0xB3, 0x02, 0x51, 0x90, 0xED, 0xCF, 0xED,
      0xB1, 0x97, 0x4A, 0x60, 0x6A, 0x13, 0xC6, 0xE5, 0x29, 0x0F, 0xCB, 0x2A, 0xE6, 0x3E, 0xDA, 0xB5 },
      10 /* Bin Number */
  },
  {
    /* BJCA_Global_Root_CA2 */
    { 0x57, 0x4D, 0xF6, 0x93, 0x1E, 0x27, 0x80, 0x39, 0x66, 0x7B, 0x72, 0x0A, 0xFD, 0xC1, 0x60, 0x0F,
      0xC2, 0x7E, 0xB6, 0x6D, 0xD3, 0x09, 0x29, 0x79, 0xFB, 0x73, 0x85, 0x64, 0x87, 0x21, 0x28, 0x82 },
      79 /* Bin Number */
  },
  {
    /* Telekom_Security_TLS_ECC_Root_2020 */
    { 0x57, 0x8A, 0xF4, 0xDE, 0xD0, 0x85, 0x3F, 0x4E, 0x59, 0x98, 0xDB, 0x4A, 0xEA, 0xF9, 0xCB, 0xEA,
      0x8D, 0x94, 0x5F, 0x60, 0xB6, 0x20, 0xA3, 0x8D, 0x1A, 0x3C, 0x13, 0xB2, 0xBC, 0x7B, 0xA8, 0xE1 },
      56 /* Bin Number */
  },
  {
    /* Autoridad_de_Certificacion_Firmaprofesional_CIF_A62634068 */
    { 0x57, 0xDE, 0x05, 0x83, 0xEF, 0xD2, 0xB2, 0x6E, 0x03, 0x61, 0xDA, 0x99, 0xDA, 0x9D, 0xF4, 0x64,
      0x8D, 0xEF, 0x7E, 0xE8, 0x44, 0x1C, 0x3B, 0x72, 0x8A, 0xFA, 0x9B, 0xCD, 0xE0, 0xF9, 0xB2, 0x6A },
      84 /* Bin Number */
  },
  {
    /* TWCA_Global_Root_CA */
    { 0x59, 0x76, 0x90, 0x07, 0xF7, 0x68, 0x5D, 0x0F, 0xCD, 0x50, 0x87, 0x2F, 0x9F, 0x95, 0xD5, 0x75,
      0x5A, 0x5B, 0x2B, 0x45, 0x7D, 0x81, 0xF3, 0x69, 0x2B, 0x61, 0x0A, 0x98, 0x67, 0x2F, 0x0E, 0x1B },
      82 /* Bin Number */
  },
  {
    /* Hongkong_Post_Root_CA_3 */
    { 0x5A, 0x2F, 0xC0, 0x3F, 0x0C, 0x83, 0xB0, 0x90, 0xBB, 0xFA, 0x40, 0x60, 0x4B, 0x09, 0x88, 0x44,
      0x6C, 0x76, 0x36, 0x18, 0x3D, 0xF9, 0x84, 0x6E, 0x17, 0x10, 0x1A, 0x44, 0x7F, 0xB8, 0xEF, 0xD6 },
      37 /* Bin Number */
  },
  {
    /* Certum_Trusted_Network_CA */
    { 0x5C, 0x58, 0x46, 0x8D, 0x55, 0xF5, 0x8E, 0x49, 0x7E, 0x74, 0x39, 0x82, 0xD2, 0xB5, 0x00, 0x10,
      0xB6, 0xD1, 0x65, 0x37, 0x4A, 0xCF, 0x83, 0xA7, 0xD4, 0xA3, 0x2D, 0xB7, 0x68, 0xC4, 0x40, 0x8E },
      29 /* Bin Number */
  },
  {
    /* CFCA_EV_ROOT */
    { 0x5C, 0xC3, 0xD7, 0x8E, 0x4E, 0x1D, 0x5E, 0x45, 0x54, 0x7A, 0x04, 0xE6, 0x87, 0x3E, 0x64, 0xF9,
      0x0C, 0xF9, 0x53, 0x6D, 0x1C, 0xCC, 0x2E, 0xF8, 0x00, 0xF3, 0x55, 0xC4, 0xC5, 0xFD, 0x70, 0xFD },
      78 /* Bin Number */
  },
  {
    /* IdenTrust_Commercial_Root_CA_1 */
    { 0x5D, 0x56, 0x49, 0x9B, 0xE4, 0xD2, 0xE0, 0x8B, 0xCF, 0xCA, 0xD0, 0x8A, 0x3E, 0x38, 0x72, 0x3D,
      0x50, 0x50, 0x3B, 0xDE, 0x70, 0x69, 0x48, 0xE4, 0x2F, 0x55, 0x60, 0x30, 0x19, 0xE5, 0x28, 0xAE },
      109 /* Bin Number */
  },
  {
    /* SwissSign_Gold_CA___G2 */
    { 0x62, 0xDD, 0x0B, 0xE9, 0xB9, 0xF5, 0x0A, 0x16, 0x3E, 0xA0, 0xF8, 0xE7, 0x5C, 0x05, 0x3B, 0x1E,
      0xCA, 0x57, 0xEA, 0x55, 0xC8, 0x68, 0x8F, 0x64, 0x7C, 0x68, 0x81, 0xF2, 0xC8, 0x35, 0x7B, 0x95 },
      126 /* Bin Number */
  },
  {
    /* OU_certSIGN_ROOT_CA_G2_O_CERTSIGN_SA_C_RO */
    { 0x65, 0x7C, 0xFE, 0x2F, 0xA7, 0x3F, 0xAA, 0x38, 0x46, 0x25, 0x71, 0xF3, 0x32, 0xA2, 0x36, 0x3A,
      0x46, 0xFC, 0xE7, 0x02, 0x09, 0x51, 0x71, 0x07, 0x02, 0xCD, 0xFB, 0xB6, 0xEE, 0xDA, 0x33, 0x05 },
      135 /* Bin Number */
  },
  {
    /* ISRG_Root_X2 */
    { 0x69, 0x72, 0x9B, 0x8E, 0x15, 0xA8, 0x6E, 0xFC, 0x17, 0x7A, 0x57, 0xAF, 0xB7, 0x17, 0x1D, 0xFC,
      0x64, 0xAD, 0xD2, 0x8C, 0x2F, 0xCA, 0x8C, 0xF1, 0x50, 0x7E, 0x34, 0x45, 0x3C, 0xCB, 0x14, 0x70 },
      88 /* Bin Number */
  },
  {
    /* Certum_EC_384_CA */
    { 0x6B, 0x32, 0x80, 0x85, 0x62, 0x53, 0x18, 0xAA, 0x50, 0xD1, 0x73, 0xC9, 0x8D, 0x8B, 0xDA, 0x09,
      0xD5, 0x7E, 0x27, 0x41, 0x3D, 0x11, 0x4C, 0xF7, 0x87, 0xA0, 0xF5, 0xD0, 0x6C, 0x03, 0x0C, 0xF6 },
      35 /* Bin Number */
  },
  {
    /* OISTE_WISeKey_Global_Root_GB_CA */
    { 0x6B, 0x9C, 0x08, 0xE8, 0x6E, 0xB0, 0xF7, 0x67, 0xCF, 0xAD, 0x65, 0xCD, 0x98, 0xB6, 0x21, 0x49,
      0xE5, 0x49, 0x4A, 0x67, 0xF5, 0x84, 0x5E, 0x7B, 0xD1, 0xED, 0x01, 0x9F, 0x27, 0xB8, 0x6B, 0xD6 },
      40 /* Bin Number */
  },
  {
    /* NetLock_Arany__Class_Gold__F_tan_s_tv_ny */
    { 0x6C, 0x61, 0xDA, 0xC3, 0xA2, 0xDE, 0xF0, 0x31, 0x50, 0x6B, 0xE0, 0x36, 0xD2, 0xA6, 0xFE, 0x40,
      0x19, 0x94, 0xFB, 0xD1, 0x3D, 0xF9, 0xC8, 0xD4, 0x66, 0x59, 0x92, 0x74, 0xC4, 0x46, 0xEC, 0x98 },
      8 /* Bin Number */
  },
  {
    /* Entrust_net_Certification_Authority__2048_ */
    { 0x6D, 0xC4, 0x71, 0x72, 0xE0, 0x1C, 0xBC, 0xB0, 0xBF, 0x62, 0x58, 0x0D, 0x89, 0x5F, 0xE2, 0xB8,
      0xAC, 0x9A, 0xD4, 0xF8, 0x73, 0x80, 0x1E, 0x0C, 0x10, 0xB9, 0xC8, 0x37, 0xD2, 0x1E, 0xB1, 0x77 },
      5 /* Bin Number */
  },
  {
    /* AffirmTrust_Premium */
    { 0x70, 0xA7, 0x3F, 0x7F, 0x37, 0x6B, 0x60, 0x07, 0x42, 0x48, 0x90, 0x45, 0x34, 0xB1, 0x14, 0x82,
      0xD5, 0xBF, 0x0E, 0x69, 0x8E, 0xCC, 0x49, 0x8D, 0xF5, 0x25, 0x77, 0xEB, 0xF2, 0xE9, 0x3B, 0x9A },
      134 /* Bin Number */
  },
  {
    /* Entrust_Root_Certification_Authority */
    { 0x73, 0xC1, 0x76, 0x43, 0x4F, 0x1B, 0xC6, 0xD5, 0xAD, 0xF4, 0x5B, 0x0E, 0x76, 0xE7, 0x27, 0x28,
      0x7C, 0x8D, 0xE5, 0x76, 0x16, 0xC1, 0xE6, 0xE6, 0x14, 0x1A, 0x2B, 0x2C, 0xBC, 0x7D, 0x8E, 0x4C },
      6 /* Bin Number */
  },
  {
    /* DigiCert_High_Assurance_EV_Root_CA */
    { 0x74, 0x31, 0xE5, 0xF4, 0xC3, 0xC1, 0xCE, 0x46, 0x90, 0x77, 0x4F, 0x0B, 0x61, 0xE0, 0x54, 0x40,
      0x88, 0x3B, 0xA9, 0xA0, 0x1E, 0xD0, 0x0B, 0xA6, 0xAB, 0xD7, 0x80, 0x6E, 0xD3, 0xB1, 0x18, 0xCF },
      41 /* Bin Number */
  },
  {
    /* Certainly_Root_R1 */
    { 0x77, 0xB8, 0x2C, 0xD8, 0x64, 0x4C, 0x43, 0x05, 0xF7, 0xAC, 0xC5, 0xCB, 0x15, 0x6B, 0x45, 0x67,
      0x50, 0x04, 0x03, 0x3D, 0x51, 0xC6, 0x0C, 0x62, 0x02, 0xA8, 0xE0, 0xC3, 0x34, 0x67, 0xD3, 0xA0 },
      136 /* Bin Number */
  },
  {
    /* Sectigo_Public_Server_Authentication_Root_R46 */
    { 0x7B, 0xB6, 0x47, 0xA6, 0x2A, 0xEE, 0xAC, 0x88, 0xBF, 0x25, 0x7A, 0xA5, 0x22, 0xD0, 0x1F, 0xFE,
      0xA3, 0x95, 0xE0, 0xAB, 0x45, 0xC7, 0x3F, 0x93, 0xF6, 0x56, 0x54, 0xEC, 0x38, 0xF2, 0x5A, 0x06 },
      65 /* Bin Number */
  },
  {
    /* DigiCert_Assured_ID_Root_G2 */
    { 0x7D, 0x05, 0xEB, 0xB6, 0x82, 0x33, 0x9F, 0x8C, 0x94, 0x51, 0xEE, 0x09, 0x4E, 0xEB, 0xFE, 0xFA,
      0x79, 0x53, 0xA1, 0x14, 0xED, 0xB2, 0xF4, 0x49, 0x49, 0x45, 0x2F, 0xAB, 0x7D, 0x2F, 0xC1, 0x85 },
      52 /* Bin Number */
  },
  {
    /* DigiCert_Assured_ID_Root_G3 */
    { 0x7E, 0x37, 0xCB, 0x8B, 0x4C, 0x47, 0x09, 0x0C, 0xAB, 0x36, 0x55, 0x1B, 0xA6, 0xF4, 0x5D, 0xB8,
      0x40, 0x68, 0x0F, 0xBA, 0x16, 0x6A, 0x95, 0x2D, 0xB1, 0x00, 0x71, 0x7F, 0x43, 0x05, 0x3F, 0xC2 },
      51 /* Bin Number */
  },
  {
    /* Atos_TrustedRoot_Root_CA_RSA_TLS_2021 */
    { 0x81, 0xA9, 0x08, 0x8E, 0xA5, 0x9F, 0xB3, 0x64, 0xC5, 0x48, 0xA6, 0xF8, 0x55, 0x59, 0x09, 0x9B,
      0x6F, 0x04, 0x05, 0xEF, 0xBF, 0x18, 0xE5, 0x32, 0x4E, 0xC9, 0xF4, 0x57, 0xBA, 0x00, 0x11, 0x2F },
      104 /* Bin Number */
  },
  {
    /* OISTE_WISeKey_Global_Root_GC_CA */
    { 0x85, 0x60, 0xF9, 0x1C, 0x36, 0x24, 0xDA, 0xBA, 0x95, 0x70, 0xB5, 0xFE, 0xA0, 0xDB, 0xE3, 0x6F,
      0xF1, 0x1A, 0x83, 0x23, 0xBE, 0x94, 0x86, 0x85, 0x4F, 0xB3, 0xF3, 0x4A, 0x55, 0x71, 0x19, 0x8D },
      39 /* Bin Number */
  },
  {
    /* SSL_com_Root_Certification_Authority_RSA */
    { 0x85, 0x66, 0x6A, 0x56, 0x2E, 0xE0, 0xBE, 0x5C, 0xE9, 0x25, 0xC1, 0xD8, 0x89, 0x0A, 0x6F, 0x76,
      0xA8, 0x7E, 0xC1, 0x6D, 0x4D, 0x7D, 0x5F, 0x29, 0xEA, 0x74, 0x19, 0xCF, 0x20, 0x12, 0x3B, 0x69 },
      30 /* Bin Number */
  },
  {
    /* QuoVadis_Root_CA_2 */
    { 0x85, 0xA0, 0xDD, 0x7D, 0xD7, 0x20, 0xAD, 0xB7, 0xFF, 0x05, 0xF8, 0x3D, 0x54, 0x2B, 0x20, 0x9D,
      0xC7, 0xFF, 0x45, 0x28, 0xF7, 0xD6, 0x77, 0xB1, 0x83, 0x89, 0xFE, 0xA5, 0xE5, 0xC4, 0x9E, 0x86 },
      128 /* Bin Number */
  },
  {
    /* emSign_ECC_Root_CA___G3 */
    { 0x86, 0xA1, 0xEC, 0xBA, 0x08, 0x9C, 0x4A, 0x8D, 0x3B, 0xBE, 0x27, 0x34, 0xC6, 0x12, 0xBA, 0x34,
      0x1D, 0x81, 0x3E, 0x04, 0x3C, 0xF9, 0xE8, 0xA8, 0x62, 0xCD, 0x5C, 0x57, 0xA3, 0x6B, 0xBE, 0x6B },
      45 /* Bin Number */
  },
  {
    /* QuoVadis_Root_CA_3_G3 */
    { 0x88, 0xEF, 0x81, 0xDE, 0x20, 0x2E, 0xB0, 0x18, 0x45, 0x2E, 0x43, 0xF8, 0x64, 0x72, 0x5C, 0xEA,
      0x5F, 0xBD, 0x1F, 0xC2, 0xD9, 0xD2, 0x05, 0x73, 0x07, 0x09, 0xC5, 0xD8, 0xB8, 0x69, 0x0F, 0x46 },
      113 /* Bin Number */
  },
  {
    /* NAVER_Global_Root_Certification_Authority */
    { 0x88, 0xF4, 0x38, 0xDC, 0xF8, 0xFF, 0xD1, 0xFA, 0x8F, 0x42, 0x91, 0x15, 0xFF, 0xE5, 0xF8, 0x2A,
      0xE1, 0xE0, 0x6E, 0x0C, 0x70, 0xC3, 0x75, 0xFA, 0xAD, 0x71, 0x7B, 0x34, 0xA4, 0x9E, 0x72, 0x65 },
      46 /* Bin Number */
  },
  {
    /* vTrus_Root_CA */
    { 0x8A, 0x71, 0xDE, 0x65, 0x59, 0x33, 0x6F, 0x42, 0x6C, 0x26, 0xE5, 0x38, 0x80, 0xD0, 0x0D, 0x88,
      0xA1, 0x8D, 0xA4, 0xC6, 0xA9, 0x1F, 0x0D, 0xCB, 0x61, 0x94, 0xE2, 0x06, 0xC5, 0xC9, 0x63, 0x87 },
      132 /* Bin Number */
  },
  {
    /* QuoVadis_Root_CA_1_G3 */
    { 0x8A, 0x86, 0x6F, 0xD1, 0xB2, 0x76, 0xB5, 0x7E, 0x57, 0x8E, 0x92, 0x1C, 0x65, 0x82, 0x8A, 0x2B,
      0xED, 0x58, 0xE9, 0xF2, 0xF2, 0x88, 0x05, 0x41, 0x34, 0xB7, 0xF1, 0xF4, 0xBF, 0xC9, 0xCC, 0x74 },
      115 /* Bin Number */
  },
  {
    /* GTS_Root_R2 */
    { 0x8D, 0x25, 0xCD, 0x97, 0x22, 0x9D, 0xBF, 0x70, 0x35, 0x6B, 0xDA, 0x4E, 0xB3, 0xCC, 0x73, 0x40,
      0x31, 0xE2, 0x4C, 0xF0, 0x0F, 0xAF, 0xCF, 0xD3, 0x2D, 0xC7, 0x6E, 0xB5, 0x84, 0x1C, 0x7E, 0xA8 },
      118 /* Bin Number */
  },
  {
    /* D_TRUST_EV_Root_CA_2_2023 */
    { 0x8E, 0x82, 0x21, 0xB2, 0xE7, 0xD4, 0x00, 0x78, 0x36, 0xA1, 0x67, 0x2F, 0x0D, 0xCC, 0x29, 0x9C,
      0x33, 0xBC, 0x07, 0xD3, 0x16, 0xF1, 0x32, 0xFA, 0x1A, 0x20, 0x6D, 0x58, 0x71, 0x50, 0xF1, 0xCE },
      153 /* Bin Number */
  },
  {
    /* Amazon_Root_CA_1 */
    { 0x8E, 0xCD, 0xE6, 0x88, 0x4F, 0x3D, 0x87, 0xB1, 0x12, 0x5B, 0xA3, 0x1A, 0xC3, 0xFC, 0xB1, 0x3D,
      0x70, 0x16, 0xDE, 0x7F, 0x57, 0xCC, 0x90, 0x4F, 0xE1, 0xCB, 0x97, 0xC6, 0xAE, 0x98, 0x19, 0x6E },
      145 /* Bin Number */
  },
  {
    /* SSL_com_TLS_RSA_Root_CA_2022 */
    { 0x8F, 0xAF, 0x7D, 0x2E, 0x2C, 0xB4, 0x70, 0x9B, 0xB8, 0xE0, 0xB3, 0x36, 0x66, 0xBF, 0x75, 0xA5,
      0xDD, 0x45, 0xB5, 0xDE, 0x48, 0x0F, 0x8E, 0xA8, 0xD4, 0xBF, 0xE6, 0xBE, 0xBC, 0x17, 0xF2, 0xED },
      91 /* Bin Number */
  },
  {
    /* QuoVadis_Root_CA_2_G3 */
    { 0x8F, 0xE4, 0xFB, 0x0A, 0xF9, 0x3A, 0x4D, 0x0D, 0x67, 0xDB, 0x0B, 0xEB, 0xB2, 0x3E, 0x37, 0xC7,
      0x1B, 0xF3, 0x25, 0xDC, 0xBC, 0xDD, 0x24, 0x0E, 0xA0, 0x4D, 0xAF, 0x58, 0xB4, 0x7E, 0x18, 0x40 },
      114 /* Bin Number */
  },
  {
    /* T_TeleSec_GlobalRoot_Class_2 */
    { 0x91, 0xE2, 0xF5, 0x78, 0x8D, 0x58, 0x10, 0xEB, 0xA7, 0xBA, 0x58, 0x73, 0x7D, 0xE1, 0x54, 0x8A,
      0x8E, 0xCA, 0xCD, 0x01, 0x45, 0x98, 0xBC, 0x0B, 0x14, 0x3E, 0x04, 0x1B, 0x17, 0x05, 0x25, 0x52 },
      25 /* Bin Number */
  },
  {
    /* Trustwave_Global_ECC_P256_Certification_Authority */
    { 0x94, 0x5B, 0xBC, 0x82, 0x5E, 0xA5, 0x54, 0xF4, 0x89, 0xD1, 0xFD, 0x51, 0xA7, 0x3D, 0xDF, 0x2E,
      0xA6, 0x24, 0xAC, 0x70, 0x19, 0xA0, 0x52, 0x05, 0x22, 0x5C, 0x22, 0xA7, 0x8C, 0xCF, 0xA8, 0xB4 },
      12 /* Bin Number */
  },
  {
    /* ISRG_Root_X1 */
    { 0x96, 0xBC, 0xEC, 0x06, 0x26, 0x49, 0x76, 0xF3, 0x74, 0x60, 0x77, 0x9A, 0xCF, 0x28, 0xC5, 0xA7,
      0xCF, 0xE8, 0xA3, 0xC0, 0xAA, 0xE1, 0x1A, 0x8F, 0xFC, 0xEE, 0x05, 0xC0, 0xBD, 0xDF, 0x08, 0xC6 },
      89 /* Bin Number */
  },
  {
    /* Trustwave_Global_Certification_Authority */
    { 0x97, 0x55, 0x20, 0x15, 0xF5, 0xDD, 0xFC, 0x3C, 0x87, 0x88, 0xC0, 0x06, 0x94, 0x45, 0x55, 0x40,
      0x88, 0x94, 0x45, 0x00, 0x84, 0xF1, 0x00, 0x86, 0x70, 0x86, 0xBC, 0x1A, 0x2B, 0xB5, 0x8D, 0xC8 },
      16 /* Bin Number */
  },
  {
    /* Buypass_Class_2_Root_CA */
    { 0x9A, 0x11, 0x40, 0x25, 0x19, 0x7C, 0x5B, 0xB9, 0x5D, 0x94, 0xE6, 0x3D, 0x55, 0xCD, 0x43, 0x79,
      0x08, 0x47, 0xB6, 0x46, 0xB2, 0x3C, 0xDF, 0x11, 0xAD, 0xA4, 0xA0, 0x0E, 0xFF, 0x15, 0xFB, 0x48 },
      99 /* Bin Number */
  },
  {
    /* GLOBALTRUST_2020 */
    { 0x9A, 0x29, 0x6A, 0x51, 0x82, 0xD1, 0xD4, 0x51, 0xA2, 0xE3, 0x7F, 0x43, 0x9B, 0x74, 0xDA, 0xAF,
      0xA2, 0x67, 0x52, 0x33, 0x29, 0xF9, 0x0F, 0x9A, 0x0D, 0x20, 0x07, 0xC3, 0x34, 0xE2, 0x3C, 0x9A },
      103 /* Bin Number */
  },
  {
    /* ACCVRAIZ1 */
    { 0x9A, 0x6E, 0xC0, 0x12, 0xE1, 0xA7, 0xDA, 0x9D, 0xBE, 0x34, 0x19, 0x4D, 0x47, 0x8A, 0xD7, 0xC0,
      0xDB, 0x18, 0x22, 0xFB, 0x07, 0x1D, 0xF1, 0x29, 0x81, 0x49, 0x6E, 0xD1, 0x04, 0x38, 0x41, 0x13 },
      133 /* Bin Number */
  },
  {
    /* UCA_Global_G2_Root */
    { 0x9B, 0xEA, 0x11, 0xC9, 0x76, 0xFE, 0x01, 0x47, 0x64, 0xC1, 0xBE, 0x56, 0xA6, 0xF9, 0x14, 0xB5,
      0xA5, 0x60, 0x31, 0x7A, 0xBD, 0x99, 0x88, 0x39, 0x33, 0x82, 0xE5, 0x16, 0x1A, 0xA0, 0x49, 0x3C },
      138 /* Bin Number */
  },
  {
    /* Hellenic_Academic_and_Research_Institutions_RootCA_2015 */
    { 0xA0, 0x40, 0x92, 0x9A, 0x02, 0xCE, 0x53, 0xB4, 0xAC, 0xF4, 0xF2, 0xFF, 0xC6, 0x98, 0x1C, 0xE4,
      0x49, 0x6F, 0x75, 0x5E, 0x6D, 0x45, 0xFE, 0x0B, 0x2A, 0x69, 0x2B, 0xCD, 0x52, 0x52, 0x3F, 0x36 },
      9 /* Bin Number */
  },
  {
    /* SZAFIR_ROOT_CA2 */
    { 0xA1, 0x33, 0x9D, 0x33, 0x28, 0x1A, 0x0B, 0x56, 0xE5, 0x57, 0xD3, 0xD3, 0x2B, 0x1C, 0xE7, 0xF9,
      0x36, 0x7E, 0xB0, 0x94, 0xBD, 0x5F, 0xA7, 0x2A, 0x7E, 0x50, 0x04, 0xC8, 0xDE, 0xD7, 0xCA, 0xFE },
      83 /* Bin Number */
  },
  {
    /* GlobalSign */
    { 0xB0, 0x85, 0xD7, 0x0B, 0x96, 0x4F, 0x19, 0x1A, 0x73, 0xE4, 0xAF, 0x0D, 0x54, 0xAE, 0x7A, 0x0E,
      0x07, 0xAA, 0xFD, 0xAF, 0x9B, 0x71, 0xDD, 0x08, 0x62, 0x13, 0x8A, 0xB7, 0x32, 0x5A, 0x24, 0xA2 },
      86 /* Bin Number */
  },
  {
    /* Atos_TrustedRoot_Root_CA_ECC_TLS_2021 */
    { 0xB2, 0xFA, 0xE5, 0x3E, 0x14, 0xCC, 0xD7, 0xAB, 0x92, 0x12, 0x06, 0x47, 0x01, 0xAE, 0x27, 0x9C,
      0x1D, 0x89, 0x88, 0xFA, 0xCB, 0x77, 0x5F, 0xA8, 0xA0, 0x08, 0x91, 0x4E, 0x66, 0x39, 0x88, 0xA8 },
      105 /* Bin Number */
  },
  {
    /* Certainly_Root_E1 */
    { 0xB4, 0x58, 0x5F, 0x22, 0xE4, 0xAC, 0x75, 0x6A, 0x4E, 0x86, 0x12, 0xA1, 0x36, 0x1C, 0x5D, 0x9D,
      0x03, 0x1A, 0x93, 0xFD, 0x84, 0xFE, 0xBB, 0x77, 0x8F, 0xA3, 0x06, 0x8B, 0x0F, 0xC4, 0x2D, 0xC2 },
      137 /* Bin Number */
  },
  {
    /* Certum_Trusted_Network_CA_2 */
    { 0xB6, 0x76, 0xF2, 0xED, 0xDA, 0xE8, 0x77, 0x5C, 0xD3, 0x6C, 0xB0, 0xF6, 0x3C, 0xD1, 0xD4, 0x60,
      0x39, 0x61, 0xF4, 0x9E, 0x62, 0x65, 0xBA, 0x01, 0x3A, 0x2F, 0x03, 0x07, 0xB6, 0xD0, 0xB8, 0x04 },
      27 /* Bin Number */
  },
  {
    /* emSign_ECC_Root_CA___C3 */
    { 0xBC, 0x4D, 0x80, 0x9B, 0x15, 0x18, 0x9D, 0x78, 0xDB, 0x3E, 0x1D, 0x8C, 0xF4, 0xF9, 0x72, 0x6A,
      0x79, 0x5D, 0xA1, 0x64, 0x3C, 0xA5, 0xF1, 0x35, 0x8E, 0x1D, 0xDB, 0x0E, 0xDC, 0x0D, 0x7E, 0xB3 },
      70 /* Bin Number */
  },
  {
    /* AffirmTrust_Premium_ECC */
    { 0xBD, 0x71, 0xFD, 0xF6, 0xDA, 0x97, 0xE4, 0xCF, 0x62, 0xD1, 0x64, 0x7A, 0xDD, 0x25, 0x81, 0xB0,
      0x7D, 0x79, 0xAD, 0xF8, 0x39, 0x7E, 0xB4, 0xEC, 0xBA, 0x9C, 0x5E, 0x84, 0x88, 0x82, 0x14, 0x23 },
      125 /* Bin Number */
  },
  {
    /* TrustAsia_Global_Root_CA_G4 */
    { 0xBE, 0x4B, 0x56, 0xCB, 0x50, 0x56, 0xC0, 0x13, 0x6A, 0x52, 0x6D, 0xF4, 0x44, 0x50, 0x8D, 0xAA,
      0x36, 0xA0, 0xB5, 0x4F, 0x42, 0xE4, 0xAC, 0x38, 0xF7, 0x2A, 0xF4, 0x70, 0xE4, 0x79, 0x65, 0x4C },
      73 /* Bin Number */
  },
  {
    /* SwissSign_Silver_CA___G2 */
    { 0xBE, 0x6C, 0x4D, 0xA2, 0xBB, 0xB9, 0xBA, 0x59, 0xB6, 0xF3, 0x93, 0x97, 0x68, 0x37, 0x42, 0x46,
      0xC3, 0xC0, 0x05, 0x99, 0x3F, 0xA9, 0x8F, 0x02, 0x0D, 0x1D, 0xED, 0xBE, 0xD4, 0x8A, 0x81, 0xD5 },
      122 /* Bin Number */
  },
  {
    /* e_Szigno_Root_CA_2017 */
    { 0xBE, 0xB0, 0x0B, 0x30, 0x83, 0x9B, 0x9B, 0xC3, 0x2C, 0x32, 0xE4, 0x44, 0x79, 0x05, 0x95, 0x06,
      0x41, 0xF2, 0x64, 0x21, 0xB1, 0x5E, 0xD0, 0x89, 0x19, 0x8B, 0x51, 0x8A, 0xE2, 0xEA, 0x1B, 0x99 },
      36 /* Bin Number */
  },
  {
    /* FIRMAPROFESIONAL_CA_ROOT_A_WEB */
    { 0xBE, 0xF2, 0x56, 0xDA, 0xF2, 0x6E, 0x9C, 0x69, 0xBD, 0xEC, 0x16, 0x02, 0x35, 0x97, 0x98, 0xF3,
      0xCA, 0xF7, 0x18, 0x21, 0xA0, 0x3E, 0x01, 0x82, 0x57, 0xC5, 0x3C, 0x65, 0x61, 0x7F, 0x3D, 0x4A },
      38 /* Bin Number */
  },
  {
    /* SecureSign_RootCA11 */
    { 0xBF, 0x0F, 0xEE, 0xFB, 0x9E, 0x3A, 0x58, 0x1A, 0xD5, 0xF9, 0xE9, 0xDB, 0x75, 0x89, 0x98, 0x57,
      0x43, 0xD2, 0x61, 0x08, 0x5C, 0x4D, 0x31, 0x4F, 0x6F, 0x5D, 0x72, 0x59, 0xAA, 0x42, 0x16, 0x12 },
      75 /* Bin Number */
  },
  {
    /* TWCA_Root_Certification_Authority */
    { 0xBF, 0xD8, 0x8F, 0xE1, 0x10, 0x1C, 0x41, 0xAE, 0x3E, 0x80, 0x1B, 0xF8, 0xBE, 0x56, 0x35, 0x0E,
      0xE9, 0xBA, 0xD1, 0xA6, 0xB9, 0xBD, 0x51, 0x5E, 0xDC, 0x5C, 0x6D, 0x5B, 0x87, 0x11, 0xAC, 0x44 },
      64 /* Bin Number */
  },
  {
    /* GDCA_TrustAUTH_R5_ROOT */
    { 0xBF, 0xFF, 0x8F, 0xD0, 0x44, 0x33, 0x48, 0x7D, 0x6A, 0x8A, 0xA6, 0x0C, 0x1A, 0x29, 0x76, 0x7A,
      0x9F, 0xC2, 0xBB, 0xB0, 0x5E, 0x42, 0x0F, 0x71, 0x3A, 0x13, 0xB9, 0x92, 0x89, 0x1D, 0x38, 0x93 },
      58 /* Bin Number */
  },
  {
    /* OU_ePKI_Root_Certification_Authority_O__Chunghwa_Telecom_Co___Ltd___C_TW */
    { 0xC0, 0xA6, 0xF4, 0xDC, 0x63, 0xA2, 0x4B, 0xFD, 0xCF, 0x54, 0xEF, 0x2A, 0x6A, 0x08, 0x2A, 0x0A,
      0x72, 0xDE, 0x35, 0x80, 0x3E, 0x2F, 0xF5, 0xFF, 0x52, 0x7A, 0xE5, 0xD8, 0x72, 0x06, 0xDF, 0xD5 },
      67 /* Bin Number */
  },
  {
    /* SSL_com_TLS_ECC_Root_CA_2022 */
    { 0xC3, 0x2F, 0xFD, 0x9F, 0x46, 0xF9, 0x36, 0xD1, 0x6C, 0x36, 0x73, 0x99, 0x09, 0x59, 0x43, 0x4B,
      0x9A, 0xD6, 0x0A, 0xAF, 0xBB, 0x9E, 0x7C, 0xF3, 0x36, 0x54, 0xF1, 0x44, 0xCC, 0x1B, 0xA1, 0x43 },
      92 /* Bin Number */
  },
  {
    /* OU_Go_Daddy_Class_2_Certification_Authority_O__The_Go_Daddy_Group__Inc___C_US */
    { 0xC3, 0x84, 0x6B, 0xF2, 0x4B, 0x9E, 0x93, 0xCA, 0x64, 0x27, 0x4C, 0x0E, 0xC6, 0x7C, 0x1E, 0xCC,
      0x5E, 0x02, 0x4F, 0xFC, 0xAC, 0xD2, 0xD7, 0x40, 0x19, 0x35, 0x0E, 0x81, 0xFE, 0x54, 0x6A, 0xE4 },
      54 /* Bin Number */
  },
  {
    /* Microsoft_RSA_Root_Certificate_Authority_2017 */
    { 0xC7, 0x41, 0xF7, 0x0F, 0x4B, 0x2A, 0x8D, 0x88, 0xBF, 0x2E, 0x71, 0xC1, 0x41, 0x22, 0xEF, 0x53,
      0xEF, 0x10, 0xEB, 0xA0, 0xCF, 0xA5, 0xE6, 0x4C, 0xFA, 0x20, 0xF4, 0x18, 0x85, 0x30, 0x73, 0xE0 },
      49 /* Bin Number */
  },
  {
    /* Sectigo_Public_Server_Authentication_Root_E46 */
    { 0xC9, 0x0F, 0x26, 0xF0, 0xFB, 0x1B, 0x40, 0x18, 0xB2, 0x22, 0x27, 0x51, 0x9B, 0x5C, 0xA2, 0xB5,
      0x3E, 0x2C, 0xA5, 0xB3, 0xBE, 0x5C, 0xF1, 0x8E, 0xFE, 0x1B, 0xEF, 0x47, 0x38, 0x0C, 0x53, 0x83 },
      66 /* Bin Number */
  },
  {
    /* DigiCert_Global_Root_G2 */
    { 0xCB, 0x3C, 0xCB, 0xB7, 0x60, 0x31, 0xE5, 0xE0, 0x13, 0x8F, 0x8D, 0xD3, 0x9A, 0x23, 0xF9, 0xDE,
      0x47, 0xFF, 0xC3, 0x5E, 0x43, 0xC1, 0x14, 0x4C, 0xEA, 0x27, 0xD4, 0x6A, 0x5A, 0xB1, 0xCB, 0x5F },
      60 /* Bin Number */
  },
  {
    /* GlobalSign */
    { 0xCB, 0xB5, 0x22, 0xD7, 0xB7, 0xF1, 0x27, 0xAD, 0x6A, 0x01, 0x13, 0x86, 0x5B, 0xDF, 0x1C, 0xD4,
      0x10, 0x2E, 0x7D, 0x07, 0x59, 0xAF, 0x63, 0x5A, 0x7C, 0xF4, 0x72, 0x0D, 0xC9, 0x63, 0xC5, 0x3B },
      107 /* Bin Number */
  },
  {
    /* GlobalSign_Root_E46 */
    { 0xCB, 0xB9, 0xC4, 0x4D, 0x84, 0xB8, 0x04, 0x3E, 0x10, 0x50, 0xEA, 0x31, 0xA6, 0x9F, 0x51, 0x49,
      0x55, 0xD7, 0xBF, 0xD2, 0xE2, 0xC6, 0xB4, 0x93, 0x01, 0x01, 0x9A, 0xD6, 0x1D, 0x9F, 0x50, 0x58 },
      124 /* Bin Number */
  },
  {
    /* XRamp_Global_Certification_Authority */
    { 0xCE, 0xCD, 0xDC, 0x90, 0x50, 0x99, 0xD8, 0xDA, 0xDF, 0xC5, 0xB1, 0xD2, 0x09, 0xB7, 0x37, 0xCB,
      0xE2, 0xC1, 0x8C, 0xFB, 0x2C, 0x10, 0xC0, 0xFF, 0x0B, 0xCF, 0x0D, 0x32, 0x86, 0xFC, 0x1A, 0xA2 },
      21 /* Bin Number */
  },
  {
    /* UCA_Extended_Validation_Root */
    { 0xD4, 0x3A, 0xF9, 0xB3, 0x54, 0x73, 0x75, 0x5C, 0x96, 0x84, 0xFC, 0x06, 0xD7, 0xD8, 0xCB, 0x70,
      0xEE, 0x5C, 0x28, 0xE7, 0x73, 0xFB, 0x29, 0x4E, 0xB4, 0x1E, 0xE7, 0x17, 0x22, 0x92, 0x4D, 0x24 },
      121 /* Bin Number */
  },
  {
    /* Certigna_Root_CA */
    { 0xD4, 0x8D, 0x3D, 0x23, 0xEE, 0xDB, 0x50, 0xA4, 0x59, 0xE5, 0x51, 0x97, 0x60, 0x1C, 0x27, 0x77,
      0x4B, 0x9D, 0x7B, 0x18, 0xC9, 0x4D, 0x5A, 0x05, 0x95, 0x11, 0xA1, 0x02, 0x50, 0xB9, 0x31, 0x68 },
      72 /* Bin Number */
  },
  {
    /* AAA_Certificate_Services */
    { 0xD7, 0xA7, 0xA0, 0xFB, 0x5D, 0x7E, 0x27, 0x31, 0xD7, 0x71, 0xE9, 0x48, 0x4E, 0xBC, 0xDE, 0xF7,
      0x1D, 0x5F, 0x0C, 0x3E, 0x0A, 0x29, 0x48, 0x78, 0x2B, 0xC8, 0x3E, 0xE0, 0xEA, 0x69, 0x9E, 0xF4 },
      32 /* Bin Number */
  },
  {
    /* GTS_Root_R1 */
    { 0xD9, 0x47, 0x43, 0x2A, 0xBD, 0xE7, 0xB7, 0xFA, 0x90, 0xFC, 0x2E, 0x6B, 0x59, 0x10, 0x1B, 0x12,
      0x80, 0xE0, 0xE1, 0xC7, 0xE4, 0xE4, 0x0F, 0xA3, 0xC6, 0x88, 0x7F, 0xFF, 0x57, 0xA7, 0xF4, 0xCF },
      119 /* Bin Number */
  },
  {
    /* HARICA_TLS_RSA_Root_CA_2021 */
    { 0xD9, 0x5D, 0x0E, 0x8E, 0xDA, 0x79, 0x52, 0x5B, 0xF9, 0xBE, 0xB1, 0x1B, 0x14, 0xD2, 0x10, 0x0D,
      0x32, 0x94, 0x98, 0x5F, 0x0C, 0x62, 0xD9, 0xFA, 0xBD, 0x9C, 0xD9, 0x99, 0xEC, 0xCB, 0x7B, 0x1D },
      42 /* Bin Number */
  },
  {
    /* Entrust_Root_Certification_Authority___G4 */
    { 0xDB, 0x35, 0x17, 0xD1, 0xF6, 0x73, 0x2A, 0x2D, 0x5A, 0xB9, 0x7C, 0x53, 0x3E, 0xC7, 0x07, 0x79,
      0xEE, 0x32, 0x70, 0xA6, 0x2F, 0xB4, 0xAC, 0x42, 0x38, 0x37, 0x24, 0x60, 0xE6, 0xF0, 0x1E, 0x88 },
      3 /* Bin Number */
  },
  {
    /* TeliaSonera_Root_CA_v1 */
    { 0xDD, 0x69, 0x36, 0xFE, 0x21, 0xF8, 0xF0, 0x77, 0xC1, 0x23, 0xA1, 0xA5, 0x21, 0xC1, 0x22, 0x24,
      0xF7, 0x22, 0x55, 0xB7, 0x3E, 0x03, 0xA7, 0x26, 0x06, 0x93, 0xE8, 0xA2, 0x4B, 0x0F, 0xA3, 0x89 },
      147 /* Bin Number */
  },
  {
    /* TrustAsia_Global_Root_CA_G3 */
    { 0xE0, 0xD3, 0x22, 0x6A, 0xEB, 0x11, 0x63, 0xC2, 0xE4, 0x8F, 0xF9, 0xBE, 0x3B, 0x50, 0xB4, 0xC6,
      0x43, 0x1B, 0xE7, 0xBB, 0x1E, 0xAC, 0xC5, 0xC3, 0x6B, 0x5D, 0x5E, 0xC5, 0x09, 0x03, 0x9A, 0x08 },
      74 /* Bin Number */
  },
  {
    /* CA_Disig_Root_R2 */
    { 0xE2, 0x3D, 0x4A, 0x03, 0x6D, 0x7B, 0x70, 0xE9, 0xF5, 0x95, 0xB1, 0x42, 0x20, 0x79, 0xD2, 0xB9,
      0x1E, 0xDF, 0xBB, 0x1F, 0xB6, 0x51, 0xA0, 0x63, 0x3E, 0xAA, 0x8A, 0x9D, 0xC5, 0xF8, 0x07, 0x03 },
      81 /* Bin Number */
  },
  {
    /* Amazon_Root_CA_4 */
    { 0xE3, 0x5D, 0x28, 0x41, 0x9E, 0xD0, 0x20, 0x25, 0xCF, 0xA6, 0x90, 0x38, 0xCD, 0x62, 0x39, 0x62,
      0x45, 0x8D, 0xA5, 0xC6, 0x95, 0xFB, 0xDE, 0xA3, 0xC2, 0x2B, 0x0B, 0xFB, 0x25, 0x89, 0x70, 0x92 },
      142 /* Bin Number */
  },
  {
    /* Certigna */
    { 0xE3, 0xB6, 0xA2, 0xDB, 0x2E, 0xD7, 0xCE, 0x48, 0x84, 0x2F, 0x7A, 0xC5, 0x32, 0x41, 0xC7, 0xB7,
      0x1D, 0x54, 0x14, 0x4B, 0xFB, 0x40, 0xC1, 0x1F, 0x3F, 0x1D, 0x0B, 0x42, 0xF5, 0xEE, 0xA1, 0x2D },
      148 /* Bin Number */
  },
  {
    /* D_TRUST_BR_Root_CA_1_2020 */
    { 0xE5, 0x9A, 0xAA, 0x81, 0x60, 0x09, 0xC2, 0x2B, 0xFF, 0x5B, 0x25, 0xBA, 0xD3, 0x7D, 0xF3, 0x06,
      0xF0, 0x49, 0x79, 0x7C, 0x1F, 0x81, 0xD8, 0x5A, 0xB0, 0x89, 0xE6, 0x57, 0xBD, 0x8F, 0x00, 0x44 },
      112 /* Bin Number */
  },
  {
    /* Security_Communication_ECC_RootCA1 */
    { 0xE7, 0x4F, 0xBD, 0xA5, 0x5B, 0xD5, 0x64, 0xC4, 0x73, 0xA3, 0x6B, 0x44, 0x1A, 0xA7, 0x99, 0xC8,
      0xA6, 0x8E, 0x07, 0x74, 0x40, 0xE8, 0x28, 0x8B, 0x9F, 0xA1, 0xE5, 0x0E, 0x4B, 0xBA, 0xCA, 0x11 },
      63 /* Bin Number */
  },
  {
    /* SecureSign_Root_CA15 */
    { 0xE7, 0x78, 0xF0, 0xF0, 0x95, 0xFE, 0x84, 0x37, 0x29, 0xCD, 0x1A, 0x00, 0x82, 0x17, 0x9E, 0x53,
      0x14, 0xA9, 0xC2, 0x91, 0x44, 0x28, 0x05, 0xE1, 0xFB, 0x1D, 0x8F, 0xB6, 0xB8, 0x88, 0x6C, 0x3A },
      149 /* Bin Number */
  },
  {
    /* USERTrust_RSA_Certification_Authority */
    { 0xE7, 0x93, 0xC9, 0xB0, 0x2F, 0xD8, 0xAA, 0x13, 0xE2, 0x1C, 0x31, 0x22, 0x8A, 0xCC, 0xB0, 0x81,
      0x19, 0x64, 0x3B, 0x74, 0x9C, 0x89, 0x89, 0x64, 0xB1, 0x74, 0x6D, 0x46, 0xC3, 0xD4, 0xCB, 0xD2 },
      14 /* Bin Number */
  },
  {
    /* OU_certSIGN_ROOT_CA_O_certSIGN_C_RO */
    { 0xEA, 0xA9, 0x62, 0xC4, 0xFA, 0x4A, 0x6B, 0xAF, 0xEB, 0xE4, 0x15, 0x19, 0x6D, 0x35, 0x1C, 0xCD,
      0x88, 0x8D, 0x4F, 0x53, 0xF3, 0xFA, 0x8A, 0xE6, 0xD7, 0xC4, 0x66, 0xA9, 0x4E, 0x60, 0x42, 0xBB },
      140 /* Bin Number */
  },
  {
    /* OU_AC_RAIZ_FNMT_RCM_O_FNMT_RCM_C_ES */
    { 0xEB, 0xC5, 0x57, 0x0C, 0x29, 0x01, 0x8C, 0x4D, 0x67, 0xB1, 0xAA, 0x12, 0x7B, 0xAF, 0x12, 0xF7,
      0x03, 0xB4, 0x61, 0x1E, 0xBC, 0x17, 0xB7, 0xDA, 0xB5, 0x57, 0x38, 0x94, 0x17, 0x9B, 0x93, 0xFA },
      141 /* Bin Number */
  },
  {
    /* GlobalSign_Root_CA */
    { 0xEB, 0xD4, 0x10, 0x40, 0xE4, 0xBB, 0x3E, 0xC7, 0x42, 0xC9, 0xE3, 0x81, 0xD3, 0x1E, 0xF2, 0xA4,
      0x1A, 0x48, 0xB6, 0x68, 0x5C, 0x96, 0xE7, 0xCE, 0xF3, 0xC1, 0xDF, 0x6C, 0xD4, 0x33, 0x1C, 0x99 },
      76 /* Bin Number */
  },
  {
    /* Buypass_Class_3_Root_CA */
    { 0xED, 0xF7, 0xEB, 0xBC, 0xA2, 0x7A, 0x2A, 0x38, 0x4D, 0x38, 0x7B, 0x7D, 0x40, 0x10, 0xC6, 0x66,
      0xE2, 0xED, 0xB4, 0x84, 0x3E, 0x4C, 0x29, 0xB4, 0xAE, 0x1D, 0x5B, 0x93, 0x32, 0xE6, 0xB2, 0x4D },
      98 /* Bin Number */
  },
  {
    /* D_TRUST_Root_Class_3_CA_2_EV_2009 */
    { 0xEE, 0xC5, 0x49, 0x6B, 0x98, 0x8C, 0xE9, 0x86, 0x25, 0xB9, 0x34, 0x09, 0x2E, 0xEC, 0x29, 0x08,
      0xBE, 0xD0, 0xB0, 0xF3, 0x16, 0xC2, 0xD4, 0x73, 0x0C, 0x84, 0xEA, 0xF1, 0xF3, 0xD3, 0x48, 0x81 },
      87 /* Bin Number */
  },
  {
    /* Telekom_Security_TLS_RSA_Root_2023 */
    { 0xEF, 0xC6, 0x5C, 0xAD, 0xBB, 0x59, 0xAD, 0xB6, 0xEF, 0xE8, 0x4D, 0xA2, 0x23, 0x11, 0xB3, 0x56,
      0x24, 0xB7, 0x1B, 0x3B, 0x1E, 0xA0, 0xDA, 0x8B, 0x66, 0x55, 0x17, 0x4E, 0xC8, 0x97, 0x86, 0x46 },
      55 /* Bin Number */
  },
  {
    /* HiPKI_Root_CA___G1 */
    { 0xF0, 0x15, 0xCE, 0x3C, 0xC2, 0x39, 0xBF, 0xEF, 0x06, 0x4B, 0xE9, 0xF1, 0xD2, 0xC4, 0x17, 0xE1,
      0xA0, 0x26, 0x4A, 0x0A, 0x94, 0xBE, 0x1F, 0x0C, 0x8D, 0x12, 0x18, 0x64, 0xEB, 0x69, 0x49, 0xCC },
      90 /* Bin Number */
  },
  {
    /* SecureTrust_CA */
    { 0xF1, 0xC1, 0xB5, 0x0A, 0xE5, 0xA2, 0x0D, 0xD8, 0x03, 0x0E, 0xC9, 0xF6, 0xBC, 0x24, 0x82, 0x3D,
      0xD3, 0x67, 0xB5, 0x25, 0x57, 0x59, 0xB4, 0xE7, 0x1B, 0x61, 0xFC, 0xE9, 0xF7, 0x37, 0x5D, 0x73 },
      110 /* Bin Number */
  },
  {
    /* Atos_TrustedRoot_2011 */
    { 0xF3, 0x56, 0xBE, 0xA2, 0x44, 0xB7, 0xA9, 0x1E, 0xB3, 0x5D, 0x53, 0xCA, 0x9A, 0xD7, 0x86, 0x4A,
      0xCE, 0x01, 0x8E, 0x2D, 0x35, 0xD5, 0xF8, 0xF9, 0x6D, 0xDF, 0x68, 0xA6, 0xF4, 0x1A, 0xA4, 0x74 },
      139 /* Bin Number */
  },
  {
    /* BJCA_Global_Root_CA1 */
    { 0xF3, 0x89, 0x6F, 0x88, 0xFE, 0x7C, 0x0A, 0x88, 0x27, 0x66, 0xA7, 0xFA, 0x6A, 0xD2, 0x74, 0x9F,
      0xB5, 0x7A, 0x7F, 0x3E, 0x98, 0xFB, 0x76, 0x9C, 0x1F, 0xA7, 0xB0, 0x9C, 0x2C, 0x44, 0xD5, 0xAE },
      80 /* Bin Number */
  },
  {
    /* ANF_Secure_Server_Root_CA */
    { 0xFB, 0x8F, 0xEC, 0x75, 0x91, 0x69, 0xB9, 0x10, 0x6B, 0x1E, 0x51, 0x16, 0x44, 0xC6, 0x18, 0xC5,
      0x13, 0x04, 0x37, 0x3F, 0x6C, 0x06, 0x43, 0x08, 0x8D, 0x8B, 0xEF, 0xFD, 0x1B, 0x99, 0x75, 0x99 },
      19 /* Bin Number */
  },
  {
    /* T_TeleSec_GlobalRoot_Class_3 */
    { 0xFD, 0x73, 0xDA, 0xD3, 0x1C, 0x64, 0x4F, 0xF1, 0xB4, 0x3B, 0xEF, 0x0C, 0xCD, 0xDA, 0x96, 0x71,
      0x0B, 0x9C, 0xD9, 0x87, 0x5E, 0xCA, 0x7E, 0x31, 0x70, 0x7A, 0xF3, 0xE9, 0x6D, 0x52, 0x2B, 0xBD },
      24 /* Bin Number */
  },
  {
    /* Certum_Trusted_Root_CA */
    { 0xFE, 0x76, 0x96, 0x57, 0x38, 0x55, 0x77, 0x3E, 0x37, 0xA9, 0x5E, 0x7A, 0xD4, 0xD9, 0xCC, 0x96,
      0xC3, 0x01, 0x57, 0xC1, 0x5D, 0x31, 0x76, 0x5B, 0xA9, 0xB1, 0x57, 0x04, 0xE1, 0xAE, 0x78, 0xFD },
      33 /* Bin Number */
  },
  {
    /* CommScope_Public_Trust_RSA_Root_02 */
    { 0xFF, 0xE9, 0x43, 0xD7, 0x93, 0x42, 0x4B, 0x4F, 0x7C, 0x44, 0x0C, 0x1C, 0x3D, 0x64, 0x8D, 0x53,
      0x63, 0xF3, 0x4B, 0x82, 0xDC, 0x87, 0xAA, 0x7A, 0x9F, 0x11, 0x8F, 0xC5, 0xDE, 0xE1, 0x01, 0xF1 },
      94 /* Bin Number */
  },
};

