# ![TodoMVC](https://raw.github.com/tastejs/todomvc/gh-pages/media/logo.png)

## Helping you select an MV\* framework


Developers these days are spoiled with choice when it comes to selecting an MV\* framework for structuring and organizing JavaScript web apps.

Backbone, Ember, AngularJS, Spine... the list of new and stable solutions goes on and on, but just how do you decide on which to use in a sea of so many options?

To help solve this problem, we created TodoMVC - a project which offers the same Todo application implemented using MV* concepts in most of the popular JavaScript MV\* frameworks of today.


#### Todo apps are included for:

- [Backbone.js](http://documentcloud.github.com/backbone)
- [Ember.js](http://emberjs.com)
- [AngularJS](http://angularjs.org)
- [Spine](http://spinejs.com)
- [KnockoutJS](http://knockoutjs.com) (MVVM)
- [Dojo](http://dojotoolkit.org)
- [YUI](http://yuilibrary.com)
- [Batman.js](http://batmanjs.org)
- [Closure](http://code.google.com/closure/library/)
- [Agility.js](http://agilityjs.com)
- [Knockback.js](http://kmalakoff.github.com/knockback)
- [Google Web Toolkit](https://developers.google.com/web-toolkit/)


###### Non-framework Implementations

- [jQuery](http://jquery.com)
- [Vanilla JS](http://todomvc.com/vanilla-examples/vanillajs/)

###### RequireJS

- [Backbone.js](http://documentcloud.github.com/backbone) + [RequireJS](http://requirejs.org)
- [AngularJS](http://angularjs.org) + [RequireJS](http://requirejs.org)
- [KnockoutJS](http://knockoutjs.com) + [RequireJS](http://requirejs.org)
- [CanJS](http://canjs.us) + [RequireJS](http://requirejs.org)

#### Labs

We also have a number of in-progress applications in Labs:

- [React](http://facebook.github.io/react)
- [Meteor](http://meteor.com)
- [Derby](http://derbyjs.com)
- [CanJS](http://canjs.us)
- [Kendo UI](http://kendoui.com)
- [Flight by Twitter](https://github.com/twitter/flight)
- [Maria.js](https://github.com/petermichaux/maria)
- [cujoJS](http://cujojs.com)
- [MarionetteJS](http://marionettejs.com/)
- [SocketStream](http://www.socketstream.org) + [jQuery](http://jquery.com)
- [Ext.js](http://www.sencha.com/products/extjs)
- [Sammy.js](http://sammyjs.org)
- [dermis](https://github.com/wearefractal/dermis)
- [Stapes.js](http://hay.github.com/stapes)
- [Epitome](http://dimitarchristoff.github.com/Epitome)
- [TroopJS](https://github.com/troopjs)
- [soma.js](http://somajs.github.com/somajs)
- [DUEL](https://bitbucket.org/mckamey/duel/wiki/Home)
- [Olives](https://github.com/flams/olives)
- [PlastronJS](https://github.com/rhysbrettbowen/PlastronJS)
- [Dijon](https://github.com/creynders/dijon-framework)
- [rAppid.js](http://www.rappidjs.com)
- [Thorax](http://walmartlabs.github.com/thorax/)
- [KnockoutJS](http://knockoutjs.com) + [ClassBindingProvider](https://github.com/rniemeyer/knockout-classBindingProvider) (using Ryan Niemeyer's Class Binding Provider)
- [KnockoutJS](http://knockoutjs.com) + [RequireJS](http://requirejs.org) (using AMD)
- [AngularJS](http://angularjs.org) + [RequireJS](http://requirejs.org) (using AMD)
- [CanJS](http://canjs.us) + [RequireJS](http://requirejs.org) (using AMD)
- [AngularJS](http://angularjs.org) (optimized)
- [Backbone.xmpp](https://github.com/ggozad/Backbone.xmpp)
- [Dart](http://dartlang.org)
- [Chaplin](http://chaplinjs.org) + [Brunch](http://brunch.io)
- [Serenade.js](https://github.com/elabs/serenade.js)
- [TypeScript](http://www.typescriptlang.org/)
- [DeftJS](http://deftjs.org/)
- [Aria Templates](http://ariatemplates.com/)
- [Enyo + Backbone.js](http://enyojs.com/)
- [SAPUI5](http://scn.sap.com/community/developer-center/front-end)

## Live demos

Live demos are available on our [website](http://todomvc.com)


## Screenshot

![screenshot](https://raw.github.com/tastejs/todomvc/gh-pages/site-assets/screenshot.png)


## Team

TodoMVC would not be possible without a strong team of [contributors](https://github.com/tastejs/todomvc/contributors) helping push the project forward each day. In addition, we have a core project team composed of:

#### [Addy Osmani](http://github.com/addyosmani) - Founder/Lead

<img align="left" width="40" height="40" src="http://www.gravatar.com/avatar/96270e4c3e5e9806cf7245475c00b275.png?s=40">
Addy is a Developer Platform Engineer at Google who originally created TodoMVC. He oversees the project direction, drives expansion and helps lead core development with Sindre Sorhus (by far our most active contributor!).

#### [Sindre Sorhus](https://github.com/sindresorhus) - Lead Developer

<img align="left" width="40" height="40" src="http://www.gravatar.com/avatar/d36a92237c75c5337c17b60d90686bf9.png?s=40">
Sindre is a Web Developer who drives core development, quality control and application design for the project. His contributions have helped us ensure consistency and best practices are enforced wherever possible.

#### [Pascal Hartig](https://github.com/passy) - Developer

<img align="left" width="40" height="40" src="http://www.gravatar.com/avatar/be451fcdbf0e5ff07f23ed16cb5c90a3.png?s=40">
Pascal is a Software Engineer at weluse GmbH with a deep passion for consistency. He watches pull requests and helps developers getting their contributions integrated with TodoMVC.

#### [Stephen Sawchuk](https://github.com/stephenplusplus) - Developer

<img align="left" width="40" height="40" src="https://secure.gravatar.com/avatar/098cfe2d360e77c3229f2cd5298354c4?s=40">
Stephen is a Front-end Engineer at Quicken Loans that cares about improving the maintainability and developer experience of open-source projects. His recent contributions include helping us move all apps over to using Bower and implementing the new information bar.

#### [Gianni Chiappetta](https://github.com/gf3) - Logo designer

<img align="left" width="40" height="40" src="http://www.gravatar.com/avatar/4b0209ae3652cc5a7d53545e759fbe39.png?s=40">
Gianni is a programmer and designer currently working as the Chief Rigger at MetaLab.

## Disclaimer

<img align="right" width="230" height="230" src="https://raw.github.com/tastejs/todomvc/gh-pages/media/icon-small.png">

TodoMVC has been called many things including the 'Speed-dating' and 'Rosetta Stone' of MV* frameworks. Whilst we hope that this project is able to offer assistance in deciding what frameworks are worth spending more time looking at, remember that the Todo application offers a limited view of what a framework may be capable of.

It is meant to be used as a gateway to reviewing how a basic application using a framework may be structured and we heavily recommend investing time researching a solution in more depth before opting to use it.


## Getting Involved

Whilst we enjoy implementing and improving existing Todo apps, we're always interested in speaking to framework authors (and users) wishing to share Todo app implementations in their framework/solution of choice.

Check out our [contribution docs](contributing.md) for more info.


## License

Everything in this repo is MIT License unless otherwise specified.

MIT © Addy Osmani, Sindre Sorhus, Pascal Hartig, Stephen Sawchuk.
