+++
title = "htmx 1.6.1 has been released!"
date = 2021-11-22
[taxonomies]
tag = ["posts", "announcements"]
+++

## htmx 1.6.1 Release

I'm happy to announce the [1.6.1 release](https://unpkg.com/browse/htmx.org@1.6.1/) of htmx.

### New Features

* A new `HX-Retarget` header allows you to change the default target of returned content
* The `htmx:beforeSwap` event now includes another configurable property: `detail.isError` which can
  be used to indicate if a given response should be treated as an error or not
* The `htmx:afterRequest` event has two new detail properties: `success` and `failed`, allowing you to write 
  trigger filters in htmx or hyperscript:
  ```applescript
    on htmx:afterRequest[failed]
      set #myCheckbox's checked to true
  ```
  
### Improvements & Bug fixes

* Fixed the `from:` option in [`hx-trigger`](@/attributes/hx-trigger.md) to support `closest <CSS selector>` 
  and `find <CSS selector>` forms
* Don't boost anchor tags with an explicit `target` set
* Don't cancel all events on boosted elements, only the events that naturally trigger them (click for anchors, submit
  for forms)
* Persist revealed state in the DOM so that on history navigation, revealed elements are not re-requested
* Process all `hx-ext` attributes, even if no other htmx attribute is on the element
* Snapshot the current URL on load so that history support works properly after a page refresh occurs
* Many, many documentation updates (thank you to all the contributors!)

Enjoy!
