---
title: Strawberry docs
---

# Strawberry docs

- [Getting started](./index.md)

## General

- [Schema basics](./general/schema-basics.md)
- [Queries](./general/queries.md)
- [Mutations](./general/mutations.md)
- [Subscriptions](./general/subscriptions.md)
- [Multipart Subscriptions](./general/multipart-subscriptions.md)
- [Errors](./errors)
- [Upgrading Strawberry](./general/upgrades.md)
- [Breaking changes](./breaking-changes.md)
- [FAQ](./faq.md)

## Types

- [Schema](./types/schema.md)
- [Operation Directives](./types/operation-directives.md)
- [Schema Directives](./types/schema-directives.md)
- [Schema configurations](./types/schema-configurations.md)
- [Scalars](./types/scalars.md)
- [Object types](./types/object-types.md)
- [Interfaces](./types/interfaces.md)
- [Input types](./types/input-types.md)
- [Enums](./types/enums.md)
- [Generics](./types/generics.md)
- [Resolvers](./types/resolvers.md)
- [Union types](./types/union.md)
- [Lazy types](./types/lazy.md)
- [Exceptions](./types/exceptions.md)
- [Private/External Fields](./types/private.md)

## Codegen

- [Schema codegen](./codegen/schema-codegen.md)
- [Query codegen](./codegen/query-codegen.md)

## Guides

- [Accessing parent data](./guides/accessing-parent-data.md)
- [Authentication](./guides/authentication.md)
- [DataLoaders](./guides/dataloaders.md)
- [Dealing with errors](./guides/errors.md)
- [Federation](./guides/federation.md)
- [Federation V1](./guides/federation-v1.md)
- [Relay](./guides/relay.md)
- [File upload](./guides/file-upload.md)
- [Pagination](./guides/pagination/overview.md)
  - [Implementing Offset Pagination](./guides/pagination/offset-based.md)
  - [Implementing Cursor Pagination](./guides/pagination/cursor-based.md)
  - [Implementing the Connection specification](./guides/pagination/connections.md)
- [Permissions](./guides/permissions.md)
- [Built-in server](./guides/server.md)
- [Tools](./guides/tools.md)
- [Schema export](./guides/schema-export.md)
- [Convert to dictionary](./guides/convert-to-dictionary.md)

## Extensions

- [Introduction](./extensions)
- [Schema extensions](./guides/custom-extensions.md)
- [Field extensions](./guides/field-extensions.md)

## Editor integration

- [Mypy](./editors/mypy.md)
- [Visual Studio Code](./editors/vscode.md)

## Concepts

- [Async](./concepts/async.md)
- [Type hints](./concepts/typings.md)

## Integrations

- [AIOHTTP](./integrations/aiohttp.md)
- [ASGI](./integrations/asgi.md)
- [Django](./integrations/django.md)
- [Channels](./integrations/channels.md)
- [FastAPI](./integrations/fastapi.md)
- [Flask](./integrations/flask.md)
- [Quart](./integrations/quart.md)
- [Sanic](./integrations/sanic.md)
- [Chalice](./integrations/chalice.md)
- [Starlette](./integrations/starlette.md)
- [Litestar](./integrations/litestar.md)
- [Creating an integration](./integrations/creating-an-integration.md)
- [Pydantic **experimental**](./integrations/pydantic.md)

## Federation

- [Introduction](./federation/introduction.md)
- [Entities](./federation/entities.md)
- [Entity interfaces](./federation/entity-interfaces.md)
- [Custom directives](./federation/custom_directives.md)

## Operations

- [Deployment](./operations/deployment.md)
- [Testing](./operations/testing.md)
- [Tracing](./operations/tracing.md)
