---
myst:
  html_meta:
    keywords: LaTeX, fichiers, fontes
---

# Pourquoi mon texte semble "flou" ?

Il s'agit d'un problème assez courant. La plupart des gens utilisent 
[Adobe Acrobat Reader](wpfr:Adobe_Acrobat) pour visualiser leur PDF : 
`Reader` est distribué gratuitement et est largement disponible, malgré tous ses défauts. 
L'un de ces défauts est son incapacité à gérer les polices bitmap (du moins, 
dans toutes les versions antérieures à la version 6, désormais anciennes et presque
inexistantes même si, parfois, l'une d'entre elles surgit au détour d'un fichier perdu
sur un ordinateur encore plus oublié).

Nous ne voulons donc pas de polices bitmap dans notre PostScript : 
avec elles, les caractères apparaissent dans l'affichage de `Reader` 
sous forme de taches floues qui ne sont souvent même pas reconnaissables 
comme la lettre d'origine et ne sont souvent pas correctement placées sur la ligne. 
Néanmoins, même maintenant, la plupart des systèmes TeX ont `dvips` configuré pour utiliser 
les [fichiers pk](/5_fichiers/formats/fontes/que_sont_les_fichiers_pk) dans leur sortie. 
Même pdfTeX utilisera les fichiers `.pk` s'il ne voit aucune alternative 
pour une police dans le document qu'il traite.

Notre solution consiste à utiliser les versions 
[Adobe Type 1](/5_fichiers/formats/fontes/formats_de_polices_adobe) des polices dont nous avons besoin. 
Étant donné qu'Adobe vend des polices de type 1, `Reader` a bien sûr été conçu 
pour les gérer très bien, dès le début.

Bien sûr, si votre document n'utilise que des polices provenant d'Adobe en premier lieu, 
il n'y aura pas de problème. Par exemple des polices telles que *[Times](wpfr:Times_New_Roman)*,
qui sont présentes dans presque toutes les imprimantes PostScript, 
ou telles qu'*Adobe [Sabon](wpfr:Sabon_(police_d'écriture))*. 

Cependant, la plupart des gens utilisent *[Computer Modern](wpfr:Computer_Modern)* 
pour commencer, et même les utilisateurs sophistiqués qui utilisent des polices 
aussi exotiques que *Sabon* se retrouvent souvent à utiliser des caractères étranges 
de *Computer Modern* sans vraiment avoir l'intention de le faire. Heureusement, 
d'assez bonnes versions des polices *Computer Modern* sont disponibles auprès de l'AMS 
(qui les possède avec l'aimable autorisation de 
[Blue Sky Research](/6_distributions/installation/implementations_commerciales)
et [Y&Y](https://www.tug.org/yandy/)) .

La plupart des systèmes modernes ont des polices installées prêtes à l'emploi.
Et tout système installé pas trop ancien possède un fichier de configuration de `dvips`
pour générer les `.pdf` qui signale l'utilisation des polices *Computer Modern* 
et définit également quelques autres paramètres pour améliorer la sortie `dvips`. 
Vous pouvez ainsi utiliser une configuration comme :

```bash
dvips -Ppdf myfile -o myfile.ps
```

Cela peut générer un message d'avertissement indiquant que le fichier de configuration 
n'a pas été trouvé :

```text
dvips: warning: no config file for `pdf'
```

De façon similaire, vous pourriez avoir un avertissement 
sur l'impossibilité de trouver un fichier de police :

```text
dvips: ! Couldn't find header file cmr10.pfb
```

L’un ou l’autre de ces échecs indique que votre système ne dispose pas des polices. 
Une façon d'utiliser les polices qui n'implique pas la sophistication du mécanisme `-Ppdf` 
consiste simplement à charger des correspondances :

```bash
dvips -Pcmz -Pamz myfile -o myfile.ps
```

Vous pouvez alors cependant rencontrer les mêmes messages d’avertissement 
que ceux répertoriés ci-dessus.

Si votre système ne dispose pas des polices, il n'aura pas non plus 
le fichier de configuration. Cependant, il peut contenir le fichier de configuration 
sans les polices. Dans les deux cas, vous devez 
[installer les polices](/5_fichiers/formats/fontes/installation_de_fontes/installer_la_version_t1_de_computer_modern).


:::{sources}
[The wrong type of fonts in PDF](faquk:FAQ-fuzzy-type3)
:::
