/*
 * Decompiled with CFR 0.152.
 */
package com.wombatinvasion.pmwikidraw;

import com.wombatinvasion.pmwikidraw.PmWikiDrawFrame;
import com.wombatinvasion.pmwikidraw.PmWikiSource;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownServiceException;
import java.util.HashMap;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPasswordField;
import org.jhotdraw.framework.Drawing;
import org.jhotdraw.framework.FigureEnumeration;
import org.jhotdraw.util.StorableOutput;

public class PmWikiDraw
extends JApplet
implements PmWikiSource {
    private PmWikiDrawFrame app = null;
    private static String fResourcePath;
    private String currentUploadPassword = "";
    public static final String VERSION = "2.362";
    private HashMap modifiedParameters = new HashMap();
    static String password;
    static String NL;
    static String NLNL;

    public void init() {
        super.init();
        System.out.println("PmWikiDraw v2.362");
        fResourcePath = this.getParameter("resourcesurl");
        this.app = new PmWikiDrawFrame(this);
        this.app.open();
        this.app.loadDrawing("drawingloadpath");
    }

    public String getPmWikiParameter(String string) {
        if (this.modifiedParameters.containsKey(string)) {
            return (String)this.modifiedParameters.get(string);
        }
        return this.getParameter(string);
    }

    public void setPmWikiParameter(String string, String string2) {
        this.modifiedParameters.put(string, string2);
    }

    public URL createUrl(String string) throws MalformedURLException {
        return new URL(this.getCodeBase(), string);
    }

    public void debug(String string) {
        System.err.println(string);
    }

    public int saveDrawing(Drawing drawing) {
        int n = 1;
        this.setCursor(new Cursor(3));
        String string = null;
        String string2 = null;
        Object object = null;
        try {
            Object object2;
            Object object3;
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            StorableOutput storableOutput = new StorableOutput(byteArrayOutputStream);
            storableOutput.writeStorable(drawing);
            storableOutput.close();
            String string3 = this.getPmWikiParameter("wikiurl");
            String string4 = this.getPmWikiParameter("drawingname");
            if (string4 == null) {
                string4 = "untitled";
            }
            String string5 = this.getPmWikiParameter("pagename");
            this.debug("PageName:" + string5);
            this.showStatus("Page : " + string5);
            if (string5 == null) {
                string5 = "";
            }
            this.showStatus("Saving .draw file " + string4 + ".draw");
            this.debug("Saving .draw file " + string4 + ".draw");
            string = byteArrayOutputStream.toString();
            int n2 = 10;
            Dimension dimension = new Dimension(0, 0);
            FigureEnumeration figureEnumeration = drawing.figuresReverse();
            while (figureEnumeration.hasNextFigure()) {
                object3 = figureEnumeration.nextFigure();
                object2 = object3.displayBox();
                if (((Rectangle)object2).x + ((Rectangle)object2).width > dimension.width) {
                    dimension.setSize(((Rectangle)object2).x + ((Rectangle)object2).width, dimension.height);
                }
                if (((Rectangle)object2).y + ((Rectangle)object2).height <= dimension.height) continue;
                dimension.setSize(dimension.width, ((Rectangle)object2).y + ((Rectangle)object2).height);
            }
            object3 = drawing.getMap();
            object2 = string4 + ".map";
            this.showStatus("Saving .map file " + (String)object2);
            String string6 = "<area shape=\"rect\" coords=\"";
            String string7 = "\" href=\"$editImageUrl\" alt=\"Click to edit the image\" title=\"Click to edit the image\"  />\n";
            object = object3 = "<map name=\"" + string4 + "\" id=\"" + string4 + " \">" + (String)object3 + string6 + "0,0," + (dimension.width + n2) + "," + n2 / 2 + string7 + string6 + "0,0," + n2 / 2 + "," + (dimension.height + n2) + string7 + string6 + (dimension.width + n2 / 2) + ",0," + (dimension.width + n2) + "," + (dimension.height + n2) + string7 + string6 + "0," + (dimension.height + n2 / 2) + "," + (dimension.width + n2) + "," + (dimension.height + n2) + string7 + "</map>";
            String string8 = string4 + ".gif";
            this.showStatus("Saving .gif file " + string8);
            Image image = this.app.createImage(dimension.width + n2, dimension.height + n2);
            char[] cArray = this.app.convertToGif(image);
            string2 = String.valueOf(cArray, 0, cArray.length);
            String string9 = this.post(string3, string4, string5, string2, string, (String)object);
            if (string9.equals("SUCCESS")) {
                n = 0;
            } else if (string9.equals("FAILURE")) {
                n = 1;
                this.showStatus("Your Password(probably) was incorrect.");
            } else {
                this.showStatus("Concurrent modification to drawing.");
                n = 2;
            }
        }
        catch (MalformedURLException malformedURLException) {
            this.setCursor(new Cursor(0));
            this.showStatus("Bad Wiki servlet URL: " + malformedURLException.getMessage());
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            this.setCursor(new Cursor(0));
            this.showStatus(iOException.toString());
        }
        this.setCursor(new Cursor(0));
        return n;
    }

    public String post(String string, String string2, String string3, String string4, String string5, String string6) throws MalformedURLException, IOException {
        int n = 0;
        boolean bl = false;
        boolean bl2 = false;
        String string7 = this.getPmWikiParameter("drawingbasetime");
        System.out.println("Current drawing baseTime:" + string7);
        String string8 = "";
        String string9 = "89692781418184";
        while (string4.indexOf(string9) != -1) {
            string9 = string9 + "x";
        }
        while (string5.indexOf(string9) != -1) {
            string9 = string9 + "x";
        }
        while (string6.indexOf(string9) != -1) {
            string9 = string9 + "x";
        }
        String string10 = this.makeMimeForm(string3, string2, string4, string5, string6, string9, password, string7);
        while (n < 3) {
            bl = false;
            URL uRL = new URL(string);
            this.debug("Actual URL:" + uRL.toString());
            URLConnection uRLConnection = uRL.openConnection();
            uRLConnection.setAllowUserInteraction(true);
            uRLConnection.setDoOutput(true);
            uRLConnection.setUseCaches(false);
            uRLConnection.setRequestProperty("Content-type", "multipart/form-data; boundary=" + string9);
            uRLConnection.setRequestProperty("Content-length", Integer.toString(string10.length()));
            if (this.getParameter("debug") != null) {
                this.debug(string10);
            }
            String string11 = null;
            try {
                DataOutputStream dataOutputStream = new DataOutputStream(uRLConnection.getOutputStream());
                dataOutputStream.writeBytes(string10);
                dataOutputStream.close();
                this.debug("Wrote " + string10.length() + " bytes to\n" + uRLConnection);
                try {
                    if (uRLConnection.getHeaderField("PmWikiDraw-DrawingChanged") != null) {
                        string8 = uRLConnection.getHeaderField("PmWikiDraw-DrawingChanged");
                        bl2 = true;
                        this.setPmWikiParameter("drawingbasetime", string8);
                    }
                    if (uRLConnection.getHeaderField("PmWikiDraw-DrawingBaseTime") != null) {
                        string8 = uRLConnection.getHeaderField("PmWikiDraw-DrawingBaseTime");
                        this.setPmWikiParameter("drawingbasetime", string8);
                    }
                    if (!bl2) {
                        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(uRLConnection.getInputStream()));
                        String string12 = null;
                        while ((string12 = bufferedReader.readLine()) != null) {
                            if (this.getPmWikiParameter("debug") != null) {
                                System.err.println("REPLY:" + string12);
                            }
                            if (string12.indexOf("name='authpw'") > -1) {
                                bl = true;
                            }
                            if (!string12.startsWith("ERROR ")) continue;
                            string11 = string12.substring("ERROR ".length());
                        }
                        bufferedReader.close();
                    }
                }
                catch (IOException iOException) {
                    string11 = iOException.toString();
                }
            }
            catch (UnknownServiceException unknownServiceException) {
                string11 = unknownServiceException.getMessage();
                this.debug(string11);
            }
            if (bl) {
                password = this.getPopupPassword(n);
                string10 = this.makeMimeForm(string3, string2, string4, string5, string6, string9, password, string7);
            } else if (bl2) {
                n = 6;
            } else {
                return "SUCCESS";
            }
            ++n;
        }
        if (bl) {
            return "FAILURE";
        }
        if (bl2) {
            return "CONCURRENT_MODIFICATION";
        }
        return "SUCCESS";
    }

    private String makeMimeForm(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8) {
        String string9 = NL + "--" + string6 + NL;
        return "--" + string6 + "\r\n" + "Content-Disposition: form-data; name=\"pagename\"" + NLNL + string + string9 + "Content-Disposition: form-data; name=\"authpw\"" + NLNL + string7 + string9 + "Content-Disposition: form-data; name=\"drawingname\"" + NLNL + string2 + string9 + "Content-Disposition: form-data; name=\"action\"" + NLNL + "postDrawing" + string9 + "Content-Disposition: form-data; name=\"noredirect\"" + NLNL + "fish" + string9 + "Content-Disposition: form-data; name=\"redirect\"" + NLNL + "0" + string9 + "Content-Disposition: form-data; name=\"drawingbasetime\"" + NLNL + string8 + string9 + "Content-Disposition: form-data; name=\"uploadDrawing\"; " + "filename=\"" + string2 + ".draw\"" + NL + "Content-Type: text/plain" + NL + NL + string4 + string9 + "Content-Disposition: form-data; name=\"uploadMap\"; " + "filename=\"" + string2 + ".map\"" + NL + "Content-Type: text/plain" + NL + NL + string5 + string9 + "Content-Disposition: form-data; name=\"uploadImage\"; " + "filename=\"" + string2 + ".gif\"" + NL + "Content-Type: image/gif" + NL + "Content-Transfer-Encoding: binary" + NL + NL + string3 + string9 + NL + "--" + string6 + "--" + NL;
    }

    void exitApplet(boolean bl) {
        String string = this.getParameter("wikiurl") + "?pagename=" + this.getParameter("pagename");
        if (bl) {
            // empty if block
        }
        if (string != null) {
            try {
                URL uRL = new URL(string);
                if (this.getParameter("debug") == "true") {
                    System.out.println("Redirecting page to: " + string);
                }
                this.getAppletContext().showDocument(uRL);
            }
            catch (MalformedURLException malformedURLException) {
                this.showStatus("Bad URL for viewpath " + string);
            }
        }
    }

    public void exit(boolean bl) {
        this.exitApplet(bl);
    }

    public String getPopupPassword(int n) {
        final JDialog jDialog = new JDialog();
        JPasswordField jPasswordField = new JPasswordField(15);
        JButton jButton = new JButton("OK!");
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                jDialog.hide();
            }
        });
        jDialog.setTitle("PmWiki Upload password (Attempt " + (n + 1) + ")");
        jDialog.getContentPane().setLayout(new FlowLayout());
        jDialog.getContentPane().add(new JLabel("Password :"));
        jDialog.getContentPane().add(jPasswordField);
        jDialog.getContentPane().add(jButton);
        jDialog.setModal(true);
        jDialog.pack();
        jDialog.setVisible(true);
        return jPasswordField.getText();
    }

    public static String getResourcePath() {
        return fResourcePath;
    }

    static {
        password = "";
        NL = "\r\n";
        NLNL = NL + NL;
    }
}

