/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.contrib;

import java.awt.Component;
import java.awt.IllegalComponentStateException;
import java.awt.Point;
import java.awt.event.MouseEvent;
import javax.swing.JPopupMenu;
import org.jhotdraw.contrib.PopupMenuFigureSelection;
import org.jhotdraw.contrib.zoom.ZoomDrawingView;
import org.jhotdraw.framework.DrawingEditor;
import org.jhotdraw.framework.DrawingView;
import org.jhotdraw.framework.Figure;
import org.jhotdraw.framework.FigureAttributeConstant;
import org.jhotdraw.standard.SelectionTool;

public class CustomSelectionTool
extends SelectionTool {
    public CustomSelectionTool(DrawingEditor drawingEditor) {
        super(drawingEditor);
    }

    public void mouseDown(MouseEvent mouseEvent, int n, int n2) {
        this.setView((DrawingView)mouseEvent.getSource());
        if (mouseEvent.isPopupTrigger()) {
            this.handlePopupMenu(mouseEvent, n, n2);
        } else {
            super.mouseDown(mouseEvent, n, n2);
            this.handleMouseDown(mouseEvent, n, n2);
        }
    }

    public void mouseDrag(MouseEvent mouseEvent, int n, int n2) {
        if (!mouseEvent.isPopupTrigger()) {
            super.mouseDrag(mouseEvent, n, n2);
        }
    }

    public void mouseUp(MouseEvent mouseEvent, int n, int n2) {
        if (mouseEvent.isPopupTrigger()) {
            this.handlePopupMenu(mouseEvent, n, n2);
            super.mouseUp(mouseEvent, n, n2);
        } else if (mouseEvent.getClickCount() == 2) {
            super.mouseUp(mouseEvent, n, n2);
            this.handleMouseDoubleClick(mouseEvent, n, n2);
        } else {
            super.mouseUp(mouseEvent, n, n2);
            this.handleMouseUp(mouseEvent, n, n2);
            this.handleMouseClick(mouseEvent, n, n2);
        }
    }

    protected void handleMouseDown(MouseEvent mouseEvent, int n, int n2) {
    }

    protected void handleMouseUp(MouseEvent mouseEvent, int n, int n2) {
    }

    protected void handleMouseClick(MouseEvent mouseEvent, int n, int n2) {
    }

    protected void handleMouseDoubleClick(MouseEvent mouseEvent, int n, int n2) {
    }

    protected void handlePopupMenu(MouseEvent mouseEvent, int n, int n2) {
        Figure figure = this.drawing().findFigure(mouseEvent.getX(), mouseEvent.getY());
        if (figure != null) {
            Object object = figure.getAttribute(FigureAttributeConstant.POPUP_MENU);
            if (object == null) {
                figure = this.drawing().findFigureInside(mouseEvent.getX(), mouseEvent.getY());
            }
            if (figure != null) {
                this.showPopupMenu(figure, mouseEvent.getX(), mouseEvent.getY(), mouseEvent.getComponent());
            }
        }
    }

    protected void showPopupMenu(Figure figure, int n, int n2, Component component) {
        Object object = figure.getAttribute(FigureAttributeConstant.POPUP_MENU);
        if (object != null && object instanceof JPopupMenu) {
            Point point;
            JPopupMenu jPopupMenu = (JPopupMenu)object;
            if (jPopupMenu instanceof PopupMenuFigureSelection) {
                ((PopupMenuFigureSelection)((Object)jPopupMenu)).setSelectedFigure(figure);
            }
            try {
                point = component.getLocationOnScreen();
            }
            catch (IllegalComponentStateException illegalComponentStateException) {
                return;
            }
            if (component instanceof ZoomDrawingView) {
                double d = ((ZoomDrawingView)component).getScale();
                n = (int)((double)n * d);
                n2 = (int)((double)n2 * d);
            }
            point.translate(n, n2);
            jPopupMenu.setLocation(point);
            jPopupMenu.setInvoker(component);
            jPopupMenu.setVisible(true);
        }
    }
}

