/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.contrib;

import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.IOException;
import java.util.List;
import org.jhotdraw.contrib.Layoutable;
import org.jhotdraw.contrib.Layouter;
import org.jhotdraw.contrib.StandardLayouter;
import org.jhotdraw.figures.RectangleFigure;
import org.jhotdraw.framework.Figure;
import org.jhotdraw.framework.FigureAttributeConstant;
import org.jhotdraw.framework.FigureChangeEvent;
import org.jhotdraw.framework.HandleEnumeration;
import org.jhotdraw.standard.BoxHandleKit;
import org.jhotdraw.standard.CompositeFigure;
import org.jhotdraw.standard.HandleEnumerator;
import org.jhotdraw.util.CollectionsFactory;
import org.jhotdraw.util.StorableInput;
import org.jhotdraw.util.StorableOutput;

public class GraphicalCompositeFigure
extends CompositeFigure
implements Layoutable {
    private Figure myPresentationFigure;
    private Layouter myLayouter;
    private static final long serialVersionUID = 1265742491024232713L;

    public GraphicalCompositeFigure() {
        this(new RectangleFigure());
    }

    public GraphicalCompositeFigure(Figure figure) {
        this.setPresentationFigure(figure);
        this.initialize();
    }

    protected void initialize() {
        if (this.getLayouter() != null) {
            this.setLayouter(this.getLayouter().create(this));
        } else {
            this.setLayouter(new StandardLayouter(this));
        }
    }

    public Object clone() {
        Object object = super.clone();
        ((GraphicalCompositeFigure)object).initialize();
        return object;
    }

    public Rectangle displayBox() {
        return this.getPresentationFigure().displayBox();
    }

    public void basicDisplayBox(Point point, Point point2) {
        Rectangle rectangle = this.getLayouter().layout(point, point2);
        this.getPresentationFigure().basicDisplayBox(rectangle.getLocation(), new Point((int)rectangle.getMaxX(), (int)rectangle.getMaxY()));
    }

    protected void basicMoveBy(int n, int n2) {
        super.basicMoveBy(n, n2);
        this.getPresentationFigure().moveBy(n, n2);
    }

    public void update() {
        this.willChange();
        this.layout();
        this.change();
        this.changed();
    }

    public void draw(Graphics graphics) {
        this.getPresentationFigure().draw(graphics);
        super.draw(graphics);
    }

    public HandleEnumeration handles() {
        List list = CollectionsFactory.current().createList();
        BoxHandleKit.addHandles(this, list);
        return new HandleEnumerator(list);
    }

    public Object getAttribute(String string) {
        if (this.getPresentationFigure() != null) {
            return this.getPresentationFigure().getAttribute(string);
        }
        return super.getAttribute(string);
    }

    public Object getAttribute(FigureAttributeConstant figureAttributeConstant) {
        if (this.getPresentationFigure() != null) {
            return this.getPresentationFigure().getAttribute(figureAttributeConstant);
        }
        return super.getAttribute(figureAttributeConstant);
    }

    public void setAttribute(String string, Object object) {
        if (this.getPresentationFigure() != null) {
            this.getPresentationFigure().setAttribute(string, object);
        } else {
            super.setAttribute(string, object);
        }
    }

    public void setAttribute(FigureAttributeConstant figureAttributeConstant, Object object) {
        if (this.getPresentationFigure() != null) {
            this.getPresentationFigure().setAttribute(figureAttributeConstant, object);
        } else {
            super.setAttribute(figureAttributeConstant, object);
        }
    }

    public void setPresentationFigure(Figure figure) {
        this.myPresentationFigure = figure;
    }

    public Figure getPresentationFigure() {
        return this.myPresentationFigure;
    }

    public void layout() {
        if (this.getLayouter() != null) {
            Rectangle rectangle = this.getLayouter().calculateLayout(this.displayBox().getLocation(), this.displayBox().getLocation());
            this.displayBox(rectangle.getLocation(), new Point(rectangle.x + rectangle.width, rectangle.y + rectangle.height));
        }
    }

    public void setLayouter(Layouter layouter) {
        this.myLayouter = layouter;
    }

    public Layouter getLayouter() {
        return this.myLayouter;
    }

    protected void change() {
        if (this.listener() != null) {
            this.listener().figureRequestUpdate(new FigureChangeEvent(this));
        }
    }

    public void figureRequestRemove(FigureChangeEvent figureChangeEvent) {
        if (this.listener() != null) {
            if (this.includes(figureChangeEvent.getFigure())) {
                Rectangle rectangle = this.invalidateRectangle(this.displayBox());
                this.listener().figureRequestRemove(new FigureChangeEvent(this, rectangle, figureChangeEvent));
            } else {
                super.figureRequestRemove(figureChangeEvent);
            }
        }
    }

    public void read(StorableInput storableInput) throws IOException {
        super.read(storableInput);
        this.setPresentationFigure((Figure)storableInput.readStorable());
        this.setLayouter((Layouter)storableInput.readStorable());
    }

    public void write(StorableOutput storableOutput) {
        super.write(storableOutput);
        storableOutput.writeStorable(this.getPresentationFigure());
        storableOutput.writeStorable(this.getLayouter());
    }
}

