/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.figures;

import com.wombatinvasion.pmwikidraw.PmWikiDraw;
import com.wombatinvasion.pmwikidraw.PmWikiDrawURLEncoder;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.image.ImageObserver;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.List;
import org.jhotdraw.figures.AttributeFigure;
import org.jhotdraw.framework.FigureAttributeConstant;
import org.jhotdraw.framework.FigureChangeEvent;
import org.jhotdraw.framework.HandleEnumeration;
import org.jhotdraw.standard.BoxHandleKit;
import org.jhotdraw.standard.HandleEnumerator;
import org.jhotdraw.util.CollectionsFactory;
import org.jhotdraw.util.Iconkit;
import org.jhotdraw.util.StorableInput;
import org.jhotdraw.util.StorableOutput;

public class ImageFigure
extends AttributeFigure
implements ImageObserver {
    private String fFileName;
    private transient Image fImage;
    private Rectangle fDisplayBox;
    private String fRelativeUrlPath;
    private static final long serialVersionUID = 148012030121282439L;
    private int imageFigureSerializedDataVersion = 1;

    public ImageFigure() {
        this.fFileName = null;
        this.fImage = null;
        this.fDisplayBox = null;
        this.fRelativeUrlPath = null;
    }

    public ImageFigure(Image image, String string, Point point) {
        this.fFileName = string;
        this.fImage = image;
        this.basicDisplayBox(point, new Point(point.x + this.fImage.getWidth(this), point.y + this.fImage.getHeight(this)));
        this.fRelativeUrlPath = null;
    }

    public ImageFigure(Image image, String string, Point point, String string2) {
        this(image, string, point);
        this.fRelativeUrlPath = string2;
    }

    public void basicDisplayBox(Point point, Point point2) {
        this.fDisplayBox = new Rectangle(point);
        this.fDisplayBox.add(point2);
    }

    public HandleEnumeration handles() {
        List list = CollectionsFactory.current().createList();
        BoxHandleKit.addHandles(this, list);
        return new HandleEnumerator(list);
    }

    public Rectangle displayBox() {
        return new Rectangle(this.fDisplayBox.x, this.fDisplayBox.y, this.fDisplayBox.width, this.fDisplayBox.height);
    }

    protected void basicMoveBy(int n, int n2) {
        this.fDisplayBox.translate(n, n2);
    }

    public void draw(Graphics graphics) {
        if (this.fImage == null) {
            this.fImage = Iconkit.instance().getImage(this.fFileName);
        }
        if (this.fImage != null) {
            RenderingHints renderingHints = ((Graphics2D)graphics).getRenderingHints();
            ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_DEFAULT);
            graphics.drawImage(this.fImage, this.fDisplayBox.x, this.fDisplayBox.y, this.fDisplayBox.width, this.fDisplayBox.height, this);
            ((Graphics2D)graphics).setRenderingHints(renderingHints);
        } else {
            this.drawGhost(graphics);
        }
    }

    private void drawGhost(Graphics graphics) {
        graphics.setColor(Color.gray);
        graphics.fillRect(this.fDisplayBox.x, this.fDisplayBox.y, this.fDisplayBox.width, this.fDisplayBox.height);
    }

    public boolean imageUpdate(Image image, int n, int n2, int n3, int n4, int n5) {
        if ((n & 0x30) != 0) {
            this.invalidate();
            if (this.listener() != null) {
                this.listener().figureRequestUpdate(new FigureChangeEvent(this));
            }
        }
        return (n & 0xA0) == 0;
    }

    public void release() {
        this.fImage.flush();
    }

    public void write(StorableOutput storableOutput) {
        super.write(storableOutput);
        storableOutput.writeInt(this.fDisplayBox.x);
        storableOutput.writeInt(this.fDisplayBox.y);
        storableOutput.writeInt(this.fDisplayBox.width);
        storableOutput.writeInt(this.fDisplayBox.height);
        if (this.fRelativeUrlPath != null && this.fFileName.indexOf(this.fRelativeUrlPath) >= 0) {
            int n = this.fFileName.indexOf(this.fRelativeUrlPath);
            storableOutput.writeString("%RESOURCE_URL%" + this.fFileName.substring(n + this.fRelativeUrlPath.length()));
        } else {
            storableOutput.writeString(this.fFileName);
        }
    }

    public void read(StorableInput storableInput) throws IOException {
        super.read(storableInput);
        this.fRelativeUrlPath = PmWikiDraw.getResourcePath();
        this.fDisplayBox = new Rectangle(storableInput.readInt(), storableInput.readInt(), storableInput.readInt(), storableInput.readInt());
        this.fFileName = storableInput.readString();
        if (this.fRelativeUrlPath != null && this.fFileName.indexOf("%RESOURCE_URL%") >= 0) {
            int n = this.fFileName.indexOf("%RESOURCE_URL%");
            this.fFileName = this.fRelativeUrlPath + this.fFileName.substring(n + "%RESOURCE_URL%".length());
        }
        Iconkit.instance().registerImage(this.fFileName);
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        objectInputStream.defaultReadObject();
        Iconkit.instance().registerImage(this.fFileName);
        this.fImage = null;
    }

    public String getMap() {
        String string = (String)this.getAttribute(FigureAttributeConstant.URL);
        if (string != null && string.length() > 0) {
            try {
                string = PmWikiDrawURLEncoder.decode(string);
            }
            catch (Exception exception) {
                // empty catch block
            }
            Rectangle rectangle = this.displayBox();
            return "<area shape=\"rect\" coords=\"" + rectangle.x + "," + rectangle.y + "," + (rectangle.x + rectangle.width) + "," + (rectangle.y + rectangle.height) + "\" href=\"" + string + "\" alt=\"" + string + "\" />";
        }
        return "";
    }
}

