/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.figures;

import java.awt.Component;
import java.awt.Image;
import java.lang.ref.WeakReference;
import org.jhotdraw.figures.ImageFigure;
import org.jhotdraw.framework.DrawingEditor;
import org.jhotdraw.framework.DrawingView;
import org.jhotdraw.standard.AbstractCommand;
import org.jhotdraw.util.Iconkit;
import org.jhotdraw.util.Undoable;
import org.jhotdraw.util.UndoableAdapter;

public class InsertImageCommand
extends AbstractCommand {
    private String myImageName;
    private String relativeUrl = null;

    public InsertImageCommand(String string, String string2, DrawingEditor drawingEditor) {
        super(string, drawingEditor);
        this.myImageName = string2;
        new Throwable().printStackTrace();
    }

    public InsertImageCommand(String string, String string2, DrawingEditor drawingEditor, String string3) {
        super(string, drawingEditor);
        this.myImageName = string2;
        this.relativeUrl = string3;
    }

    public void execute() {
        super.execute();
        this.setUndoActivity(this.createUndoActivity());
        ((UndoActivity)this.getUndoActivity()).insertImage();
        this.view().checkDamage();
    }

    protected Undoable createUndoActivity() {
        return new UndoActivity(this.view(), this.myImageName, this.relativeUrl);
    }

    public class UndoActivity
    extends UndoableAdapter {
        WeakReference myAffectedImageFigure;
        private String myAffectedImageName;
        private String myRelativeUrl;

        UndoActivity(DrawingView drawingView, String string, String string2) {
            super(drawingView);
            this.myAffectedImageName = string;
            this.myRelativeUrl = string2;
            this.setUndoable(true);
            this.setRedoable(true);
        }

        protected void setImageFigure(ImageFigure imageFigure) {
            this.myAffectedImageFigure = new WeakReference<ImageFigure>(imageFigure);
        }

        protected ImageFigure getImageFigure() {
            if (this.myAffectedImageFigure == null || this.myAffectedImageFigure.get() == null) {
                Image image = Iconkit.instance().registerAndLoadImage((Component)((Object)this.getDrawingView()), this.myAffectedImageName);
                this.setImageFigure(new ImageFigure(image, this.myAffectedImageName, this.getDrawingView().lastClick(), this.myRelativeUrl));
            }
            return (ImageFigure)this.myAffectedImageFigure.get();
        }

        public boolean undo() {
            if (super.undo()) {
                this.getDrawingView().clearSelection();
                this.getDrawingView().drawing().orphan(this.getImageFigure());
                return true;
            }
            return false;
        }

        public boolean redo() {
            if (this.isRedoable()) {
                this.insertImage();
                return true;
            }
            return false;
        }

        protected void insertImage() {
            this.getDrawingView().add(this.getImageFigure());
            this.getDrawingView().clearSelection();
            this.getDrawingView().addToSelection(this.getImageFigure());
        }
    }
}

