/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.figures;

import com.wombatinvasion.pmwikidraw.PmWikiDrawURLEncoder;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.IOException;
import java.util.List;
import org.jhotdraw.figures.AttributeFigure;
import org.jhotdraw.figures.RadiusHandle;
import org.jhotdraw.figures.ShortestDistanceConnector;
import org.jhotdraw.framework.Connector;
import org.jhotdraw.framework.FigureAttributeConstant;
import org.jhotdraw.framework.HandleEnumeration;
import org.jhotdraw.standard.BoxHandleKit;
import org.jhotdraw.standard.HandleEnumerator;
import org.jhotdraw.util.CollectionsFactory;
import org.jhotdraw.util.StorableInput;
import org.jhotdraw.util.StorableOutput;

public class RoundRectangleFigure
extends AttributeFigure {
    private Rectangle fDisplayBox;
    private int fArcWidth;
    private int fArcHeight;
    private static final int DEFAULT_ARC = 8;
    private static final long serialVersionUID = 7907900248924036885L;
    private int roundRectangleSerializedDataVersion = 1;

    public RoundRectangleFigure() {
        this(new Point(0, 0), new Point(0, 0));
        this.fArcHeight = 8;
        this.fArcWidth = 8;
    }

    public RoundRectangleFigure(Point point, Point point2) {
        this.basicDisplayBox(point, point2);
        this.fArcHeight = 8;
        this.fArcWidth = 8;
    }

    public void basicDisplayBox(Point point, Point point2) {
        this.fDisplayBox = new Rectangle(point);
        this.fDisplayBox.add(point2);
    }

    public void setArc(int n, int n2) {
        this.willChange();
        this.fArcWidth = n;
        this.fArcHeight = n2;
        this.changed();
    }

    public Point getArc() {
        return new Point(this.fArcWidth, this.fArcHeight);
    }

    public HandleEnumeration handles() {
        List list = CollectionsFactory.current().createList();
        BoxHandleKit.addHandles(this, list);
        list.add(new RadiusHandle(this));
        return new HandleEnumerator(list);
    }

    public Rectangle displayBox() {
        return new Rectangle(this.fDisplayBox.x, this.fDisplayBox.y, this.fDisplayBox.width, this.fDisplayBox.height);
    }

    protected void basicMoveBy(int n, int n2) {
        this.fDisplayBox.translate(n, n2);
    }

    public void drawBackground(Graphics graphics) {
        Rectangle rectangle = this.displayBox();
        graphics.fillRoundRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height, this.fArcWidth, this.fArcHeight);
    }

    public void drawFrame(Graphics graphics) {
        Rectangle rectangle = this.displayBox();
        graphics.drawRoundRect(rectangle.x, rectangle.y, rectangle.width - 1, rectangle.height - 1, this.fArcWidth, this.fArcHeight);
    }

    public Insets connectionInsets() {
        return new Insets(this.fArcHeight / 2, this.fArcWidth / 2, this.fArcHeight / 2, this.fArcWidth / 2);
    }

    public Connector connectorAt(int n, int n2) {
        return new ShortestDistanceConnector(this);
    }

    public void write(StorableOutput storableOutput) {
        super.write(storableOutput);
        storableOutput.writeInt(this.fDisplayBox.x);
        storableOutput.writeInt(this.fDisplayBox.y);
        storableOutput.writeInt(this.fDisplayBox.width);
        storableOutput.writeInt(this.fDisplayBox.height);
        storableOutput.writeInt(this.fArcWidth);
        storableOutput.writeInt(this.fArcHeight);
    }

    public void read(StorableInput storableInput) throws IOException {
        super.read(storableInput);
        this.fDisplayBox = new Rectangle(storableInput.readInt(), storableInput.readInt(), storableInput.readInt(), storableInput.readInt());
        this.fArcWidth = storableInput.readInt();
        this.fArcHeight = storableInput.readInt();
    }

    public String getMap() {
        String string = (String)this.getAttribute(FigureAttributeConstant.URL);
        if (string != null && string.length() > 0) {
            try {
                string = PmWikiDrawURLEncoder.decode(string);
            }
            catch (Exception exception) {
                // empty catch block
            }
            Rectangle rectangle = this.displayBox();
            return "<area shape=\"rect\" coords=\"" + rectangle.x + "," + rectangle.y + "," + (rectangle.x + rectangle.width) + "," + (rectangle.y + rectangle.height) + "\" href=\"" + string + "\" alt=\"" + string + "\" />";
        }
        return "";
    }
}

