/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.standard;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import org.jhotdraw.framework.Cursor;
import org.jhotdraw.framework.Drawing;
import org.jhotdraw.framework.DrawingView;
import org.jhotdraw.framework.Figure;
import org.jhotdraw.framework.Handle;
import org.jhotdraw.standard.AWTCursor;
import org.jhotdraw.util.Undoable;

public abstract class AbstractHandle
implements Handle {
    public static final int HANDLESIZE = 8;
    private Figure fOwner;
    private Undoable myUndoableActivity;

    public AbstractHandle(Figure figure) {
        this.fOwner = figure;
    }

    public void invokeStart(int n, int n2, DrawingView drawingView) {
        this.invokeStart(n, n2, drawingView.drawing());
    }

    public void invokeStart(int n, int n2, Drawing drawing) {
    }

    public void invokeStep(int n, int n2, int n3, int n4, DrawingView drawingView) {
        this.invokeStep(n - n3, n2 - n4, drawingView.drawing());
    }

    public void invokeStep(int n, int n2, Drawing drawing) {
    }

    public void invokeEnd(int n, int n2, int n3, int n4, DrawingView drawingView) {
        this.invokeEnd(n - n3, n2 - n4, drawingView.drawing());
    }

    public void invokeEnd(int n, int n2, Drawing drawing) {
    }

    public Figure owner() {
        return this.fOwner;
    }

    public Rectangle displayBox() {
        Point point = this.locate();
        return new Rectangle(point.x - 4, point.y - 4, 8, 8);
    }

    public boolean containsPoint(int n, int n2) {
        return this.displayBox().contains(n, n2);
    }

    public void draw(Graphics graphics) {
        Rectangle rectangle = this.displayBox();
        graphics.setColor(Color.white);
        graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        graphics.setColor(Color.black);
        graphics.drawRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public Undoable getUndoActivity() {
        return this.myUndoableActivity;
    }

    public void setUndoActivity(Undoable undoable) {
        this.myUndoableActivity = undoable;
    }

    public Cursor getCursor() {
        return new AWTCursor(0);
    }

    public abstract /* synthetic */ Point locate();
}

