/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.standard;

import java.awt.Point;
import java.awt.Rectangle;
import org.jhotdraw.framework.Figure;
import org.jhotdraw.standard.AbstractLocator;

public class PeripheralLocator
extends AbstractLocator {
    private static int CORNERSPACE = 1;
    private Figure fOwner;
    private int fPPS;
    private int fIndex;

    private PeripheralLocator() {
    }

    public PeripheralLocator(int n, int n2) {
        this.fPPS = n;
        this.fIndex = n2;
        if (n2 >= n * 4) {
            throw new IllegalArgumentException("Index must be within the range of points starting with index = 0.");
        }
    }

    public Point locate(Figure figure) {
        Rectangle rectangle = figure.displayBox();
        float f = (float)rectangle.width / (float)(this.fPPS + 1);
        float f2 = (float)rectangle.height / (float)(this.fPPS + 1);
        int n = 0;
        int n2 = 0;
        if (this.fIndex < this.fPPS) {
            n = Math.round(((float)this.fIndex + 1.0f) * f);
            n2 = 0;
        } else if (this.fIndex < this.fPPS * 2) {
            n = Math.round((float)(this.fPPS + 1) * f);
            n2 = Math.round((float)(this.fIndex + 1 - this.fPPS) * f2);
        } else if (this.fIndex < this.fPPS * 3) {
            n = Math.round((float)(this.fPPS + 1 - (this.fIndex + 1 - this.fPPS * 2)) * f);
            n2 = Math.round((float)(this.fPPS + 1) * f2);
        } else {
            n = 0;
            n2 = Math.round((float)(this.fPPS + 1 - (this.fIndex + 1 - this.fPPS * 3)) * f2);
        }
        return new Point(n += rectangle.x, n2 += rectangle.y);
    }
}

