/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.standard;

import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import org.jhotdraw.framework.FigureEnumeration;
import org.jhotdraw.standard.FigureEnumerator;
import org.jhotdraw.util.CollectionsFactory;

class QuadTree
implements Serializable {
    private Rectangle2D _absoluteBoundingRectangle2D = new Rectangle2D.Double();
    private int _nMaxTreeDepth;
    private Hashtable _theHashtable = new Hashtable();
    private Hashtable _outsideHashtable = new Hashtable();
    private QuadTree _nwQuadTree;
    private QuadTree _neQuadTree;
    private QuadTree _swQuadTree;
    private QuadTree _seQuadTree;

    public QuadTree(Rectangle2D rectangle2D) {
        this(2, rectangle2D);
    }

    public QuadTree(int n, Rectangle2D rectangle2D) {
        this._init(n, rectangle2D);
    }

    public void add(Object object, Rectangle2D rectangle2D) {
        if (this._nMaxTreeDepth == 1) {
            if (rectangle2D.intersects(this._absoluteBoundingRectangle2D)) {
                this._theHashtable.put(object, rectangle2D);
            } else {
                this._outsideHashtable.put(object, rectangle2D);
            }
            return;
        }
        boolean bl = rectangle2D.intersects(this._nwQuadTree.getAbsoluteBoundingRectangle2D());
        boolean bl2 = rectangle2D.intersects(this._neQuadTree.getAbsoluteBoundingRectangle2D());
        boolean bl3 = rectangle2D.intersects(this._swQuadTree.getAbsoluteBoundingRectangle2D());
        boolean bl4 = rectangle2D.intersects(this._seQuadTree.getAbsoluteBoundingRectangle2D());
        int n = 0;
        if (bl) {
            ++n;
        }
        if (bl2) {
            ++n;
        }
        if (bl3) {
            ++n;
        }
        if (bl4) {
            ++n;
        }
        if (n > 1) {
            this._theHashtable.put(object, rectangle2D);
            return;
        }
        if (n == 0) {
            this._outsideHashtable.put(object, rectangle2D);
            return;
        }
        if (bl) {
            this._nwQuadTree.add(object, rectangle2D);
        }
        if (bl2) {
            this._neQuadTree.add(object, rectangle2D);
        }
        if (bl3) {
            this._swQuadTree.add(object, rectangle2D);
        }
        if (bl4) {
            this._seQuadTree.add(object, rectangle2D);
        }
    }

    public Object remove(Object object) {
        Object object2 = this._theHashtable.remove(object);
        if (object2 != null) {
            return object2;
        }
        if (this._nMaxTreeDepth > 1) {
            object2 = this._nwQuadTree.remove(object);
            if (object2 != null) {
                return object2;
            }
            object2 = this._neQuadTree.remove(object);
            if (object2 != null) {
                return object2;
            }
            object2 = this._swQuadTree.remove(object);
            if (object2 != null) {
                return object2;
            }
            object2 = this._seQuadTree.remove(object);
            if (object2 != null) {
                return object2;
            }
        }
        if ((object2 = this._outsideHashtable.remove(object)) != null) {
            return object2;
        }
        return null;
    }

    public void clear() {
        this._theHashtable.clear();
        this._outsideHashtable.clear();
        if (this._nMaxTreeDepth > 1) {
            this._nwQuadTree.clear();
            this._neQuadTree.clear();
            this._swQuadTree.clear();
            this._seQuadTree.clear();
        }
    }

    public int getMaxTreeDepth() {
        return this._nMaxTreeDepth;
    }

    public FigureEnumeration getAllWithin(Rectangle2D rectangle2D) {
        Rectangle2D rectangle2D2;
        Object k;
        List list = CollectionsFactory.current().createList();
        Iterator iterator = this._outsideHashtable.keySet().iterator();
        while (iterator.hasNext()) {
            k = iterator.next();
            rectangle2D2 = (Rectangle2D)this._outsideHashtable.get(k);
            if (!rectangle2D2.intersects(rectangle2D)) continue;
            list.add(k);
        }
        if (this._absoluteBoundingRectangle2D.intersects(rectangle2D)) {
            iterator = this._theHashtable.keySet().iterator();
            while (iterator.hasNext()) {
                k = iterator.next();
                rectangle2D2 = (Rectangle2D)this._theHashtable.get(k);
                if (!rectangle2D2.intersects(rectangle2D)) continue;
                list.add(k);
            }
            if (this._nMaxTreeDepth > 1) {
                list.add(this._nwQuadTree.getAllWithin(rectangle2D));
                list.add(this._neQuadTree.getAllWithin(rectangle2D));
                list.add(this._swQuadTree.getAllWithin(rectangle2D));
                list.add(this._seQuadTree.getAllWithin(rectangle2D));
            }
        }
        return new FigureEnumerator(list);
    }

    public Rectangle2D getAbsoluteBoundingRectangle2D() {
        return this._absoluteBoundingRectangle2D;
    }

    private void _init(int n, Rectangle2D rectangle2D) {
        this._absoluteBoundingRectangle2D.setRect(rectangle2D);
        this._nMaxTreeDepth = n;
        if (this._nMaxTreeDepth > 1) {
            this._nwQuadTree = new QuadTree(this._nMaxTreeDepth - 1, this._makeNorthwest(rectangle2D));
            this._neQuadTree = new QuadTree(this._nMaxTreeDepth - 1, this._makeNortheast(rectangle2D));
            this._swQuadTree = new QuadTree(this._nMaxTreeDepth - 1, this._makeSouthwest(rectangle2D));
            this._seQuadTree = new QuadTree(this._nMaxTreeDepth - 1, this._makeSoutheast(rectangle2D));
        }
    }

    private Rectangle2D _makeNorthwest(Rectangle2D rectangle2D) {
        return new Rectangle2D.Double(rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth() / 2.0, rectangle2D.getHeight() / 2.0);
    }

    private Rectangle2D _makeNortheast(Rectangle2D rectangle2D) {
        return new Rectangle2D.Double(rectangle2D.getX() + rectangle2D.getWidth() / 2.0, rectangle2D.getY(), rectangle2D.getWidth() / 2.0, rectangle2D.getHeight() / 2.0);
    }

    private Rectangle2D _makeSouthwest(Rectangle2D rectangle2D) {
        return new Rectangle2D.Double(rectangle2D.getX(), rectangle2D.getY() + rectangle2D.getHeight() / 2.0, rectangle2D.getWidth() / 2.0, rectangle2D.getHeight() / 2.0);
    }

    private Rectangle2D _makeSoutheast(Rectangle2D rectangle2D) {
        return new Rectangle2D.Double(rectangle2D.getX() + rectangle2D.getWidth() / 2.0, rectangle2D.getY() + rectangle2D.getHeight() / 2.0, rectangle2D.getWidth() / 2.0, rectangle2D.getHeight() / 2.0);
    }
}

