/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.samples.svg.figures;

import java.awt.AlphaComposite;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import org.jhotdraw.draw.AbstractAttributedCompositeFigure;
import org.jhotdraw.draw.AttributeKey;
import org.jhotdraw.draw.AttributeKeys;
import org.jhotdraw.draw.ConnectionFigure;
import org.jhotdraw.draw.Connector;
import org.jhotdraw.draw.DrawingView;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.draw.Handle;
import org.jhotdraw.draw.TransformHandleKit;
import org.jhotdraw.geom.Geom;
import org.jhotdraw.geom.GrowStroke;
import org.jhotdraw.geom.Shapes;
import org.jhotdraw.samples.svg.Gradient;
import org.jhotdraw.samples.svg.SVGAttributeKeys;
import org.jhotdraw.samples.svg.figures.LinkHandle;
import org.jhotdraw.samples.svg.figures.SVGBezierFigure;
import org.jhotdraw.samples.svg.figures.SVGFigure;
import org.jhotdraw.samples.svg.figures.SVGPathOutlineHandle;
import org.jhotdraw.util.ResourceBundleUtil;
import org.jhotdraw.xml.DOMInput;
import org.jhotdraw.xml.DOMOutput;

public class SVGPathFigure
extends AbstractAttributedCompositeFigure
implements SVGFigure {
    private transient GeneralPath cachedPath;
    private transient Shape cachedHitShape;
    private static final boolean DEBUG = false;

    public SVGPathFigure() {
        this.add(new SVGBezierFigure());
        SVGAttributeKeys.setDefaults(this);
    }

    public SVGPathFigure(boolean bl) {
        if (!bl) {
            this.add(new SVGBezierFigure());
        }
        SVGAttributeKeys.setDefaults(this);
    }

    @Override
    public void draw(Graphics2D graphics2D) {
        double d = this.get(SVGAttributeKeys.OPACITY);
        if ((d = Math.min(Math.max(0.0, d), 1.0)) != 0.0) {
            if (d != 1.0) {
                Rectangle2D.Double double_ = this.getDrawingArea();
                Rectangle rectangle = graphics2D.getClipBounds();
                if (rectangle != null) {
                    Rectangle2D.intersect(double_, rectangle, double_);
                }
                if (!double_.isEmpty()) {
                    BufferedImage bufferedImage = new BufferedImage(Math.max(1, (int)((2.0 + double_.width) * graphics2D.getTransform().getScaleX())), Math.max(1, (int)((2.0 + double_.height) * graphics2D.getTransform().getScaleY())), 2);
                    Graphics2D graphics2D2 = bufferedImage.createGraphics();
                    graphics2D2.scale(graphics2D.getTransform().getScaleX(), graphics2D.getTransform().getScaleY());
                    graphics2D2.translate((int)(-double_.x), (int)(-double_.y));
                    graphics2D2.setRenderingHints(graphics2D.getRenderingHints());
                    this.drawFigure(graphics2D2);
                    graphics2D2.dispose();
                    Composite composite = graphics2D.getComposite();
                    graphics2D.setComposite(AlphaComposite.getInstance(3, (float)d));
                    graphics2D.drawImage(bufferedImage, (int)double_.x, (int)double_.y, 2 + (int)double_.width, 2 + (int)double_.height, null);
                    graphics2D.setComposite(composite);
                }
            } else {
                this.drawFigure(graphics2D);
            }
        }
    }

    @Override
    public void drawFigure(Graphics2D graphics2D) {
        Paint paint;
        AffineTransform affineTransform = null;
        if (this.get(SVGAttributeKeys.TRANSFORM) != null) {
            affineTransform = graphics2D.getTransform();
            graphics2D.transform((AffineTransform)this.get(SVGAttributeKeys.TRANSFORM));
        }
        if ((paint = SVGAttributeKeys.getFillPaint(this)) != null) {
            graphics2D.setPaint(paint);
            this.drawFill(graphics2D);
        }
        if ((paint = SVGAttributeKeys.getStrokePaint(this)) != null) {
            graphics2D.setPaint(paint);
            graphics2D.setStroke(SVGAttributeKeys.getStroke(this));
            this.drawStroke(graphics2D);
        }
        if (this.get(SVGAttributeKeys.TRANSFORM) != null) {
            graphics2D.setTransform(affineTransform);
        }
    }

    @Override
    protected void drawChildren(Graphics2D graphics2D) {
    }

    @Override
    public void drawFill(Graphics2D graphics2D) {
        graphics2D.fill(this.getPath());
    }

    @Override
    public void drawStroke(Graphics2D graphics2D) {
        graphics2D.draw(this.getPath());
    }

    @Override
    protected void invalidate() {
        super.invalidate();
        this.cachedPath = null;
        this.cachedDrawingArea = null;
        this.cachedHitShape = null;
    }

    protected GeneralPath getPath() {
        if (this.cachedPath == null) {
            this.cachedPath = new GeneralPath();
            this.cachedPath.setWindingRule(this.get(SVGAttributeKeys.WINDING_RULE) == AttributeKeys.WindingRule.EVEN_ODD ? 0 : 1);
            for (Figure figure : this.getChildren()) {
                SVGBezierFigure sVGBezierFigure = (SVGBezierFigure)figure;
                this.cachedPath.append(sVGBezierFigure.getBezierPath(), false);
            }
        }
        return this.cachedPath;
    }

    protected Shape getHitShape() {
        if (this.cachedHitShape == null) {
            this.cachedHitShape = this.getPath();
            if (this.get(SVGAttributeKeys.FILL_COLOR) == null && this.get(SVGAttributeKeys.FILL_GRADIENT) == null) {
                this.cachedHitShape = SVGAttributeKeys.getHitStroke(this).createStrokedShape(this.cachedHitShape);
            }
        }
        return this.cachedHitShape;
    }

    @Override
    public Rectangle2D.Double getDrawingArea() {
        if (this.cachedDrawingArea == null) {
            Rectangle2D rectangle2D;
            double d = Math.max(1.0, AttributeKeys.getStrokeTotalWidth(this));
            double d2 = d / 2.0;
            if ((Integer)this.get(SVGAttributeKeys.STROKE_JOIN) == 0) {
                d2 *= ((Double)this.get(SVGAttributeKeys.STROKE_MITER_LIMIT)).doubleValue();
            } else if ((Integer)this.get(SVGAttributeKeys.STROKE_CAP) != 0) {
                d2 += d * 2.0;
            }
            Shape shape = this.getPath();
            Rectangle2D rectangle2D2 = new Rectangle2D.Double(0.0, 0.0, d2, d2);
            AffineTransform affineTransform = (AffineTransform)this.get(SVGAttributeKeys.TRANSFORM);
            if (affineTransform != null) {
                shape = affineTransform.createTransformedShape(shape.getBounds2D());
                rectangle2D2 = affineTransform.createTransformedShape(rectangle2D2).getBounds2D();
            }
            Rectangle2D.Double double_ = (rectangle2D = shape.getBounds2D()) instanceof Rectangle2D.Double ? (Rectangle2D.Double)rectangle2D : new Rectangle2D.Double(rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth(), rectangle2D.getHeight());
            Geom.grow(double_, rectangle2D2.getWidth(), rectangle2D2.getHeight());
            this.cachedDrawingArea = double_;
        }
        return (Rectangle2D.Double)this.cachedDrawingArea.clone();
    }

    @Override
    public final void write(DOMOutput dOMOutput) throws IOException {
        throw new UnsupportedOperationException("Use SVGStorableOutput to write this Figure.");
    }

    @Override
    public final void read(DOMInput dOMInput) throws IOException {
        throw new UnsupportedOperationException("Use SVGStorableInput to read this Figure.");
    }

    @Override
    public boolean contains(Point2D.Double double_) {
        boolean bl;
        this.getPath();
        if (this.get(SVGAttributeKeys.TRANSFORM) != null) {
            try {
                double_ = (Point2D.Double)((AffineTransform)this.get(SVGAttributeKeys.TRANSFORM)).inverseTransform(double_, new Point2D.Double());
            }
            catch (NoninvertibleTransformException noninvertibleTransformException) {
                noninvertibleTransformException.printStackTrace();
            }
        }
        if ((bl = ((Boolean)this.getChild(0).get(SVGAttributeKeys.PATH_CLOSED)).booleanValue()) && this.get(SVGAttributeKeys.FILL_COLOR) == null && this.get(SVGAttributeKeys.FILL_GRADIENT) == null) {
            return this.getHitShape().contains(double_);
        }
        double d = Math.max(2.0, AttributeKeys.getStrokeTotalWidth(this) / 2.0);
        if (bl || this.get(SVGAttributeKeys.FILL_COLOR) != null || this.get(SVGAttributeKeys.FILL_GRADIENT) != null) {
            if (this.getPath().contains(double_)) {
                return true;
            }
            double d2 = AttributeKeys.getPerpendicularHitGrowth(this);
            GrowStroke growStroke = new GrowStroke((float)d2, (float)(AttributeKeys.getStrokeTotalWidth(this) * (Double)this.get(SVGAttributeKeys.STROKE_MITER_LIMIT)));
            if (growStroke.createStrokedShape(this.getPath()).contains(double_)) {
                return true;
            }
            if (bl) {
                return false;
            }
        }
        return !bl && Shapes.outlineContains(this.getPath(), double_, d);
    }

    @Override
    public void setBounds(Point2D.Double double_, Point2D.Double double_2) {
        if (this.getChildCount() == 1 && this.getChild(0).getNodeCount() <= 2) {
            SVGBezierFigure sVGBezierFigure = this.getChild(0);
            sVGBezierFigure.setBounds(double_, double_2);
            this.invalidate();
        } else {
            super.setBounds(double_, double_2);
        }
    }

    @Override
    public void transform(AffineTransform affineTransform) {
        if (this.get(SVGAttributeKeys.TRANSFORM) != null || (affineTransform.getType() & 1) != affineTransform.getType()) {
            if (this.get(SVGAttributeKeys.TRANSFORM) == null) {
                SVGAttributeKeys.TRANSFORM.setClone(this, affineTransform);
            } else {
                AffineTransform affineTransform2 = (AffineTransform)SVGAttributeKeys.TRANSFORM.getClone(this);
                affineTransform2.preConcatenate(affineTransform);
                this.set(SVGAttributeKeys.TRANSFORM, affineTransform2);
            }
        } else {
            Object object;
            for (Figure figure : this.getChildren()) {
                figure.transform(affineTransform);
            }
            if (this.get(SVGAttributeKeys.FILL_GRADIENT) != null && !this.get(SVGAttributeKeys.FILL_GRADIENT).isRelativeToFigureBounds()) {
                object = SVGAttributeKeys.FILL_GRADIENT.getClone(this);
                object.transform(affineTransform);
                this.set(SVGAttributeKeys.FILL_GRADIENT, object);
            }
            if (this.get(SVGAttributeKeys.STROKE_GRADIENT) != null && !this.get(SVGAttributeKeys.STROKE_GRADIENT).isRelativeToFigureBounds()) {
                object = SVGAttributeKeys.STROKE_GRADIENT.getClone(this);
                object.transform(affineTransform);
                this.set(SVGAttributeKeys.STROKE_GRADIENT, object);
            }
        }
        this.invalidate();
    }

    @Override
    public void restoreTransformTo(Object object) {
        this.invalidate();
        Object[] objectArray = (Object[])object;
        ArrayList arrayList = (ArrayList)objectArray[0];
        int n = this.getChildCount();
        for (int i = 0; i < n; ++i) {
            this.getChild(i).restoreTransformTo(arrayList.get(i));
        }
        SVGAttributeKeys.TRANSFORM.setClone(this, (AffineTransform)objectArray[1]);
        SVGAttributeKeys.FILL_GRADIENT.setClone(this, (Gradient)objectArray[2]);
        SVGAttributeKeys.STROKE_GRADIENT.setClone(this, (Gradient)objectArray[3]);
    }

    @Override
    public Object getTransformRestoreData() {
        ArrayList<Object> arrayList = new ArrayList<Object>(this.getChildCount());
        int n = this.getChildCount();
        for (int i = 0; i < n; ++i) {
            arrayList.add(this.getChild(i).getTransformRestoreData());
        }
        return new Object[]{arrayList, SVGAttributeKeys.TRANSFORM.getClone(this), SVGAttributeKeys.FILL_GRADIENT.getClone(this), SVGAttributeKeys.STROKE_GRADIENT.getClone(this)};
    }

    @Override
    public <T> void set(AttributeKey<T> attributeKey, T t) {
        super.set(attributeKey, t);
        this.invalidate();
    }

    @Override
    public boolean isEmpty() {
        for (Figure figure : this.getChildren()) {
            SVGBezierFigure sVGBezierFigure = (SVGBezierFigure)figure;
            if (sVGBezierFigure.getNodeCount() <= 0) continue;
            return false;
        }
        return true;
    }

    @Override
    public Collection<Handle> createHandles(int n) {
        LinkedList<Handle> linkedList = new LinkedList<Handle>();
        switch (n % 2) {
            case -1: {
                linkedList.add(new SVGPathOutlineHandle(this, true));
                break;
            }
            case 0: {
                linkedList.add(new SVGPathOutlineHandle(this));
                for (Figure figure : this.getChildren()) {
                    linkedList.addAll(((SVGBezierFigure)figure).createHandles(this, n));
                }
                linkedList.add(new LinkHandle(this));
                break;
            }
            case 1: {
                TransformHandleKit.addTransformHandles(this, linkedList);
                break;
            }
        }
        return linkedList;
    }

    @Override
    public Collection<Action> getActions(Point2D.Double double_) {
        final ResourceBundleUtil resourceBundleUtil = ResourceBundleUtil.getBundle("org.jhotdraw.samples.svg.Labels");
        LinkedList<Action> linkedList = new LinkedList<Action>();
        if (this.get(SVGAttributeKeys.TRANSFORM) != null) {
            linkedList.add(new AbstractAction(resourceBundleUtil.getString("edit.removeTransform.text")){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ResourceBundleUtil resourceBundleUtil = ResourceBundleUtil.getBundle("org.jhotdraw.samples.svg.Labels");
                    SVGPathFigure.this.willChange();
                    SVGPathFigure.this.fireUndoableEditHappened(SVGAttributeKeys.TRANSFORM.setUndoable(SVGPathFigure.this, null));
                    SVGPathFigure.this.changed();
                }
            });
            linkedList.add(new AbstractAction(resourceBundleUtil.getString("edit.flattenTransform.text")){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    final Object object = SVGPathFigure.this.getTransformRestoreData();
                    AbstractUndoableEdit abstractUndoableEdit = new AbstractUndoableEdit(){

                        @Override
                        public String getPresentationName() {
                            return resourceBundleUtil.getString("edit.flattenTransform.text");
                        }

                        @Override
                        public void undo() throws CannotUndoException {
                            super.undo();
                            SVGPathFigure.this.willChange();
                            SVGPathFigure.this.restoreTransformTo(object);
                            SVGPathFigure.this.changed();
                        }

                        @Override
                        public void redo() throws CannotRedoException {
                            super.redo();
                            SVGPathFigure.this.willChange();
                            SVGPathFigure.this.restoreTransformTo(object);
                            SVGPathFigure.this.flattenTransform();
                            SVGPathFigure.this.changed();
                        }
                    };
                    SVGPathFigure.this.willChange();
                    SVGPathFigure.this.flattenTransform();
                    SVGPathFigure.this.changed();
                    SVGPathFigure.this.fireUndoableEditHappened(abstractUndoableEdit);
                }
            });
        }
        if (((Boolean)this.getChild(this.getChildCount() - 1).get(SVGAttributeKeys.PATH_CLOSED)).booleanValue()) {
            linkedList.add(new AbstractAction(resourceBundleUtil.getString("attribute.openPath.text")){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    SVGPathFigure.this.willChange();
                    for (Figure figure : SVGPathFigure.this.getChildren()) {
                        SVGPathFigure.this.getDrawing().fireUndoableEditHappened(SVGAttributeKeys.PATH_CLOSED.setUndoable(figure, false));
                    }
                    SVGPathFigure.this.changed();
                }
            });
        } else {
            linkedList.add(new AbstractAction(resourceBundleUtil.getString("attribute.closePath.text")){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    SVGPathFigure.this.willChange();
                    for (Figure figure : SVGPathFigure.this.getChildren()) {
                        SVGPathFigure.this.getDrawing().fireUndoableEditHappened(SVGAttributeKeys.PATH_CLOSED.setUndoable(figure, true));
                    }
                    SVGPathFigure.this.changed();
                }
            });
        }
        if (this.get(SVGAttributeKeys.WINDING_RULE) != AttributeKeys.WindingRule.EVEN_ODD) {
            linkedList.add(new AbstractAction(resourceBundleUtil.getString("attribute.windingRule.evenOdd.text")){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    SVGPathFigure.this.willChange();
                    SVGPathFigure.this.getDrawing().fireUndoableEditHappened(SVGAttributeKeys.WINDING_RULE.setUndoable(SVGPathFigure.this, AttributeKeys.WindingRule.EVEN_ODD));
                    SVGPathFigure.this.changed();
                }
            });
        } else {
            linkedList.add(new AbstractAction(resourceBundleUtil.getString("attribute.windingRule.nonZero.text")){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    SVGPathFigure.this.willChange();
                    SVGPathFigure.this.set(SVGAttributeKeys.WINDING_RULE, AttributeKeys.WindingRule.NON_ZERO);
                    SVGPathFigure.this.changed();
                    SVGPathFigure.this.getDrawing().fireUndoableEditHappened(SVGAttributeKeys.WINDING_RULE.setUndoable(SVGPathFigure.this, AttributeKeys.WindingRule.NON_ZERO));
                }
            });
        }
        return linkedList;
    }

    @Override
    public boolean canConnect() {
        return false;
    }

    @Override
    public Connector findConnector(Point2D.Double double_, ConnectionFigure connectionFigure) {
        return null;
    }

    @Override
    public Connector findCompatibleConnector(Connector connector, boolean bl) {
        return null;
    }

    @Override
    public boolean handleMouseClick(Point2D.Double double_, MouseEvent mouseEvent, DrawingView drawingView) {
        if (mouseEvent.getClickCount() == 2 && drawingView.getHandleDetailLevel() % 2 == 0) {
            for (Figure figure : this.getChildren()) {
                SVGBezierFigure sVGBezierFigure = (SVGBezierFigure)figure;
                int n = sVGBezierFigure.findSegment(double_, (float)(5.0 / drawingView.getScaleFactor()));
                if (n == -1) continue;
                sVGBezierFigure.handleMouseClick(double_, mouseEvent, drawingView);
                mouseEvent.consume();
                return true;
            }
        }
        return false;
    }

    @Override
    public void add(int n, Figure figure) {
        super.add(n, (SVGBezierFigure)figure);
    }

    @Override
    public SVGBezierFigure getChild(int n) {
        return (SVGBezierFigure)super.getChild(n);
    }

    @Override
    public SVGPathFigure clone() {
        SVGPathFigure sVGPathFigure = (SVGPathFigure)super.clone();
        return sVGPathFigure;
    }

    public void flattenTransform() {
        this.willChange();
        AffineTransform affineTransform = (AffineTransform)this.get(SVGAttributeKeys.TRANSFORM);
        if (affineTransform != null) {
            for (Figure figure : this.getChildren()) {
                ((SVGBezierFigure)figure).flattenTransform();
            }
        }
        if (this.get(SVGAttributeKeys.FILL_GRADIENT) != null) {
            this.get(SVGAttributeKeys.FILL_GRADIENT).transform(affineTransform);
        }
        if (this.get(SVGAttributeKeys.STROKE_GRADIENT) != null) {
            this.get(SVGAttributeKeys.STROKE_GRADIENT).transform(affineTransform);
        }
        this.set(SVGAttributeKeys.TRANSFORM, null);
        this.changed();
    }
}

