/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.gui.datatransfer;

import java.awt.Image;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import javax.imageio.ImageIO;
import org.jhotdraw.util.Images;

public class ImageTransferable
implements Transferable {
    private Image image;
    public static final DataFlavor IMAGE_PNG_FLAVOR;

    public ImageTransferable(Image image) {
        this.image = image;
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
        return dataFlavor.equals(DataFlavor.imageFlavor) || dataFlavor.equals(IMAGE_PNG_FLAVOR);
    }

    @Override
    public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException, IOException {
        if (dataFlavor.equals(DataFlavor.imageFlavor)) {
            return this.image;
        }
        if (dataFlavor.equals(IMAGE_PNG_FLAVOR)) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)Images.toBufferedImage(this.image), "PNG", byteArrayOutputStream);
            return new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
        }
        throw new UnsupportedFlavorException(dataFlavor);
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        return new DataFlavor[]{DataFlavor.imageFlavor, IMAGE_PNG_FLAVOR};
    }

    static {
        try {
            IMAGE_PNG_FLAVOR = new DataFlavor("image/png");
        }
        catch (Exception exception) {
            InternalError internalError = new InternalError("Unable to crate image/png data flavor");
            internalError.initCause(exception);
            throw internalError;
        }
    }
}

