/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.text;

import java.awt.Color;
import java.text.ParseException;
import java.util.prefs.Preferences;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JFormattedTextField;
import javax.swing.text.DefaultFormatter;
import javax.swing.text.DefaultFormatterFactory;
import org.jhotdraw.util.prefs.PreferencesUtil;

public class ColorFormatter
extends DefaultFormatter {
    private Format outputFormat = Format.RGB_INTEGER;
    private Format lastUsedInputFormat = null;
    private static final Pattern rgbHexPattern = Pattern.compile("^\\s*#\\s*([0-9a-fA-F]{3,6})\\s*$");
    private static final Pattern rgbIntegerPattern = Pattern.compile("^\\s*([0-9]{1,3})\\s*,\\s*([0-9]{1,3}),\\s*([0-9]{1,3})\\s*$");
    private boolean allowsNullValue = true;
    private boolean isAdaptive = true;
    private Preferences prefs;

    public ColorFormatter() {
        this(Format.RGB_INTEGER, true, true);
    }

    public ColorFormatter(Format format, boolean bl, boolean bl2) {
        this.outputFormat = format;
        this.allowsNullValue = bl;
        this.isAdaptive = bl2;
        this.prefs = PreferencesUtil.userNodeForPackage(this.getClass());
        try {
            this.lastUsedInputFormat = Format.valueOf(this.prefs.get("ColorFormatter.lastUsedInputFormat", Format.RGB_HEX.name()));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        if (bl2 && this.lastUsedInputFormat != null) {
            this.outputFormat = this.lastUsedInputFormat;
        }
        this.setOverwriteMode(false);
    }

    public void setOutputFormat(Format format) {
        if (format == null) {
            throw new NullPointerException("outputFormat may not be null");
        }
        this.outputFormat = format;
    }

    public Format getOutputFormat() {
        return this.outputFormat;
    }

    public Format getLastUsedInputFormat() {
        return this.lastUsedInputFormat;
    }

    public void setAllowsNullValue(boolean bl) {
        this.allowsNullValue = bl;
    }

    public boolean getAllowsNullValue() {
        return this.allowsNullValue;
    }

    public void setAdaptive(boolean bl) {
        this.isAdaptive = bl;
        if (bl && this.lastUsedInputFormat != null) {
            this.outputFormat = this.lastUsedInputFormat;
        }
    }

    public boolean isAdaptive() {
        return this.isAdaptive;
    }

    private void setLastUsedInputFormat(Format format) {
        this.lastUsedInputFormat = format;
        if (this.isAdaptive) {
            this.outputFormat = this.lastUsedInputFormat;
        }
        this.prefs.put("ColorFormatter.lastUsedInputFormat", format.name());
    }

    @Override
    public Object stringToValue(String string) throws ParseException {
        if (string == null || string.trim().length() == 0) {
            if (this.allowsNullValue) {
                return null;
            }
            throw new ParseException("Null value is not allowed.", 0);
        }
        Matcher matcher = rgbHexPattern.matcher(string);
        if (matcher.matches()) {
            this.setLastUsedInputFormat(Format.RGB_HEX);
            try {
                String string2 = matcher.group(1);
                if (string2.length() == 3) {
                    return new Color(Integer.parseInt("" + string2.charAt(0) + string2.charAt(0) + string2.charAt(1) + string2.charAt(1) + string2.charAt(2) + string2.charAt(2), 16));
                }
                if (string2.length() == 6) {
                    return new Color(Integer.parseInt(string2, 16));
                }
                throw new ParseException("Hex color must have 3 or 6 digits.", 1);
            }
            catch (NumberFormatException numberFormatException) {
                ParseException parseException = new ParseException(string, 0);
                parseException.initCause(numberFormatException);
                throw parseException;
            }
        }
        matcher = rgbIntegerPattern.matcher(string);
        if (matcher.matches()) {
            this.setLastUsedInputFormat(Format.RGB_INTEGER);
            try {
                return new Color(Integer.parseInt(matcher.group(1)), Integer.parseInt(matcher.group(2)), Integer.parseInt(matcher.group(3)));
            }
            catch (NumberFormatException numberFormatException) {
                ParseException parseException = new ParseException(string, 0);
                parseException.initCause(numberFormatException);
                throw parseException;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                ParseException parseException = new ParseException(string, 0);
                parseException.initCause(illegalArgumentException);
                throw parseException;
            }
        }
        throw new ParseException(string, 0);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public String valueToString(Object object) throws ParseException {
        String string = null;
        if (object == null) {
            if (!this.allowsNullValue) throw new ParseException("Null value is not allowed.", 0);
            return "";
        }
        if (!(object instanceof Color)) {
            throw new ParseException("Value is not a color " + object, 0);
        }
        Color color = (Color)object;
        switch (this.outputFormat) {
            case RGB_HEX: {
                string = "000000" + Integer.toHexString(color.getRGB() & 0xFFFFFF);
                return "#" + string.substring(string.length() - 6);
            }
            case RGB_INTEGER: {
                return color.getRed() + "," + color.getGreen() + "," + color.getBlue();
            }
        }
        return string;
    }

    public static JFormattedTextField.AbstractFormatterFactory createFormatterFactory() {
        return ColorFormatter.createFormatterFactory(Format.RGB_INTEGER, true, true);
    }

    public static JFormattedTextField.AbstractFormatterFactory createFormatterFactory(Format format, boolean bl, boolean bl2) {
        return new DefaultFormatterFactory(new ColorFormatter(format, bl, bl2));
    }

    public static enum Format {
        RGB_HEX,
        RGB_INTEGER;

    }
}

