/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragGestureRecognizer;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceContext;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.TransferHandler;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import org.jhotdraw.draw.CompositeFigureEvent;
import org.jhotdraw.draw.CompositeFigureListener;
import org.jhotdraw.draw.Drawing;
import org.jhotdraw.draw.DrawingView;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.draw.InputFormat;
import org.jhotdraw.draw.OutputFormat;
import org.jhotdraw.gui.Worker;
import org.jhotdraw.gui.datatransfer.CompositeTransferable;
import org.jhotdraw.util.ResourceBundleUtil;
import org.jhotdraw.util.ReversedList;

public class DefaultDrawingViewTransferHandler
extends TransferHandler {
    private static final boolean DEBUG = false;
    private HashSet<Figure> exportedFigures;

    @Override
    public boolean importData(JComponent jComponent, Transferable transferable) {
        return this.importData(jComponent, transferable, new HashSet<Figure>(), null);
    }

    protected boolean importData(final JComponent jComponent, Transferable transferable, final HashSet<Figure> hashSet, final Point point) {
        boolean bl;
        if (jComponent instanceof DrawingView) {
            final DrawingView drawingView = (DrawingView)((Object)jComponent);
            final Drawing drawing = drawingView.getDrawing();
            if (drawing.getInputFormats() == null || drawing.getInputFormats().size() == 0) {
                bl = false;
            } else {
                bl = false;
                try {
                    block17: {
                        DataFlavor[] dataFlavorArray = transferable.getTransferDataFlavors();
                        if (System.getProperty("os.name").toLowerCase().startsWith("mac")) {
                            for (InputFormat inputFormat : drawing.getInputFormats()) {
                                for (DataFlavor dataFlavor : dataFlavorArray) {
                                    if (!inputFormat.isDataFlavorSupported(dataFlavor)) continue;
                                    LinkedList<Figure> linkedList = new LinkedList<Figure>(drawing.getChildren());
                                    try {
                                        inputFormat.read(transferable, drawing, false);
                                        final LinkedList<Figure> linkedList2 = new LinkedList<Figure>(drawing.getChildren());
                                        linkedList2.removeAll(linkedList);
                                        drawingView.clearSelection();
                                        drawingView.addToSelection(linkedList2);
                                        hashSet.addAll(linkedList2);
                                        this.moveToDropPoint(jComponent, hashSet, point);
                                        drawing.fireUndoableEditHappened(new AbstractUndoableEdit(){

                                            @Override
                                            public String getPresentationName() {
                                                ResourceBundleUtil resourceBundleUtil = ResourceBundleUtil.getBundle("org.jhotdraw.draw.Labels");
                                                return resourceBundleUtil.getString("edit.paste.text");
                                            }

                                            @Override
                                            public void undo() throws CannotUndoException {
                                                super.undo();
                                                drawing.removeAll(linkedList2);
                                            }

                                            @Override
                                            public void redo() throws CannotRedoException {
                                                super.redo();
                                                drawing.addAll(linkedList2);
                                            }
                                        });
                                        bl = true;
                                        break block17;
                                    }
                                    catch (IOException iOException) {
                                        // empty catch block
                                    }
                                }
                            }
                        } else {
                            for (DataFlavor dataFlavor : dataFlavorArray) {
                                for (InputFormat inputFormat : drawing.getInputFormats()) {
                                    if (!inputFormat.isDataFlavorSupported(dataFlavor)) continue;
                                    LinkedList<Figure> linkedList = new LinkedList<Figure>(drawing.getChildren());
                                    try {
                                        inputFormat.read(transferable, drawing, false);
                                        final LinkedList<Figure> linkedList3 = new LinkedList<Figure>(drawing.getChildren());
                                        linkedList3.removeAll(linkedList);
                                        drawingView.clearSelection();
                                        drawingView.addToSelection(linkedList3);
                                        hashSet.addAll(linkedList3);
                                        this.moveToDropPoint(jComponent, hashSet, point);
                                        drawing.fireUndoableEditHappened(new AbstractUndoableEdit(){

                                            @Override
                                            public String getPresentationName() {
                                                ResourceBundleUtil resourceBundleUtil = ResourceBundleUtil.getBundle("org.jhotdraw.draw.Labels");
                                                return resourceBundleUtil.getString("edit.paste.text");
                                            }

                                            @Override
                                            public void undo() throws CannotUndoException {
                                                super.undo();
                                                drawing.removeAll(linkedList3);
                                            }

                                            @Override
                                            public void redo() throws CannotRedoException {
                                                super.redo();
                                                drawing.addAll(linkedList3);
                                            }
                                        });
                                        bl = true;
                                        break block17;
                                    }
                                    catch (IOException iOException) {
                                    }
                                }
                            }
                        }
                    }
                    if (!bl && transferable.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                        final List list = (List)transferable.getTransferData(DataFlavor.javaFileListFlavor);
                        bl = true;
                        final LinkedList<Figure> linkedList = new LinkedList<Figure>(drawing.getChildren());
                        drawingView.getEditor().setEnabled(false);
                        new Worker<LinkedList<Figure>>(){

                            @Override
                            public LinkedList<Figure> construct() throws Exception {
                                for (File file : list) {
                                    for (InputFormat inputFormat : drawing.getInputFormats()) {
                                        if (!file.isFile() || !inputFormat.getFileFilter().accept(file)) continue;
                                        inputFormat.read(file, drawing, false);
                                    }
                                }
                                return new LinkedList<Figure>(drawing.getChildren());
                            }

                            @Override
                            public void failed(Throwable throwable) {
                                throwable.printStackTrace();
                            }

                            @Override
                            public void done(final LinkedList<Figure> linkedList2) {
                                linkedList2.removeAll(linkedList);
                                if (linkedList2.size() > 0) {
                                    drawingView.clearSelection();
                                    drawingView.addToSelection(linkedList2);
                                    hashSet.addAll(linkedList2);
                                    DefaultDrawingViewTransferHandler.this.moveToDropPoint(jComponent, hashSet, point);
                                    drawing.fireUndoableEditHappened(new AbstractUndoableEdit(){

                                        @Override
                                        public String getPresentationName() {
                                            ResourceBundleUtil resourceBundleUtil = ResourceBundleUtil.getBundle("org.jhotdraw.draw.Labels");
                                            return resourceBundleUtil.getString("edit.paste.text");
                                        }

                                        @Override
                                        public void undo() throws CannotUndoException {
                                            super.undo();
                                            drawing.removeAll(linkedList2);
                                        }

                                        @Override
                                        public void redo() throws CannotRedoException {
                                            super.redo();
                                            drawing.addAll(linkedList2);
                                        }
                                    });
                                }
                            }

                            @Override
                            public void finished() {
                                drawingView.getEditor().setEnabled(true);
                            }
                        }.start();
                    }
                }
                catch (Throwable throwable) {}
            }
        } else {
            bl = super.importData(jComponent, transferable);
        }
        return bl;
    }

    protected void moveToDropPoint(JComponent jComponent, HashSet<Figure> hashSet, Point point) {
        if (point != null) {
            DrawingView drawingView = (DrawingView)((Object)jComponent);
            Point2D.Double double_ = drawingView.viewToDrawing(point);
            Rectangle2D.Double double_2 = null;
            for (Figure object : hashSet) {
                if (double_2 == null) {
                    double_2 = object.getDrawingArea();
                    continue;
                }
                double_2.add(object.getDrawingArea());
            }
            if (double_2 != null) {
                AffineTransform affineTransform = new AffineTransform();
                affineTransform.translate(-double_2.x, -double_2.y);
                affineTransform.translate(double_.x, double_.y);
                affineTransform.translate(double_2.width / -2.0, double_2.height / -2.0);
                for (Figure figure : hashSet) {
                    figure.willChange();
                    figure.transform(affineTransform);
                    figure.changed();
                }
            }
        }
    }

    @Override
    public int getSourceActions(JComponent jComponent) {
        DrawingView drawingView;
        int n = jComponent instanceof DrawingView ? ((drawingView = (DrawingView)((Object)jComponent)).getDrawing().getOutputFormats().size() > 0 && drawingView.getSelectionCount() > 0 ? 3 : 0) : super.getSourceActions(jComponent);
        return n;
    }

    @Override
    protected Transferable createTransferable(JComponent jComponent) {
        Transferable transferable;
        if (jComponent instanceof DrawingView) {
            DrawingView drawingView = (DrawingView)((Object)jComponent);
            transferable = this.createTransferable(drawingView, drawingView.getSelectedFigures());
        } else {
            transferable = super.createTransferable(jComponent);
        }
        return transferable;
    }

    protected Transferable createTransferable(DrawingView drawingView, Set<Figure> set) {
        CompositeTransferable compositeTransferable;
        Drawing drawing = drawingView.getDrawing();
        this.exportedFigures = null;
        if (drawing.getOutputFormats() == null || drawing.getOutputFormats().size() == 0) {
            compositeTransferable = null;
        } else {
            List<Figure> list = drawing.sort(set);
            if (list.size() > 0) {
                try {
                    CompositeTransferable compositeTransferable2 = new CompositeTransferable();
                    for (OutputFormat outputFormat : drawing.getOutputFormats()) {
                        Transferable transferable = outputFormat.createTransferable(drawing, list, drawingView.getScaleFactor());
                        if (compositeTransferable2.isDataFlavorSupported(transferable.getTransferDataFlavors()[0])) continue;
                        compositeTransferable2.add(transferable);
                    }
                    this.exportedFigures = new HashSet<Figure>(set);
                    compositeTransferable = compositeTransferable2;
                }
                catch (IOException iOException) {
                    compositeTransferable = null;
                }
            } else {
                compositeTransferable = null;
            }
        }
        return compositeTransferable;
    }

    @Override
    protected void exportDone(JComponent jComponent, Transferable transferable, int n) {
        if (jComponent instanceof DrawingView) {
            final DrawingView drawingView = (DrawingView)((Object)jComponent);
            final Drawing drawing = drawingView.getDrawing();
            if (n == 2) {
                final LinkedList linkedList = new LinkedList();
                final LinkedList linkedList2 = this.exportedFigures == null ? new LinkedList() : new LinkedList<Figure>(this.exportedFigures);
                for (Figure figure : linkedList2) {
                    if (figure.isRemovable()) continue;
                    jComponent.getToolkit().beep();
                    return;
                }
                CompositeFigureListener compositeFigureListener = new CompositeFigureListener(){

                    public void areaInvalidated(CompositeFigureEvent compositeFigureEvent) {
                    }

                    @Override
                    public void figureAdded(CompositeFigureEvent compositeFigureEvent) {
                    }

                    @Override
                    public void figureRemoved(CompositeFigureEvent compositeFigureEvent) {
                        linkedList.addFirst(compositeFigureEvent);
                    }
                };
                drawing.addCompositeFigureListener(compositeFigureListener);
                drawing.removeAll(linkedList2);
                drawing.removeCompositeFigureListener(compositeFigureListener);
                drawing.removeAll(linkedList2);
                drawing.fireUndoableEditHappened(new AbstractUndoableEdit(){

                    @Override
                    public String getPresentationName() {
                        ResourceBundleUtil resourceBundleUtil = ResourceBundleUtil.getBundle("org.jhotdraw.draw.Labels");
                        return resourceBundleUtil.getString("edit.delete.text");
                    }

                    @Override
                    public void undo() throws CannotUndoException {
                        super.undo();
                        drawingView.clearSelection();
                        for (CompositeFigureEvent compositeFigureEvent : linkedList) {
                            drawing.add(compositeFigureEvent.getIndex(), compositeFigureEvent.getChildFigure());
                        }
                        drawingView.addToSelection(linkedList2);
                    }

                    @Override
                    public void redo() throws CannotRedoException {
                        super.redo();
                        for (CompositeFigureEvent compositeFigureEvent : new ReversedList(linkedList)) {
                            drawing.remove(compositeFigureEvent.getChildFigure());
                        }
                    }
                });
            }
        } else {
            super.exportDone(jComponent, transferable, n);
        }
        this.exportedFigures = null;
    }

    @Override
    public void exportAsDrag(JComponent jComponent, InputEvent inputEvent, int n) {
        if (jComponent instanceof DrawingView) {
            DrawingView drawingView = (DrawingView)((Object)jComponent);
            HashSet<Figure> hashSet = new HashSet<Figure>();
            MouseEvent mouseEvent = (MouseEvent)inputEvent;
            Figure figure = drawingView.findFigure(mouseEvent.getPoint());
            if (drawingView.getSelectedFigures().contains(figure)) {
                hashSet.addAll(drawingView.getSelectedFigures());
            } else {
                hashSet.add(figure);
            }
            Rectangle2D.Double double_ = null;
            for (Figure cloneable2 : hashSet) {
                if (double_ == null) {
                    double_ = cloneable2.getDrawingArea();
                    continue;
                }
                double_.add(cloneable2.getDrawingArea());
            }
            Rectangle rectangle = drawingView.drawingToView(double_);
            Point point = mouseEvent.getPoint();
            point.x = rectangle.x - point.x;
            point.y = rectangle.y - point.y;
            int n2 = this.getSourceActions(jComponent);
            SwingDragGestureRecognizer swingDragGestureRecognizer = new SwingDragGestureRecognizer(new DragHandler(this.createTransferable(drawingView, hashSet), point));
            swingDragGestureRecognizer.gestured(jComponent, mouseEvent, n2, n);
        } else {
            super.exportAsDrag(jComponent, inputEvent, n);
        }
    }

    @Override
    public Icon getVisualRepresentation(Transferable transferable) {
        Image image = null;
        try {
            image = (Image)transferable.getTransferData(DataFlavor.imageFlavor);
        }
        catch (IOException iOException) {
        }
        catch (UnsupportedFlavorException unsupportedFlavorException) {
            // empty catch block
        }
        return image == null ? null : new ImageIcon(image);
    }

    @Override
    public boolean canImport(JComponent jComponent, DataFlavor[] dataFlavorArray) {
        boolean bl;
        block4: {
            if (jComponent instanceof DrawingView) {
                DrawingView drawingView = (DrawingView)((Object)jComponent);
                Drawing drawing = drawingView.getDrawing();
                bl = false;
                for (InputFormat inputFormat : drawing.getInputFormats()) {
                    for (DataFlavor dataFlavor : dataFlavorArray) {
                        if (!dataFlavor.isFlavorJavaFileListType() && !inputFormat.isDataFlavorSupported(dataFlavor)) continue;
                        bl = true;
                        break block4;
                    }
                }
            } else {
                bl = super.canImport(jComponent, dataFlavorArray);
            }
        }
        return bl;
    }

    private void getDrawing() {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    private static class DragHandler
    implements DragGestureListener,
    DragSourceListener {
        private boolean scrolls;
        private Transferable transferable;
        private Point imageOffset;

        public DragHandler(Transferable transferable, Point point) {
            this.transferable = transferable;
            this.imageOffset = point;
        }

        @Override
        public void dragGestureRecognized(DragGestureEvent dragGestureEvent) {
            JComponent jComponent = (JComponent)dragGestureEvent.getComponent();
            DefaultDrawingViewTransferHandler defaultDrawingViewTransferHandler = (DefaultDrawingViewTransferHandler)jComponent.getTransferHandler();
            Transferable transferable = this.transferable;
            if (transferable != null) {
                this.scrolls = jComponent.getAutoscrolls();
                jComponent.setAutoscrolls(false);
                try {
                    Image image;
                    Icon icon = defaultDrawingViewTransferHandler.getVisualRepresentation(transferable);
                    if (icon instanceof ImageIcon) {
                        image = ((ImageIcon)icon).getImage();
                    } else {
                        image = new BufferedImage(icon.getIconWidth(), icon.getIconHeight(), 2);
                        Graphics2D graphics2D = ((BufferedImage)image).createGraphics();
                        icon.paintIcon(jComponent, graphics2D, 0, 0);
                        graphics2D.dispose();
                    }
                    dragGestureEvent.startDrag(null, image, this.imageOffset, transferable, this);
                    return;
                }
                catch (RuntimeException runtimeException) {
                    jComponent.setAutoscrolls(this.scrolls);
                }
            }
            defaultDrawingViewTransferHandler.exportDone(jComponent, transferable, 0);
        }

        @Override
        public void dragEnter(DragSourceDragEvent dragSourceDragEvent) {
        }

        @Override
        public void dragOver(DragSourceDragEvent dragSourceDragEvent) {
        }

        @Override
        public void dragExit(DragSourceEvent dragSourceEvent) {
        }

        @Override
        public void dragDropEnd(DragSourceDropEvent dragSourceDropEvent) {
            DragSourceContext dragSourceContext = dragSourceDropEvent.getDragSourceContext();
            JComponent jComponent = (JComponent)dragSourceContext.getComponent();
            DefaultDrawingViewTransferHandler defaultDrawingViewTransferHandler = (DefaultDrawingViewTransferHandler)jComponent.getTransferHandler();
            if (dragSourceDropEvent.getDropSuccess()) {
                defaultDrawingViewTransferHandler.exportDone(jComponent, dragSourceContext.getTransferable(), dragSourceDropEvent.getDropAction());
            } else {
                defaultDrawingViewTransferHandler.exportDone(jComponent, dragSourceContext.getTransferable(), 0);
            }
            jComponent.setAutoscrolls(this.scrolls);
        }

        @Override
        public void dropActionChanged(DragSourceDragEvent dragSourceDragEvent) {
        }
    }

    private static class SwingDragGestureRecognizer
    extends DragGestureRecognizer {
        SwingDragGestureRecognizer(DragGestureListener dragGestureListener) {
            super(DragSource.getDefaultDragSource(), null, 0, dragGestureListener);
        }

        void gestured(JComponent jComponent, MouseEvent mouseEvent, int n, int n2) {
            this.setComponent(jComponent);
            this.setSourceActions(n);
            this.appendEvent(mouseEvent);
            this.fireDragGestureRecognized(n2, mouseEvent.getPoint());
        }

        @Override
        protected void registerListeners() {
        }

        @Override
        protected void unregisterListeners() {
        }
    }
}

