.de IQ
.  br
.  ns
.  IP "\\$1"
..
.IP "\fB\-v\fR[\fIspec\fR]
.IQ "\fB\-\-verbose=\fR[\fIspec\fR]
.
Sets logging levels.  Without any \fIspec\fR, sets the log level for
every module and destination to \fBdbg\fR.  Otherwise, \fIspec\fR is a
list of words separated by spaces or commas or colons, up to one from
each category below:
.
.RS
.IP \(bu
A valid module name, as displayed by the \fBvlog/list\fR command on
\fBovs\-appctl\fR(8), limits the log level change to the specified
module.
.
.IP \(bu
\fBsyslog\fR, \fBconsole\fR, or \fBfile\fR, to limit the log level
change to only to the system log, to the console, or to a file,
respectively.  (If \fB\-\-detach\fR is specified, \fB\*(PN\fR closes
its standard file descriptors, so logging to the console will have no
effect.)
.IP
On Windows platform, \fBsyslog\fR is accepted as a word and is only
useful along with the \fB\-\-syslog\-target\fR option (the word has no
effect otherwise).
.
.IP \(bu
\fBoff\fR, \fBemer\fR, \fBerr\fR, \fBwarn\fR, \fBinfo\fR, or
\fBdbg\fR, to control the log level.  Messages of the given severity
or higher will be logged, and messages of lower severity will be
filtered out.  \fBoff\fR filters out all messages.  See
\fBovs\-appctl\fR(8) for a definition of each log level.
.RE
.
.IP
Case is not significant within \fIspec\fR.
.IP
Regardless of the log levels set for \fBfile\fR, logging to a file
will not take place unless \fB\-\-log\-file\fR is also specified (see
below).
.IP
For compatibility with older versions of OVS, \fBany\fR is accepted as
a word but has no effect.
.
.IP "\fB\-v\fR"
.IQ "\fB\-\-verbose\fR"
Sets the maximum logging verbosity level, equivalent to
\fB\-\-verbose=dbg\fR.
.
.IP "\fB\-vPATTERN:\fIdestination\fB:\fIpattern\fR"
.IQ "\fB\-\-verbose=PATTERN:\fIdestination\fB:\fIpattern\fR"
Sets the log pattern for \fIdestination\fR to \fIpattern\fR.  Refer to
\fBovs\-appctl\fR(8) for a description of the valid syntax for \fIpattern\fR.
.
.IP "\fB\-vFACILITY:\fIfacility\fR"
.IQ "\fB\-\-verbose=FACILITY:\fIfacility\fR"
Sets the RFC5424 facility of the log message. \fIfacility\fR can be one of
\fBkern\fR, \fBuser\fR, \fBmail\fR, \fBdaemon\fR, \fBauth\fR, \fBsyslog\fR,
\fBlpr\fR, \fBnews\fR, \fBuucp\fR, \fBclock\fR, \fBftp\fR, \fBntp\fR,
\fBaudit\fR, \fBalert\fR, \fBclock2\fR, \fBlocal0\fR, \fBlocal1\fR,
\fBlocal2\fR, \fBlocal3\fR, \fBlocal4\fR, \fBlocal5\fR, \fBlocal6\fR or
\fBlocal7\fR. If this option is not specified, \fBdaemon\fR is used as
the default for the local system syslog and \fBlocal0\fR is used while sending
a message to the target provided via the \fB\-\-syslog\-target\fR option.
.
.TP
\fB\-\-log\-file\fR[\fB=\fIfile\fR]
Enables logging to a file.  If \fIfile\fR is specified, then it is
used as the exact name for the log file.  The default log file name
used if \fIfile\fR is omitted is \fB@LOGDIR@/\*(PN.log\fR.
.
.IP "\fB\-\-syslog\-target=\fIhost\fB:\fIport\fR"
Send syslog messages to UDP \fIport\fR on \fIhost\fR, in addition to
the system syslog.  The \fIhost\fR must be a numerical IP address, not
a hostname.
.
.IP "\fB\-\-syslog\-method=\fImethod\fR"
Specify \fImethod\fR how syslog messages should be sent to syslog daemon.
Following forms are supported:
.RS
.IP \(bu
\fBlibc\fR, use libc \fBsyslog()\fR function.  This is the default behavior.
Downside of using this options is that libc adds fixed prefix to every
message before it is actually sent to the syslog daemon over \fB/dev/log\fR
UNIX domain socket.
.IP \(bu
\fBunix:\fIfile\fR\fR, use UNIX domain socket directly.  It is possible to
specify arbitrary message format with this option.  However,
\fBrsyslogd 8.9\fR and older versions use hard coded parser function anyway
that limits UNIX domain socket use.  If you want to use arbitrary message
format with older \fBrsyslogd\fR versions, then use UDP socket to localhost
IP address instead.
.IP \(bu
\fBudp:\fIip\fR:\fIport\fR\fR, use UDP socket.  With this method it is
possible to use arbitrary message format also with older \fBrsyslogd\fR.
When sending syslog messages over UDP socket extra precaution needs to
be taken into account, for example, syslog daemon needs to be configured
to listen on the specified UDP port, accidental iptables rules could be
interfering with local syslog traffic and there are some security
considerations that apply to UDP sockets, but do not apply to UNIX domain
sockets.
.RE
