// GENERATED FILE - DO NOT EDIT.
// Generated by generate_entry_points.py using data from gl.xml.
//
// Copyright 2020 The ANGLE Project Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
//
// entry_points_gl_4_1_autogen.cpp:
//   Defines the GL 4.1 entry points.

#include "libGL/entry_points_gl_4_1_autogen.h"

#include "libANGLE/Context.h"
#include "libANGLE/Context.inl.h"
#include "libANGLE/entry_points_utils.h"
#include "libANGLE/gl_enum_utils.h"
#include "libANGLE/validationEGL.h"
#include "libANGLE/validationES.h"
#include "libANGLE/validationES1.h"
#include "libANGLE/validationES2.h"
#include "libANGLE/validationES3.h"
#include "libANGLE/validationES31.h"
#include "libANGLE/validationES32.h"
#include "libANGLE/validationESEXT.h"
#include "libANGLE/validationGL41_autogen.h"
#include "libGLESv2/global_state.h"

namespace gl
{
void GL_APIENTRY ActiveShaderProgram(GLuint pipeline, GLuint program)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::ActiveShaderProgram, "glActiveShaderProgram",
          "context = %d, pipeline = %u, program = %u", CID(context), pipeline, program);

    if (context)
    {
        ProgramPipelineID pipelinePacked                      = FromGL<ProgramPipelineID>(pipeline);
        ShaderProgramID programPacked                         = FromGL<ShaderProgramID>(program);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateActiveShaderProgram(context, pipelinePacked, programPacked));
        if (isCallValid)
        {
            context->activeShaderProgram(pipelinePacked, programPacked);
        }
        ANGLE_CAPTURE(ActiveShaderProgram, isCallValid, context, pipelinePacked, programPacked);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY BindProgramPipeline(GLuint pipeline)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::BindProgramPipeline, "glBindProgramPipeline",
          "context = %d, pipeline = %u", CID(context), pipeline);

    if (context)
    {
        ProgramPipelineID pipelinePacked                      = FromGL<ProgramPipelineID>(pipeline);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateBindProgramPipeline(context, pipelinePacked));
        if (isCallValid)
        {
            context->bindProgramPipeline(pipelinePacked);
        }
        ANGLE_CAPTURE(BindProgramPipeline, isCallValid, context, pipelinePacked);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY ClearDepthf(GLfloat d)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::ClearDepthf, "glClearDepthf", "context = %d, d = %f",
          CID(context), d);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid = (context->skipValidation() || ValidateClearDepthf(context, d));
        if (isCallValid)
        {
            context->clearDepthf(d);
        }
        ANGLE_CAPTURE(ClearDepthf, isCallValid, context, d);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

GLuint GL_APIENTRY CreateShaderProgramv(GLenum type, GLsizei count, const GLchar *const *strings)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::CreateShaderProgramv, "glCreateShaderProgramv",
          "context = %d, type = %s, count = %d, strings = 0x%016" PRIxPTR "", CID(context),
          GLenumToString(GLenumGroup::ShaderType, type), count, (uintptr_t)strings);

    GLuint returnValue;
    if (context)
    {
        ShaderType typePacked                                 = FromGL<ShaderType>(type);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateCreateShaderProgramv(context, typePacked, count, strings));
        if (isCallValid)
        {
            returnValue = context->createShaderProgramv(typePacked, count, strings);
        }
        else
        {
            returnValue = GetDefaultReturnValue<EntryPoint::CreateShaderProgramv, GLuint>();
        }
        ANGLE_CAPTURE(CreateShaderProgramv, isCallValid, context, typePacked, count, strings,
                      returnValue);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
        returnValue = GetDefaultReturnValue<EntryPoint::CreateShaderProgramv, GLuint>();
    }
    return returnValue;
}

void GL_APIENTRY DeleteProgramPipelines(GLsizei n, const GLuint *pipelines)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::DeleteProgramPipelines, "glDeleteProgramPipelines",
          "context = %d, n = %d, pipelines = 0x%016" PRIxPTR "", CID(context), n,
          (uintptr_t)pipelines);

    if (context)
    {
        const ProgramPipelineID *pipelinesPacked = FromGL<const ProgramPipelineID *>(pipelines);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateDeleteProgramPipelines(context, n, pipelinesPacked));
        if (isCallValid)
        {
            context->deleteProgramPipelines(n, pipelinesPacked);
        }
        ANGLE_CAPTURE(DeleteProgramPipelines, isCallValid, context, n, pipelinesPacked);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY DepthRangeArrayv(GLuint first, GLsizei count, const GLdouble *v)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::DepthRangeArrayv, "glDepthRangeArrayv",
          "context = %d, first = %u, count = %d, v = 0x%016" PRIxPTR "", CID(context), first, count,
          (uintptr_t)v);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateDepthRangeArrayv(context, first, count, v));
        if (isCallValid)
        {
            context->depthRangeArrayv(first, count, v);
        }
        ANGLE_CAPTURE(DepthRangeArrayv, isCallValid, context, first, count, v);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY DepthRangeIndexed(GLuint index, GLdouble n, GLdouble f)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::DepthRangeIndexed, "glDepthRangeIndexed",
          "context = %d, index = %u, n = %f, f = %f", CID(context), index, n, f);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateDepthRangeIndexed(context, index, n, f));
        if (isCallValid)
        {
            context->depthRangeIndexed(index, n, f);
        }
        ANGLE_CAPTURE(DepthRangeIndexed, isCallValid, context, index, n, f);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY DepthRangef(GLfloat n, GLfloat f)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::DepthRangef, "glDepthRangef", "context = %d, n = %f, f = %f",
          CID(context), n, f);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid = (context->skipValidation() || ValidateDepthRangef(context, n, f));
        if (isCallValid)
        {
            context->depthRangef(n, f);
        }
        ANGLE_CAPTURE(DepthRangef, isCallValid, context, n, f);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GenProgramPipelines(GLsizei n, GLuint *pipelines)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::GenProgramPipelines, "glGenProgramPipelines",
          "context = %d, n = %d, pipelines = 0x%016" PRIxPTR "", CID(context), n,
          (uintptr_t)pipelines);

    if (context)
    {
        ProgramPipelineID *pipelinesPacked = FromGL<ProgramPipelineID *>(pipelines);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateGenProgramPipelines(context, n, pipelinesPacked));
        if (isCallValid)
        {
            context->genProgramPipelines(n, pipelinesPacked);
        }
        ANGLE_CAPTURE(GenProgramPipelines, isCallValid, context, n, pipelinesPacked);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GetDoublei_v(GLenum target, GLuint index, GLdouble *data)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::GetDoublei_v, "glGetDoublei_v",
          "context = %d, target = %s, index = %u, data = 0x%016" PRIxPTR "", CID(context),
          GLenumToString(GLenumGroup::TypeEnum, target), index, (uintptr_t)data);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateGetDoublei_v(context, target, index, data));
        if (isCallValid)
        {
            context->getDoublei_v(target, index, data);
        }
        ANGLE_CAPTURE(GetDoublei_v, isCallValid, context, target, index, data);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GetFloati_v(GLenum target, GLuint index, GLfloat *data)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::GetFloati_v, "glGetFloati_v",
          "context = %d, target = %s, index = %u, data = 0x%016" PRIxPTR "", CID(context),
          GLenumToString(GLenumGroup::TypeEnum, target), index, (uintptr_t)data);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateGetFloati_v(context, target, index, data));
        if (isCallValid)
        {
            context->getFloati_v(target, index, data);
        }
        ANGLE_CAPTURE(GetFloati_v, isCallValid, context, target, index, data);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GetProgramBinary(GLuint program,
                                  GLsizei bufSize,
                                  GLsizei *length,
                                  GLenum *binaryFormat,
                                  void *binary)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::GetProgramBinary, "glGetProgramBinary",
          "context = %d, program = %u, bufSize = %d, length = 0x%016" PRIxPTR
          ", binaryFormat = 0x%016" PRIxPTR ", binary = 0x%016" PRIxPTR "",
          CID(context), program, bufSize, (uintptr_t)length, (uintptr_t)binaryFormat,
          (uintptr_t)binary);

    if (context)
    {
        ShaderProgramID programPacked                         = FromGL<ShaderProgramID>(program);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateGetProgramBinary(context, programPacked, bufSize,
                                                                   length, binaryFormat, binary));
        if (isCallValid)
        {
            context->getProgramBinary(programPacked, bufSize, length, binaryFormat, binary);
        }
        ANGLE_CAPTURE(GetProgramBinary, isCallValid, context, programPacked, bufSize, length,
                      binaryFormat, binary);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GetProgramPipelineInfoLog(GLuint pipeline,
                                           GLsizei bufSize,
                                           GLsizei *length,
                                           GLchar *infoLog)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::GetProgramPipelineInfoLog, "glGetProgramPipelineInfoLog",
          "context = %d, pipeline = %u, bufSize = %d, length = 0x%016" PRIxPTR
          ", infoLog = 0x%016" PRIxPTR "",
          CID(context), pipeline, bufSize, (uintptr_t)length, (uintptr_t)infoLog);

    if (context)
    {
        ProgramPipelineID pipelinePacked                      = FromGL<ProgramPipelineID>(pipeline);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateGetProgramPipelineInfoLog(context, pipelinePacked, bufSize, length, infoLog));
        if (isCallValid)
        {
            context->getProgramPipelineInfoLog(pipelinePacked, bufSize, length, infoLog);
        }
        ANGLE_CAPTURE(GetProgramPipelineInfoLog, isCallValid, context, pipelinePacked, bufSize,
                      length, infoLog);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GetProgramPipelineiv(GLuint pipeline, GLenum pname, GLint *params)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::GetProgramPipelineiv, "glGetProgramPipelineiv",
          "context = %d, pipeline = %u, pname = %s, params = 0x%016" PRIxPTR "", CID(context),
          pipeline, GLenumToString(GLenumGroup::PipelineParameterName, pname), (uintptr_t)params);

    if (context)
    {
        ProgramPipelineID pipelinePacked                      = FromGL<ProgramPipelineID>(pipeline);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateGetProgramPipelineiv(context, pipelinePacked, pname, params));
        if (isCallValid)
        {
            context->getProgramPipelineiv(pipelinePacked, pname, params);
        }
        ANGLE_CAPTURE(GetProgramPipelineiv, isCallValid, context, pipelinePacked, pname, params);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GetShaderPrecisionFormat(GLenum shadertype,
                                          GLenum precisiontype,
                                          GLint *range,
                                          GLint *precision)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::GetShaderPrecisionFormat, "glGetShaderPrecisionFormat",
          "context = %d, shadertype = %s, precisiontype = %s, range = 0x%016" PRIxPTR
          ", precision = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLenumGroup::ShaderType, shadertype),
          GLenumToString(GLenumGroup::PrecisionType, precisiontype), (uintptr_t)range,
          (uintptr_t)precision);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateGetShaderPrecisionFormat(context, shadertype, precisiontype,
                                                             range, precision));
        if (isCallValid)
        {
            context->getShaderPrecisionFormat(shadertype, precisiontype, range, precision);
        }
        ANGLE_CAPTURE(GetShaderPrecisionFormat, isCallValid, context, shadertype, precisiontype,
                      range, precision);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GetVertexAttribLdv(GLuint index, GLenum pname, GLdouble *params)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::GetVertexAttribLdv, "glGetVertexAttribLdv",
          "context = %d, index = %u, pname = %s, params = 0x%016" PRIxPTR "", CID(context), index,
          GLenumToString(GLenumGroup::VertexAttribEnum, pname), (uintptr_t)params);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateGetVertexAttribLdv(context, index, pname, params));
        if (isCallValid)
        {
            context->getVertexAttribLdv(index, pname, params);
        }
        ANGLE_CAPTURE(GetVertexAttribLdv, isCallValid, context, index, pname, params);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

GLboolean GL_APIENTRY IsProgramPipeline(GLuint pipeline)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::IsProgramPipeline, "glIsProgramPipeline",
          "context = %d, pipeline = %u", CID(context), pipeline);

    GLboolean returnValue;
    if (context)
    {
        ProgramPipelineID pipelinePacked                      = FromGL<ProgramPipelineID>(pipeline);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateIsProgramPipeline(context, pipelinePacked));
        if (isCallValid)
        {
            returnValue = context->isProgramPipeline(pipelinePacked);
        }
        else
        {
            returnValue = GetDefaultReturnValue<EntryPoint::IsProgramPipeline, GLboolean>();
        }
        ANGLE_CAPTURE(IsProgramPipeline, isCallValid, context, pipelinePacked, returnValue);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
        returnValue = GetDefaultReturnValue<EntryPoint::IsProgramPipeline, GLboolean>();
    }
    return returnValue;
}

void GL_APIENTRY ProgramBinary(GLuint program,
                               GLenum binaryFormat,
                               const void *binary,
                               GLsizei length)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::ProgramBinary, "glProgramBinary",
          "context = %d, program = %u, binaryFormat = %s, binary = 0x%016" PRIxPTR ", length = %d",
          CID(context), program, GLenumToString(GLenumGroup::DefaultGroup, binaryFormat),
          (uintptr_t)binary, length);

    if (context)
    {
        ShaderProgramID programPacked                         = FromGL<ShaderProgramID>(program);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateProgramBinary(context, programPacked, binaryFormat, binary, length));
        if (isCallValid)
        {
            context->programBinary(programPacked, binaryFormat, binary, length);
        }
        ANGLE_CAPTURE(ProgramBinary, isCallValid, context, programPacked, binaryFormat, binary,
                      length);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY ProgramParameteri(GLuint program, GLenum pname, GLint value)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::ProgramParameteri, "glProgramParameteri",
          "context = %d, program = %u, pname = %s, value = %d", CID(context), program,
          GLenumToString(GLenumGroup::ProgramParameterPName, pname), value);

    if (context)
    {
        ShaderProgramID programPacked                         = FromGL<ShaderProgramID>(program);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateProgramParameteri(context, programPacked, pname, value));
        if (isCallValid)
        {
            context->programParameteri(programPacked, pname, value);
        }
        ANGLE_CAPTURE(ProgramParameteri, isCallValid, context, programPacked, pname, value);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY ProgramUniform1d(GLuint program, GLint location, GLdouble v0)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::ProgramUniform1d, "glProgramUniform1d",
          "context = %d, program = %u, location = %d, v0 = %f", CID(context), program, location,
          v0);

    if (context)
    {
        ShaderProgramID programPacked                         = FromGL<ShaderProgramID>(program);
        UniformLocation locationPacked                        = FromGL<UniformLocation>(location);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateProgramUniform1d(context, programPacked, locationPacked, v0));
        if (isCallValid)
        {
            context->programUniform1d(programPacked, locationPacked, v0);
        }
        ANGLE_CAPTURE(ProgramUniform1d, isCallValid, context, programPacked, locationPacked, v0);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY ProgramUniform1dv(GLuint program,
                                   GLint location,
                                   GLsizei count,
                                   const GLdouble *value)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::ProgramUniform1dv, "glProgramUniform1dv",
          "context = %d, program = %u, location = %d, count = %d, value = 0x%016" PRIxPTR "",
          CID(context), program, location, count, (uintptr_t)value);

    if (context)
    {
        ShaderProgramID programPacked                         = FromGL<ShaderProgramID>(program);
        UniformLocation locationPacked                        = FromGL<UniformLocation>(location);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateProgramUniform1dv(context, programPacked, locationPacked, count, value));
        if (isCallValid)
        {
            context->programUniform1dv(programPacked, locationPacked, count, value);
        }
        ANGLE_CAPTURE(ProgramUniform1dv, isCallValid, context, programPacked, locationPacked, count,
                      value);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY ProgramUniform1f(GLuint program, GLint location, GLfloat v0)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::ProgramUniform1f, "glProgramUniform1f",
          "context = %d, program = %u, location = %d, v0 = %f", CID(context), program, location,
          v0);

    if (context)
    {
        ShaderProgramID programPacked                         = FromGL<ShaderProgramID>(program);
        UniformLocation locationPacked                        = FromGL<UniformLocation>(location);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateProgramUniform1f(context, programPacked, locationPacked, v0));
        if (isCallValid)
        {
            context->programUniform1f(programPacked, locationPacked, v0);
        }
        ANGLE_CAPTURE(ProgramUniform1f, isCallValid, context, programPacked, locationPacked, v0);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY ProgramUniform1fv(GLuint program,
                                   GLint location,
                                   GLsizei count,
                                   const GLfloat *value)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::ProgramUniform1fv, "glProgramUniform1fv",
          "context = %d, program = %u, location = %d, count = %d, value = 0x%016" PRIxPTR "",
          CID(context), program, location, count, (uintptr_t)value);

    if (context)
    {
        ShaderProgramID programPacked                         = FromGL<ShaderProgramID>(program);
        UniformLocation locationPacked                        = FromGL<UniformLocation>(location);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateProgramUniform1fv(context, programPacked, locationPacked, count, value));
        if (isCallValid)
        {
            context->programUniform1fv(programPacked, locationPacked, count, value);
        }
        ANGLE_CAPTURE(ProgramUniform1fv, isCallValid, context, programPacked, locationPacked, count,
                      value);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY ProgramUniform1i(GLuint program, GLint location, GLint v0)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::ProgramUniform1i, "glProgramUniform1i",
          "context = %d, program = %u, location = %d, v0 = %d", CID(context), program, location,
          v0);

    if (context)
    {
        ShaderProgramID programPacked                         = FromGL<ShaderProgramID>(program);
        UniformLocation locationPacked                        = FromGL<UniformLocation>(location);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateProgramUniform1i(context, programPacked, locationPacked, v0));
        if (isCallValid)
        {
            context->programUniform1i(programPacked, locationPacked, v0);
        }
        ANGLE_CAPTURE(ProgramUniform1i, isCallValid, context, programPacked, locationPacked, v0);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY ProgramUniform1iv(GLuint program,
                                   GLint location,
                                   GLsizei count,
                                   const GLint *value)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::ProgramUniform1iv, "glProgramUniform1iv",
          "context = %d, program = %u, location = %d, count = %d, value = 0x%016" PRIxPTR "",
          CID(context), program, location, count, (uintptr_t)value);

    if (context)
    {
        ShaderProgramID programPacked                         = FromGL<ShaderProgramID>(program);
        UniformLocation locationPacked                        = FromGL<UniformLocation>(location);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateProgramUniform1iv(context, programPacked, locationPacked, count, value));
        if (isCallValid)
        {
            context->programUniform1iv(programPacked, locationPacked, count, value);
        }
        ANGLE_CAPTURE(ProgramUniform1iv, isCallValid, context, programPacked, locationPacked, count,
                      value);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY ProgramUniform1ui(GLuint program, GLint location, GLuint v0)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::ProgramUniform1ui, "glProgramUniform1ui",
          "context = %d, program = %u, location = %d, v0 = %u", CID(context), program, location,
          v0);

    if (context)
    {
        ShaderProgramID programPacked                         = FromGL<ShaderProgramID>(program);
        UniformLocation locationPacked                        = FromGL<UniformLocation>(location);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateProgramUniform1ui(context, programPacked, locationPacked, v0));
        if (isCallValid)
        {
            context->programUniform1ui(programPacked, locationPacked, v0);
        }
        ANGLE_CAPTURE(ProgramUniform1ui, isCallValid, context, programPacked, locationPacked, v0);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY ProgramUniform1uiv(GLuint program,
                                    GLint location,
                                    GLsizei count,
                                    const GLuint *value)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::ProgramUniform1uiv, "glProgramUniform1uiv",
          "context = %d, program = %u, location = %d, count = %d, value = 0x%016" PRIxPTR "",
          CID(context), program, location, count, (uintptr_t)value);

    if (context)
    {
        ShaderProgramID programPacked                         = FromGL<ShaderProgramID>(program);
        UniformLocation locationPacked                        = FromGL<UniformLocation>(location);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateProgramUniform1uiv(context, programPacked, locationPacked, count, value));
        if (isCallValid)
        {
            context->programUniform1uiv(programPacked, locationPacked, count, value);
        }
        ANGLE_CAPTURE(ProgramUniform1uiv, isCallValid, context, programPacked, locationPacked,
                      count, value);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY ProgramUniform2d(GLuint program, GLint location, GLdouble v0, GLdouble v1)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::ProgramUniform2d, "glProgramUniform2d",
          "context = %d, program = %u, location = %d, v0 = %f, v1 = %f", CID(context), program,
          location, v0, v1);

    if (context)
    {
        ShaderProgramID programPacked                         = FromGL<ShaderProgramID>(program);
        UniformLocation locationPacked                        = FromGL<UniformLocation>(location);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateProgramUniform2d(context, programPacked, locationPacked, v0, v1));
        if (isCallValid)
        {
            context->programUniform2d(programPacked, locationPacked, v0, v1);
        }
        ANGLE_CAPTURE(ProgramUniform2d, isCallValid, context, programPacked, locationPacked, v0,
                      v1);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY ProgramUniform2dv(GLuint program,
                                   GLint location,
                                   GLsizei count,
                                   const GLdouble *value)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::ProgramUniform2dv, "glProgramUniform2dv",
          "context = %d, program = %u, location = %d, count = %d, value = 0x%016" PRIxPTR "",
          CID(context), program, location, count, (uintptr_t)value);

    if (context)
    {
        ShaderProgramID programPacked                         = FromGL<ShaderProgramID>(program);
        UniformLocation locationPacked                        = FromGL<UniformLocation>(location);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateProgramUniform2dv(context, programPacked, locationPacked, count, value));
        if (isCallValid)
        {
            context->programUniform2dv(programPacked, locationPacked, count, value);
        }
        ANGLE_CAPTURE(ProgramUniform2dv, isCallValid, context, programPacked, locationPacked, count,
                      value);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY ProgramUniform2f(GLuint program, GLint location, GLfloat v0, GLfloat v1)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::ProgramUniform2f, "glProgramUniform2f",
          "context = %d, program = %u, location = %d, v0 = %f, v1 = %f", CID(context), program,
          location, v0, v1);

    if (context)
    {
        ShaderProgramID programPacked                         = FromGL<ShaderProgramID>(program);
        UniformLocation locationPacked                        = FromGL<UniformLocation>(location);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateProgramUniform2f(context, programPacked, locationPacked, v0, v1));
        if (isCallValid)
        {
            context->programUniform2f(programPacked, locationPacked, v0, v1);
        }
        ANGLE_CAPTURE(ProgramUniform2f, isCallValid, context, programPacked, locationPacked, v0,
                      v1);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY ProgramUniform2fv(GLuint program,
                                   GLint location,
                                   GLsizei count,
                                   const GLfloat *value)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::ProgramUniform2fv, "glProgramUniform2fv",
          "context = %d, program = %u, location = %d, count = %d, value = 0x%016" PRIxPTR "",
          CID(context), program, location, count, (uintptr_t)value);

    if (context)
    {
        ShaderProgramID programPacked                         = FromGL<ShaderProgramID>(program);
        UniformLocation locationPacked                        = FromGL<UniformLocation>(location);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateProgramUniform2fv(context, programPacked, locationPacked, count, value));
        if (isCallValid)
        {
            context->programUniform2fv(programPacked, locationPacked, count, value);
        }
        ANGLE_CAPTURE(ProgramUniform2fv, isCallValid, context, programPacked, locationPacked, count,
                      value);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY ProgramUniform2i(GLuint program, GLint location, GLint v0, GLint v1)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::ProgramUniform2i, "glProgramUniform2i",
          "context = %d, program = %u, location = %d, v0 = %d, v1 = %d", CID(context), program,
          location, v0, v1);

    if (context)
    {
        ShaderProgramID programPacked                         = FromGL<ShaderProgramID>(program);
        UniformLocation locationPacked                        = FromGL<UniformLocation>(location);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateProgramUniform2i(context, programPacked, locationPacked, v0, v1));
        if (isCallValid)
        {
            context->programUniform2i(programPacked, locationPacked, v0, v1);
        }
        ANGLE_CAPTURE(ProgramUniform2i, isCallValid, context, programPacked, locationPacked, v0,
                      v1);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY ProgramUniform2iv(GLuint program,
                                   GLint location,
                                   GLsizei count,
                                   const GLint *value)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::ProgramUniform2iv, "glProgramUniform2iv",
          "context = %d, program = %u, location = %d, count = %d, value = 0x%016" PRIxPTR "",
          CID(context), program, location, count, (uintptr_t)value);

    if (context)
    {
        ShaderProgramID programPacked                         = FromGL<ShaderProgramID>(program);
        UniformLocation locationPacked                        = FromGL<UniformLocation>(location);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateProgramUniform2iv(context, programPacked, locationPacked, count, value));
        if (isCallValid)
        {
            context->programUniform2iv(programPacked, locationPacked, count, value);
        }
        ANGLE_CAPTURE(ProgramUniform2iv, isCallValid, context, programPacked, locationPacked, count,
                      value);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY ProgramUniform2ui(GLuint program, GLint location, GLuint v0, GLuint v1)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::ProgramUniform2ui, "glProgramUniform2ui",
          "context = %d, program = %u, location = %d, v0 = %u, v1 = %u", CID(context), program,
          location, v0, v1);

    if (context)
    {
        ShaderProgramID programPacked                         = FromGL<ShaderProgramID>(program);
        UniformLocation locationPacked                        = FromGL<UniformLocation>(location);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateProgramUniform2ui(context, programPacked, locationPacked, v0, v1));
        if (isCallValid)
        {
            context->programUniform2ui(programPacked, locationPacked, v0, v1);
        }
        ANGLE_CAPTURE(ProgramUniform2ui, isCallValid, context, programPacked, locationPacked, v0,
                      v1);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY ProgramUniform2uiv(GLuint program,
                                    GLint location,
                                    GLsizei count,
                                    const GLuint *value)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::ProgramUniform2uiv, "glProgramUniform2uiv",
          "context = %d, program = %u, location = %d, count = %d, value = 0x%016" PRIxPTR "",
          CID(context), program, location, count, (uintptr_t)value);

    if (context)
    {
        ShaderProgramID programPacked                         = FromGL<ShaderProgramID>(program);
        UniformLocation locationPacked                        = FromGL<UniformLocation>(location);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateProgramUniform2uiv(context, programPacked, locationPacked, count, value));
        if (isCallValid)
        {
            context->programUniform2uiv(programPacked, locationPacked, count, value);
        }
        ANGLE_CAPTURE(ProgramUniform2uiv, isCallValid, context, programPacked, locationPacked,
                      count, value);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY
ProgramUniform3d(GLuint program, GLint location, GLdouble v0, GLdouble v1, GLdouble v2)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::ProgramUniform3d, "glProgramUniform3d",
          "context = %d, program = %u, location = %d, v0 = %f, v1 = %f, v2 = %f", CID(context),
          program, location, v0, v1, v2);

    if (context)
    {
        ShaderProgramID programPacked                         = FromGL<ShaderProgramID>(program);
        UniformLocation locationPacked                        = FromGL<UniformLocation>(location);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateProgramUniform3d(context, programPacked, locationPacked, v0, v1, v2));
        if (isCallValid)
        {
            context->programUniform3d(programPacked, locationPacked, v0, v1, v2);
        }
        ANGLE_CAPTURE(ProgramUniform3d, isCallValid, context, programPacked, locationPacked, v0, v1,
                      v2);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY ProgramUniform3dv(GLuint program,
                                   GLint location,
                                   GLsizei count,
                                   const GLdouble *value)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::ProgramUniform3dv, "glProgramUniform3dv",
          "context = %d, program = %u, location = %d, count = %d, value = 0x%016" PRIxPTR "",
          CID(context), program, location, count, (uintptr_t)value);

    if (context)
    {
        ShaderProgramID programPacked                         = FromGL<ShaderProgramID>(program);
        UniformLocation locationPacked                        = FromGL<UniformLocation>(location);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateProgramUniform3dv(context, programPacked, locationPacked, count, value));
        if (isCallValid)
        {
            context->programUniform3dv(programPacked, locationPacked, count, value);
        }
        ANGLE_CAPTURE(ProgramUniform3dv, isCallValid, context, programPacked, locationPacked, count,
                      value);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY
ProgramUniform3f(GLuint program, GLint location, GLfloat v0, GLfloat v1, GLfloat v2)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::ProgramUniform3f, "glProgramUniform3f",
          "context = %d, program = %u, location = %d, v0 = %f, v1 = %f, v2 = %f", CID(context),
          program, location, v0, v1, v2);

    if (context)
    {
        ShaderProgramID programPacked                         = FromGL<ShaderProgramID>(program);
        UniformLocation locationPacked                        = FromGL<UniformLocation>(location);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateProgramUniform3f(context, programPacked, locationPacked, v0, v1, v2));
        if (isCallValid)
        {
            context->programUniform3f(programPacked, locationPacked, v0, v1, v2);
        }
        ANGLE_CAPTURE(ProgramUniform3f, isCallValid, context, programPacked, locationPacked, v0, v1,
                      v2);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY ProgramUniform3fv(GLuint program,
                                   GLint location,
                                   GLsizei count,
                                   const GLfloat *value)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::ProgramUniform3fv, "glProgramUniform3fv",
          "context = %d, program = %u, location = %d, count = %d, value = 0x%016" PRIxPTR "",
          CID(context), program, location, count, (uintptr_t)value);

    if (context)
    {
        ShaderProgramID programPacked                         = FromGL<ShaderProgramID>(program);
        UniformLocation locationPacked                        = FromGL<UniformLocation>(location);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateProgramUniform3fv(context, programPacked, locationPacked, count, value));
        if (isCallValid)
        {
            context->programUniform3fv(programPacked, locationPacked, count, value);
        }
        ANGLE_CAPTURE(ProgramUniform3fv, isCallValid, context, programPacked, locationPacked, count,
                      value);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY ProgramUniform3i(GLuint program, GLint location, GLint v0, GLint v1, GLint v2)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::ProgramUniform3i, "glProgramUniform3i",
          "context = %d, program = %u, location = %d, v0 = %d, v1 = %d, v2 = %d", CID(context),
          program, location, v0, v1, v2);

    if (context)
    {
        ShaderProgramID programPacked                         = FromGL<ShaderProgramID>(program);
        UniformLocation locationPacked                        = FromGL<UniformLocation>(location);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateProgramUniform3i(context, programPacked, locationPacked, v0, v1, v2));
        if (isCallValid)
        {
            context->programUniform3i(programPacked, locationPacked, v0, v1, v2);
        }
        ANGLE_CAPTURE(ProgramUniform3i, isCallValid, context, programPacked, locationPacked, v0, v1,
                      v2);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY ProgramUniform3iv(GLuint program,
                                   GLint location,
                                   GLsizei count,
                                   const GLint *value)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::ProgramUniform3iv, "glProgramUniform3iv",
          "context = %d, program = %u, location = %d, count = %d, value = 0x%016" PRIxPTR "",
          CID(context), program, location, count, (uintptr_t)value);

    if (context)
    {
        ShaderProgramID programPacked                         = FromGL<ShaderProgramID>(program);
        UniformLocation locationPacked                        = FromGL<UniformLocation>(location);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateProgramUniform3iv(context, programPacked, locationPacked, count, value));
        if (isCallValid)
        {
            context->programUniform3iv(programPacked, locationPacked, count, value);
        }
        ANGLE_CAPTURE(ProgramUniform3iv, isCallValid, context, programPacked, locationPacked, count,
                      value);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY ProgramUniform3ui(GLuint program, GLint location, GLuint v0, GLuint v1, GLuint v2)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::ProgramUniform3ui, "glProgramUniform3ui",
          "context = %d, program = %u, location = %d, v0 = %u, v1 = %u, v2 = %u", CID(context),
          program, location, v0, v1, v2);

    if (context)
    {
        ShaderProgramID programPacked                         = FromGL<ShaderProgramID>(program);
        UniformLocation locationPacked                        = FromGL<UniformLocation>(location);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateProgramUniform3ui(context, programPacked, locationPacked, v0, v1, v2));
        if (isCallValid)
        {
            context->programUniform3ui(programPacked, locationPacked, v0, v1, v2);
        }
        ANGLE_CAPTURE(ProgramUniform3ui, isCallValid, context, programPacked, locationPacked, v0,
                      v1, v2);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY ProgramUniform3uiv(GLuint program,
                                    GLint location,
                                    GLsizei count,
                                    const GLuint *value)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::ProgramUniform3uiv, "glProgramUniform3uiv",
          "context = %d, program = %u, location = %d, count = %d, value = 0x%016" PRIxPTR "",
          CID(context), program, location, count, (uintptr_t)value);

    if (context)
    {
        ShaderProgramID programPacked                         = FromGL<ShaderProgramID>(program);
        UniformLocation locationPacked                        = FromGL<UniformLocation>(location);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateProgramUniform3uiv(context, programPacked, locationPacked, count, value));
        if (isCallValid)
        {
            context->programUniform3uiv(programPacked, locationPacked, count, value);
        }
        ANGLE_CAPTURE(ProgramUniform3uiv, isCallValid, context, programPacked, locationPacked,
                      count, value);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY
ProgramUniform4d(GLuint program, GLint location, GLdouble v0, GLdouble v1, GLdouble v2, GLdouble v3)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::ProgramUniform4d, "glProgramUniform4d",
          "context = %d, program = %u, location = %d, v0 = %f, v1 = %f, v2 = %f, v3 = %f",
          CID(context), program, location, v0, v1, v2, v3);

    if (context)
    {
        ShaderProgramID programPacked                         = FromGL<ShaderProgramID>(program);
        UniformLocation locationPacked                        = FromGL<UniformLocation>(location);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateProgramUniform4d(context, programPacked, locationPacked, v0, v1, v2, v3));
        if (isCallValid)
        {
            context->programUniform4d(programPacked, locationPacked, v0, v1, v2, v3);
        }
        ANGLE_CAPTURE(ProgramUniform4d, isCallValid, context, programPacked, locationPacked, v0, v1,
                      v2, v3);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY ProgramUniform4dv(GLuint program,
                                   GLint location,
                                   GLsizei count,
                                   const GLdouble *value)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::ProgramUniform4dv, "glProgramUniform4dv",
          "context = %d, program = %u, location = %d, count = %d, value = 0x%016" PRIxPTR "",
          CID(context), program, location, count, (uintptr_t)value);

    if (context)
    {
        ShaderProgramID programPacked                         = FromGL<ShaderProgramID>(program);
        UniformLocation locationPacked                        = FromGL<UniformLocation>(location);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateProgramUniform4dv(context, programPacked, locationPacked, count, value));
        if (isCallValid)
        {
            context->programUniform4dv(programPacked, locationPacked, count, value);
        }
        ANGLE_CAPTURE(ProgramUniform4dv, isCallValid, context, programPacked, locationPacked, count,
                      value);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY
ProgramUniform4f(GLuint program, GLint location, GLfloat v0, GLfloat v1, GLfloat v2, GLfloat v3)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::ProgramUniform4f, "glProgramUniform4f",
          "context = %d, program = %u, location = %d, v0 = %f, v1 = %f, v2 = %f, v3 = %f",
          CID(context), program, location, v0, v1, v2, v3);

    if (context)
    {
        ShaderProgramID programPacked                         = FromGL<ShaderProgramID>(program);
        UniformLocation locationPacked                        = FromGL<UniformLocation>(location);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateProgramUniform4f(context, programPacked, locationPacked, v0, v1, v2, v3));
        if (isCallValid)
        {
            context->programUniform4f(programPacked, locationPacked, v0, v1, v2, v3);
        }
        ANGLE_CAPTURE(ProgramUniform4f, isCallValid, context, programPacked, locationPacked, v0, v1,
                      v2, v3);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY ProgramUniform4fv(GLuint program,
                                   GLint location,
                                   GLsizei count,
                                   const GLfloat *value)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::ProgramUniform4fv, "glProgramUniform4fv",
          "context = %d, program = %u, location = %d, count = %d, value = 0x%016" PRIxPTR "",
          CID(context), program, location, count, (uintptr_t)value);

    if (context)
    {
        ShaderProgramID programPacked                         = FromGL<ShaderProgramID>(program);
        UniformLocation locationPacked                        = FromGL<UniformLocation>(location);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateProgramUniform4fv(context, programPacked, locationPacked, count, value));
        if (isCallValid)
        {
            context->programUniform4fv(programPacked, locationPacked, count, value);
        }
        ANGLE_CAPTURE(ProgramUniform4fv, isCallValid, context, programPacked, locationPacked, count,
                      value);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY
ProgramUniform4i(GLuint program, GLint location, GLint v0, GLint v1, GLint v2, GLint v3)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::ProgramUniform4i, "glProgramUniform4i",
          "context = %d, program = %u, location = %d, v0 = %d, v1 = %d, v2 = %d, v3 = %d",
          CID(context), program, location, v0, v1, v2, v3);

    if (context)
    {
        ShaderProgramID programPacked                         = FromGL<ShaderProgramID>(program);
        UniformLocation locationPacked                        = FromGL<UniformLocation>(location);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateProgramUniform4i(context, programPacked, locationPacked, v0, v1, v2, v3));
        if (isCallValid)
        {
            context->programUniform4i(programPacked, locationPacked, v0, v1, v2, v3);
        }
        ANGLE_CAPTURE(ProgramUniform4i, isCallValid, context, programPacked, locationPacked, v0, v1,
                      v2, v3);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY ProgramUniform4iv(GLuint program,
                                   GLint location,
                                   GLsizei count,
                                   const GLint *value)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::ProgramUniform4iv, "glProgramUniform4iv",
          "context = %d, program = %u, location = %d, count = %d, value = 0x%016" PRIxPTR "",
          CID(context), program, location, count, (uintptr_t)value);

    if (context)
    {
        ShaderProgramID programPacked                         = FromGL<ShaderProgramID>(program);
        UniformLocation locationPacked                        = FromGL<UniformLocation>(location);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateProgramUniform4iv(context, programPacked, locationPacked, count, value));
        if (isCallValid)
        {
            context->programUniform4iv(programPacked, locationPacked, count, value);
        }
        ANGLE_CAPTURE(ProgramUniform4iv, isCallValid, context, programPacked, locationPacked, count,
                      value);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY
ProgramUniform4ui(GLuint program, GLint location, GLuint v0, GLuint v1, GLuint v2, GLuint v3)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::ProgramUniform4ui, "glProgramUniform4ui",
          "context = %d, program = %u, location = %d, v0 = %u, v1 = %u, v2 = %u, v3 = %u",
          CID(context), program, location, v0, v1, v2, v3);

    if (context)
    {
        ShaderProgramID programPacked                         = FromGL<ShaderProgramID>(program);
        UniformLocation locationPacked                        = FromGL<UniformLocation>(location);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateProgramUniform4ui(context, programPacked, locationPacked, v0, v1, v2, v3));
        if (isCallValid)
        {
            context->programUniform4ui(programPacked, locationPacked, v0, v1, v2, v3);
        }
        ANGLE_CAPTURE(ProgramUniform4ui, isCallValid, context, programPacked, locationPacked, v0,
                      v1, v2, v3);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY ProgramUniform4uiv(GLuint program,
                                    GLint location,
                                    GLsizei count,
                                    const GLuint *value)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::ProgramUniform4uiv, "glProgramUniform4uiv",
          "context = %d, program = %u, location = %d, count = %d, value = 0x%016" PRIxPTR "",
          CID(context), program, location, count, (uintptr_t)value);

    if (context)
    {
        ShaderProgramID programPacked                         = FromGL<ShaderProgramID>(program);
        UniformLocation locationPacked                        = FromGL<UniformLocation>(location);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateProgramUniform4uiv(context, programPacked, locationPacked, count, value));
        if (isCallValid)
        {
            context->programUniform4uiv(programPacked, locationPacked, count, value);
        }
        ANGLE_CAPTURE(ProgramUniform4uiv, isCallValid, context, programPacked, locationPacked,
                      count, value);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY ProgramUniformMatrix2dv(GLuint program,
                                         GLint location,
                                         GLsizei count,
                                         GLboolean transpose,
                                         const GLdouble *value)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::ProgramUniformMatrix2dv, "glProgramUniformMatrix2dv",
          "context = %d, program = %u, location = %d, count = %d, transpose = %s, value = "
          "0x%016" PRIxPTR "",
          CID(context), program, location, count, GLbooleanToString(transpose), (uintptr_t)value);

    if (context)
    {
        ShaderProgramID programPacked                         = FromGL<ShaderProgramID>(program);
        UniformLocation locationPacked                        = FromGL<UniformLocation>(location);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateProgramUniformMatrix2dv(context, programPacked, locationPacked,
                                                            count, transpose, value));
        if (isCallValid)
        {
            context->programUniformMatrix2dv(programPacked, locationPacked, count, transpose,
                                             value);
        }
        ANGLE_CAPTURE(ProgramUniformMatrix2dv, isCallValid, context, programPacked, locationPacked,
                      count, transpose, value);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY ProgramUniformMatrix2fv(GLuint program,
                                         GLint location,
                                         GLsizei count,
                                         GLboolean transpose,
                                         const GLfloat *value)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::ProgramUniformMatrix2fv, "glProgramUniformMatrix2fv",
          "context = %d, program = %u, location = %d, count = %d, transpose = %s, value = "
          "0x%016" PRIxPTR "",
          CID(context), program, location, count, GLbooleanToString(transpose), (uintptr_t)value);

    if (context)
    {
        ShaderProgramID programPacked                         = FromGL<ShaderProgramID>(program);
        UniformLocation locationPacked                        = FromGL<UniformLocation>(location);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateProgramUniformMatrix2fv(context, programPacked, locationPacked,
                                                            count, transpose, value));
        if (isCallValid)
        {
            context->programUniformMatrix2fv(programPacked, locationPacked, count, transpose,
                                             value);
        }
        ANGLE_CAPTURE(ProgramUniformMatrix2fv, isCallValid, context, programPacked, locationPacked,
                      count, transpose, value);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY ProgramUniformMatrix2x3dv(GLuint program,
                                           GLint location,
                                           GLsizei count,
                                           GLboolean transpose,
                                           const GLdouble *value)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::ProgramUniformMatrix2x3dv, "glProgramUniformMatrix2x3dv",
          "context = %d, program = %u, location = %d, count = %d, transpose = %s, value = "
          "0x%016" PRIxPTR "",
          CID(context), program, location, count, GLbooleanToString(transpose), (uintptr_t)value);

    if (context)
    {
        ShaderProgramID programPacked                         = FromGL<ShaderProgramID>(program);
        UniformLocation locationPacked                        = FromGL<UniformLocation>(location);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateProgramUniformMatrix2x3dv(
                                context, programPacked, locationPacked, count, transpose, value));
        if (isCallValid)
        {
            context->programUniformMatrix2x3dv(programPacked, locationPacked, count, transpose,
                                               value);
        }
        ANGLE_CAPTURE(ProgramUniformMatrix2x3dv, isCallValid, context, programPacked,
                      locationPacked, count, transpose, value);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY ProgramUniformMatrix2x3fv(GLuint program,
                                           GLint location,
                                           GLsizei count,
                                           GLboolean transpose,
                                           const GLfloat *value)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::ProgramUniformMatrix2x3fv, "glProgramUniformMatrix2x3fv",
          "context = %d, program = %u, location = %d, count = %d, transpose = %s, value = "
          "0x%016" PRIxPTR "",
          CID(context), program, location, count, GLbooleanToString(transpose), (uintptr_t)value);

    if (context)
    {
        ShaderProgramID programPacked                         = FromGL<ShaderProgramID>(program);
        UniformLocation locationPacked                        = FromGL<UniformLocation>(location);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateProgramUniformMatrix2x3fv(
                                context, programPacked, locationPacked, count, transpose, value));
        if (isCallValid)
        {
            context->programUniformMatrix2x3fv(programPacked, locationPacked, count, transpose,
                                               value);
        }
        ANGLE_CAPTURE(ProgramUniformMatrix2x3fv, isCallValid, context, programPacked,
                      locationPacked, count, transpose, value);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY ProgramUniformMatrix2x4dv(GLuint program,
                                           GLint location,
                                           GLsizei count,
                                           GLboolean transpose,
                                           const GLdouble *value)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::ProgramUniformMatrix2x4dv, "glProgramUniformMatrix2x4dv",
          "context = %d, program = %u, location = %d, count = %d, transpose = %s, value = "
          "0x%016" PRIxPTR "",
          CID(context), program, location, count, GLbooleanToString(transpose), (uintptr_t)value);

    if (context)
    {
        ShaderProgramID programPacked                         = FromGL<ShaderProgramID>(program);
        UniformLocation locationPacked                        = FromGL<UniformLocation>(location);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateProgramUniformMatrix2x4dv(
                                context, programPacked, locationPacked, count, transpose, value));
        if (isCallValid)
        {
            context->programUniformMatrix2x4dv(programPacked, locationPacked, count, transpose,
                                               value);
        }
        ANGLE_CAPTURE(ProgramUniformMatrix2x4dv, isCallValid, context, programPacked,
                      locationPacked, count, transpose, value);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY ProgramUniformMatrix2x4fv(GLuint program,
                                           GLint location,
                                           GLsizei count,
                                           GLboolean transpose,
                                           const GLfloat *value)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::ProgramUniformMatrix2x4fv, "glProgramUniformMatrix2x4fv",
          "context = %d, program = %u, location = %d, count = %d, transpose = %s, value = "
          "0x%016" PRIxPTR "",
          CID(context), program, location, count, GLbooleanToString(transpose), (uintptr_t)value);

    if (context)
    {
        ShaderProgramID programPacked                         = FromGL<ShaderProgramID>(program);
        UniformLocation locationPacked                        = FromGL<UniformLocation>(location);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateProgramUniformMatrix2x4fv(
                                context, programPacked, locationPacked, count, transpose, value));
        if (isCallValid)
        {
            context->programUniformMatrix2x4fv(programPacked, locationPacked, count, transpose,
                                               value);
        }
        ANGLE_CAPTURE(ProgramUniformMatrix2x4fv, isCallValid, context, programPacked,
                      locationPacked, count, transpose, value);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY ProgramUniformMatrix3dv(GLuint program,
                                         GLint location,
                                         GLsizei count,
                                         GLboolean transpose,
                                         const GLdouble *value)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::ProgramUniformMatrix3dv, "glProgramUniformMatrix3dv",
          "context = %d, program = %u, location = %d, count = %d, transpose = %s, value = "
          "0x%016" PRIxPTR "",
          CID(context), program, location, count, GLbooleanToString(transpose), (uintptr_t)value);

    if (context)
    {
        ShaderProgramID programPacked                         = FromGL<ShaderProgramID>(program);
        UniformLocation locationPacked                        = FromGL<UniformLocation>(location);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateProgramUniformMatrix3dv(context, programPacked, locationPacked,
                                                            count, transpose, value));
        if (isCallValid)
        {
            context->programUniformMatrix3dv(programPacked, locationPacked, count, transpose,
                                             value);
        }
        ANGLE_CAPTURE(ProgramUniformMatrix3dv, isCallValid, context, programPacked, locationPacked,
                      count, transpose, value);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY ProgramUniformMatrix3fv(GLuint program,
                                         GLint location,
                                         GLsizei count,
                                         GLboolean transpose,
                                         const GLfloat *value)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::ProgramUniformMatrix3fv, "glProgramUniformMatrix3fv",
          "context = %d, program = %u, location = %d, count = %d, transpose = %s, value = "
          "0x%016" PRIxPTR "",
          CID(context), program, location, count, GLbooleanToString(transpose), (uintptr_t)value);

    if (context)
    {
        ShaderProgramID programPacked                         = FromGL<ShaderProgramID>(program);
        UniformLocation locationPacked                        = FromGL<UniformLocation>(location);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateProgramUniformMatrix3fv(context, programPacked, locationPacked,
                                                            count, transpose, value));
        if (isCallValid)
        {
            context->programUniformMatrix3fv(programPacked, locationPacked, count, transpose,
                                             value);
        }
        ANGLE_CAPTURE(ProgramUniformMatrix3fv, isCallValid, context, programPacked, locationPacked,
                      count, transpose, value);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY ProgramUniformMatrix3x2dv(GLuint program,
                                           GLint location,
                                           GLsizei count,
                                           GLboolean transpose,
                                           const GLdouble *value)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::ProgramUniformMatrix3x2dv, "glProgramUniformMatrix3x2dv",
          "context = %d, program = %u, location = %d, count = %d, transpose = %s, value = "
          "0x%016" PRIxPTR "",
          CID(context), program, location, count, GLbooleanToString(transpose), (uintptr_t)value);

    if (context)
    {
        ShaderProgramID programPacked                         = FromGL<ShaderProgramID>(program);
        UniformLocation locationPacked                        = FromGL<UniformLocation>(location);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateProgramUniformMatrix3x2dv(
                                context, programPacked, locationPacked, count, transpose, value));
        if (isCallValid)
        {
            context->programUniformMatrix3x2dv(programPacked, locationPacked, count, transpose,
                                               value);
        }
        ANGLE_CAPTURE(ProgramUniformMatrix3x2dv, isCallValid, context, programPacked,
                      locationPacked, count, transpose, value);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY ProgramUniformMatrix3x2fv(GLuint program,
                                           GLint location,
                                           GLsizei count,
                                           GLboolean transpose,
                                           const GLfloat *value)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::ProgramUniformMatrix3x2fv, "glProgramUniformMatrix3x2fv",
          "context = %d, program = %u, location = %d, count = %d, transpose = %s, value = "
          "0x%016" PRIxPTR "",
          CID(context), program, location, count, GLbooleanToString(transpose), (uintptr_t)value);

    if (context)
    {
        ShaderProgramID programPacked                         = FromGL<ShaderProgramID>(program);
        UniformLocation locationPacked                        = FromGL<UniformLocation>(location);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateProgramUniformMatrix3x2fv(
                                context, programPacked, locationPacked, count, transpose, value));
        if (isCallValid)
        {
            context->programUniformMatrix3x2fv(programPacked, locationPacked, count, transpose,
                                               value);
        }
        ANGLE_CAPTURE(ProgramUniformMatrix3x2fv, isCallValid, context, programPacked,
                      locationPacked, count, transpose, value);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY ProgramUniformMatrix3x4dv(GLuint program,
                                           GLint location,
                                           GLsizei count,
                                           GLboolean transpose,
                                           const GLdouble *value)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::ProgramUniformMatrix3x4dv, "glProgramUniformMatrix3x4dv",
          "context = %d, program = %u, location = %d, count = %d, transpose = %s, value = "
          "0x%016" PRIxPTR "",
          CID(context), program, location, count, GLbooleanToString(transpose), (uintptr_t)value);

    if (context)
    {
        ShaderProgramID programPacked                         = FromGL<ShaderProgramID>(program);
        UniformLocation locationPacked                        = FromGL<UniformLocation>(location);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateProgramUniformMatrix3x4dv(
                                context, programPacked, locationPacked, count, transpose, value));
        if (isCallValid)
        {
            context->programUniformMatrix3x4dv(programPacked, locationPacked, count, transpose,
                                               value);
        }
        ANGLE_CAPTURE(ProgramUniformMatrix3x4dv, isCallValid, context, programPacked,
                      locationPacked, count, transpose, value);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY ProgramUniformMatrix3x4fv(GLuint program,
                                           GLint location,
                                           GLsizei count,
                                           GLboolean transpose,
                                           const GLfloat *value)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::ProgramUniformMatrix3x4fv, "glProgramUniformMatrix3x4fv",
          "context = %d, program = %u, location = %d, count = %d, transpose = %s, value = "
          "0x%016" PRIxPTR "",
          CID(context), program, location, count, GLbooleanToString(transpose), (uintptr_t)value);

    if (context)
    {
        ShaderProgramID programPacked                         = FromGL<ShaderProgramID>(program);
        UniformLocation locationPacked                        = FromGL<UniformLocation>(location);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateProgramUniformMatrix3x4fv(
                                context, programPacked, locationPacked, count, transpose, value));
        if (isCallValid)
        {
            context->programUniformMatrix3x4fv(programPacked, locationPacked, count, transpose,
                                               value);
        }
        ANGLE_CAPTURE(ProgramUniformMatrix3x4fv, isCallValid, context, programPacked,
                      locationPacked, count, transpose, value);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY ProgramUniformMatrix4dv(GLuint program,
                                         GLint location,
                                         GLsizei count,
                                         GLboolean transpose,
                                         const GLdouble *value)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::ProgramUniformMatrix4dv, "glProgramUniformMatrix4dv",
          "context = %d, program = %u, location = %d, count = %d, transpose = %s, value = "
          "0x%016" PRIxPTR "",
          CID(context), program, location, count, GLbooleanToString(transpose), (uintptr_t)value);

    if (context)
    {
        ShaderProgramID programPacked                         = FromGL<ShaderProgramID>(program);
        UniformLocation locationPacked                        = FromGL<UniformLocation>(location);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateProgramUniformMatrix4dv(context, programPacked, locationPacked,
                                                            count, transpose, value));
        if (isCallValid)
        {
            context->programUniformMatrix4dv(programPacked, locationPacked, count, transpose,
                                             value);
        }
        ANGLE_CAPTURE(ProgramUniformMatrix4dv, isCallValid, context, programPacked, locationPacked,
                      count, transpose, value);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY ProgramUniformMatrix4fv(GLuint program,
                                         GLint location,
                                         GLsizei count,
                                         GLboolean transpose,
                                         const GLfloat *value)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::ProgramUniformMatrix4fv, "glProgramUniformMatrix4fv",
          "context = %d, program = %u, location = %d, count = %d, transpose = %s, value = "
          "0x%016" PRIxPTR "",
          CID(context), program, location, count, GLbooleanToString(transpose), (uintptr_t)value);

    if (context)
    {
        ShaderProgramID programPacked                         = FromGL<ShaderProgramID>(program);
        UniformLocation locationPacked                        = FromGL<UniformLocation>(location);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateProgramUniformMatrix4fv(context, programPacked, locationPacked,
                                                            count, transpose, value));
        if (isCallValid)
        {
            context->programUniformMatrix4fv(programPacked, locationPacked, count, transpose,
                                             value);
        }
        ANGLE_CAPTURE(ProgramUniformMatrix4fv, isCallValid, context, programPacked, locationPacked,
                      count, transpose, value);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY ProgramUniformMatrix4x2dv(GLuint program,
                                           GLint location,
                                           GLsizei count,
                                           GLboolean transpose,
                                           const GLdouble *value)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::ProgramUniformMatrix4x2dv, "glProgramUniformMatrix4x2dv",
          "context = %d, program = %u, location = %d, count = %d, transpose = %s, value = "
          "0x%016" PRIxPTR "",
          CID(context), program, location, count, GLbooleanToString(transpose), (uintptr_t)value);

    if (context)
    {
        ShaderProgramID programPacked                         = FromGL<ShaderProgramID>(program);
        UniformLocation locationPacked                        = FromGL<UniformLocation>(location);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateProgramUniformMatrix4x2dv(
                                context, programPacked, locationPacked, count, transpose, value));
        if (isCallValid)
        {
            context->programUniformMatrix4x2dv(programPacked, locationPacked, count, transpose,
                                               value);
        }
        ANGLE_CAPTURE(ProgramUniformMatrix4x2dv, isCallValid, context, programPacked,
                      locationPacked, count, transpose, value);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY ProgramUniformMatrix4x2fv(GLuint program,
                                           GLint location,
                                           GLsizei count,
                                           GLboolean transpose,
                                           const GLfloat *value)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::ProgramUniformMatrix4x2fv, "glProgramUniformMatrix4x2fv",
          "context = %d, program = %u, location = %d, count = %d, transpose = %s, value = "
          "0x%016" PRIxPTR "",
          CID(context), program, location, count, GLbooleanToString(transpose), (uintptr_t)value);

    if (context)
    {
        ShaderProgramID programPacked                         = FromGL<ShaderProgramID>(program);
        UniformLocation locationPacked                        = FromGL<UniformLocation>(location);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateProgramUniformMatrix4x2fv(
                                context, programPacked, locationPacked, count, transpose, value));
        if (isCallValid)
        {
            context->programUniformMatrix4x2fv(programPacked, locationPacked, count, transpose,
                                               value);
        }
        ANGLE_CAPTURE(ProgramUniformMatrix4x2fv, isCallValid, context, programPacked,
                      locationPacked, count, transpose, value);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY ProgramUniformMatrix4x3dv(GLuint program,
                                           GLint location,
                                           GLsizei count,
                                           GLboolean transpose,
                                           const GLdouble *value)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::ProgramUniformMatrix4x3dv, "glProgramUniformMatrix4x3dv",
          "context = %d, program = %u, location = %d, count = %d, transpose = %s, value = "
          "0x%016" PRIxPTR "",
          CID(context), program, location, count, GLbooleanToString(transpose), (uintptr_t)value);

    if (context)
    {
        ShaderProgramID programPacked                         = FromGL<ShaderProgramID>(program);
        UniformLocation locationPacked                        = FromGL<UniformLocation>(location);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateProgramUniformMatrix4x3dv(
                                context, programPacked, locationPacked, count, transpose, value));
        if (isCallValid)
        {
            context->programUniformMatrix4x3dv(programPacked, locationPacked, count, transpose,
                                               value);
        }
        ANGLE_CAPTURE(ProgramUniformMatrix4x3dv, isCallValid, context, programPacked,
                      locationPacked, count, transpose, value);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY ProgramUniformMatrix4x3fv(GLuint program,
                                           GLint location,
                                           GLsizei count,
                                           GLboolean transpose,
                                           const GLfloat *value)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::ProgramUniformMatrix4x3fv, "glProgramUniformMatrix4x3fv",
          "context = %d, program = %u, location = %d, count = %d, transpose = %s, value = "
          "0x%016" PRIxPTR "",
          CID(context), program, location, count, GLbooleanToString(transpose), (uintptr_t)value);

    if (context)
    {
        ShaderProgramID programPacked                         = FromGL<ShaderProgramID>(program);
        UniformLocation locationPacked                        = FromGL<UniformLocation>(location);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateProgramUniformMatrix4x3fv(
                                context, programPacked, locationPacked, count, transpose, value));
        if (isCallValid)
        {
            context->programUniformMatrix4x3fv(programPacked, locationPacked, count, transpose,
                                               value);
        }
        ANGLE_CAPTURE(ProgramUniformMatrix4x3fv, isCallValid, context, programPacked,
                      locationPacked, count, transpose, value);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY ReleaseShaderCompiler()
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::ReleaseShaderCompiler, "glReleaseShaderCompiler", "context = %d",
          CID(context));

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid = (context->skipValidation() || ValidateReleaseShaderCompiler(context));
        if (isCallValid)
        {
            context->releaseShaderCompiler();
        }
        ANGLE_CAPTURE(ReleaseShaderCompiler, isCallValid, context);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY ScissorArrayv(GLuint first, GLsizei count, const GLint *v)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::ScissorArrayv, "glScissorArrayv",
          "context = %d, first = %u, count = %d, v = 0x%016" PRIxPTR "", CID(context), first, count,
          (uintptr_t)v);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateScissorArrayv(context, first, count, v));
        if (isCallValid)
        {
            context->scissorArrayv(first, count, v);
        }
        ANGLE_CAPTURE(ScissorArrayv, isCallValid, context, first, count, v);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY
ScissorIndexed(GLuint index, GLint left, GLint bottom, GLsizei width, GLsizei height)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::ScissorIndexed, "glScissorIndexed",
          "context = %d, index = %u, left = %d, bottom = %d, width = %d, height = %d", CID(context),
          index, left, bottom, width, height);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateScissorIndexed(context, index, left, bottom, width, height));
        if (isCallValid)
        {
            context->scissorIndexed(index, left, bottom, width, height);
        }
        ANGLE_CAPTURE(ScissorIndexed, isCallValid, context, index, left, bottom, width, height);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY ScissorIndexedv(GLuint index, const GLint *v)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::ScissorIndexedv, "glScissorIndexedv",
          "context = %d, index = %u, v = 0x%016" PRIxPTR "", CID(context), index, (uintptr_t)v);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateScissorIndexedv(context, index, v));
        if (isCallValid)
        {
            context->scissorIndexedv(index, v);
        }
        ANGLE_CAPTURE(ScissorIndexedv, isCallValid, context, index, v);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY ShaderBinary(GLsizei count,
                              const GLuint *shaders,
                              GLenum binaryformat,
                              const void *binary,
                              GLsizei length)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::ShaderBinary, "glShaderBinary",
          "context = %d, count = %d, shaders = 0x%016" PRIxPTR
          ", binaryformat = %s, binary = 0x%016" PRIxPTR ", length = %d",
          CID(context), count, (uintptr_t)shaders,
          GLenumToString(GLenumGroup::DefaultGroup, binaryformat), (uintptr_t)binary, length);

    if (context)
    {
        const ShaderProgramID *shadersPacked = FromGL<const ShaderProgramID *>(shaders);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateShaderBinary(context, count, shadersPacked, binaryformat, binary, length));
        if (isCallValid)
        {
            context->shaderBinary(count, shadersPacked, binaryformat, binary, length);
        }
        ANGLE_CAPTURE(ShaderBinary, isCallValid, context, count, shadersPacked, binaryformat,
                      binary, length);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY UseProgramStages(GLuint pipeline, GLbitfield stages, GLuint program)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::UseProgramStages, "glUseProgramStages",
          "context = %d, pipeline = %u, stages = %s, program = %u", CID(context), pipeline,
          GLbitfieldToString(GLenumGroup::UseProgramStageMask, stages).c_str(), program);

    if (context)
    {
        ProgramPipelineID pipelinePacked                      = FromGL<ProgramPipelineID>(pipeline);
        ShaderProgramID programPacked                         = FromGL<ShaderProgramID>(program);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateUseProgramStages(context, pipelinePacked, stages, programPacked));
        if (isCallValid)
        {
            context->useProgramStages(pipelinePacked, stages, programPacked);
        }
        ANGLE_CAPTURE(UseProgramStages, isCallValid, context, pipelinePacked, stages,
                      programPacked);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY ValidateProgramPipeline(GLuint pipeline)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::ValidateProgramPipeline, "glValidateProgramPipeline",
          "context = %d, pipeline = %u", CID(context), pipeline);

    if (context)
    {
        ProgramPipelineID pipelinePacked                      = FromGL<ProgramPipelineID>(pipeline);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateValidateProgramPipeline(context, pipelinePacked));
        if (isCallValid)
        {
            context->validateProgramPipeline(pipelinePacked);
        }
        ANGLE_CAPTURE(ValidateProgramPipeline, isCallValid, context, pipelinePacked);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY VertexAttribL1d(GLuint index, GLdouble x)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::VertexAttribL1d, "glVertexAttribL1d",
          "context = %d, index = %u, x = %f", CID(context), index, x);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateVertexAttribL1d(context, index, x));
        if (isCallValid)
        {
            context->vertexAttribL1d(index, x);
        }
        ANGLE_CAPTURE(VertexAttribL1d, isCallValid, context, index, x);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY VertexAttribL1dv(GLuint index, const GLdouble *v)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::VertexAttribL1dv, "glVertexAttribL1dv",
          "context = %d, index = %u, v = 0x%016" PRIxPTR "", CID(context), index, (uintptr_t)v);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateVertexAttribL1dv(context, index, v));
        if (isCallValid)
        {
            context->vertexAttribL1dv(index, v);
        }
        ANGLE_CAPTURE(VertexAttribL1dv, isCallValid, context, index, v);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY VertexAttribL2d(GLuint index, GLdouble x, GLdouble y)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::VertexAttribL2d, "glVertexAttribL2d",
          "context = %d, index = %u, x = %f, y = %f", CID(context), index, x, y);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateVertexAttribL2d(context, index, x, y));
        if (isCallValid)
        {
            context->vertexAttribL2d(index, x, y);
        }
        ANGLE_CAPTURE(VertexAttribL2d, isCallValid, context, index, x, y);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY VertexAttribL2dv(GLuint index, const GLdouble *v)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::VertexAttribL2dv, "glVertexAttribL2dv",
          "context = %d, index = %u, v = 0x%016" PRIxPTR "", CID(context), index, (uintptr_t)v);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateVertexAttribL2dv(context, index, v));
        if (isCallValid)
        {
            context->vertexAttribL2dv(index, v);
        }
        ANGLE_CAPTURE(VertexAttribL2dv, isCallValid, context, index, v);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY VertexAttribL3d(GLuint index, GLdouble x, GLdouble y, GLdouble z)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::VertexAttribL3d, "glVertexAttribL3d",
          "context = %d, index = %u, x = %f, y = %f, z = %f", CID(context), index, x, y, z);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateVertexAttribL3d(context, index, x, y, z));
        if (isCallValid)
        {
            context->vertexAttribL3d(index, x, y, z);
        }
        ANGLE_CAPTURE(VertexAttribL3d, isCallValid, context, index, x, y, z);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY VertexAttribL3dv(GLuint index, const GLdouble *v)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::VertexAttribL3dv, "glVertexAttribL3dv",
          "context = %d, index = %u, v = 0x%016" PRIxPTR "", CID(context), index, (uintptr_t)v);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateVertexAttribL3dv(context, index, v));
        if (isCallValid)
        {
            context->vertexAttribL3dv(index, v);
        }
        ANGLE_CAPTURE(VertexAttribL3dv, isCallValid, context, index, v);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY VertexAttribL4d(GLuint index, GLdouble x, GLdouble y, GLdouble z, GLdouble w)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::VertexAttribL4d, "glVertexAttribL4d",
          "context = %d, index = %u, x = %f, y = %f, z = %f, w = %f", CID(context), index, x, y, z,
          w);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateVertexAttribL4d(context, index, x, y, z, w));
        if (isCallValid)
        {
            context->vertexAttribL4d(index, x, y, z, w);
        }
        ANGLE_CAPTURE(VertexAttribL4d, isCallValid, context, index, x, y, z, w);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY VertexAttribL4dv(GLuint index, const GLdouble *v)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::VertexAttribL4dv, "glVertexAttribL4dv",
          "context = %d, index = %u, v = 0x%016" PRIxPTR "", CID(context), index, (uintptr_t)v);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateVertexAttribL4dv(context, index, v));
        if (isCallValid)
        {
            context->vertexAttribL4dv(index, v);
        }
        ANGLE_CAPTURE(VertexAttribL4dv, isCallValid, context, index, v);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY
VertexAttribLPointer(GLuint index, GLint size, GLenum type, GLsizei stride, const void *pointer)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::VertexAttribLPointer, "glVertexAttribLPointer",
          "context = %d, index = %u, size = %d, type = %s, stride = %d, pointer = 0x%016" PRIxPTR
          "",
          CID(context), index, size, GLenumToString(GLenumGroup::VertexAttribPointerType, type),
          stride, (uintptr_t)pointer);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateVertexAttribLPointer(context, index, size, type, stride, pointer));
        if (isCallValid)
        {
            context->vertexAttribLPointer(index, size, type, stride, pointer);
        }
        ANGLE_CAPTURE(VertexAttribLPointer, isCallValid, context, index, size, type, stride,
                      pointer);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY ViewportArrayv(GLuint first, GLsizei count, const GLfloat *v)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::ViewportArrayv, "glViewportArrayv",
          "context = %d, first = %u, count = %d, v = 0x%016" PRIxPTR "", CID(context), first, count,
          (uintptr_t)v);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateViewportArrayv(context, first, count, v));
        if (isCallValid)
        {
            context->viewportArrayv(first, count, v);
        }
        ANGLE_CAPTURE(ViewportArrayv, isCallValid, context, first, count, v);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY ViewportIndexedf(GLuint index, GLfloat x, GLfloat y, GLfloat w, GLfloat h)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::ViewportIndexedf, "glViewportIndexedf",
          "context = %d, index = %u, x = %f, y = %f, w = %f, h = %f", CID(context), index, x, y, w,
          h);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateViewportIndexedf(context, index, x, y, w, h));
        if (isCallValid)
        {
            context->viewportIndexedf(index, x, y, w, h);
        }
        ANGLE_CAPTURE(ViewportIndexedf, isCallValid, context, index, x, y, w, h);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY ViewportIndexedfv(GLuint index, const GLfloat *v)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, gl::EntryPoint::ViewportIndexedfv, "glViewportIndexedfv",
          "context = %d, index = %u, v = 0x%016" PRIxPTR "", CID(context), index, (uintptr_t)v);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetShareGroupLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateViewportIndexedfv(context, index, v));
        if (isCallValid)
        {
            context->viewportIndexedfv(index, v);
        }
        ANGLE_CAPTURE(ViewportIndexedfv, isCallValid, context, index, v);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}
}  // namespace gl
