#!/usr/bin/python
# -*- coding: utf-8 -*-
# Copyright 2019 Red Hat
# GNU General Public License v3.0+
# (see COPYING or https://www.gnu.org/licenses/gpl-3.0.txt)

##############################################
#                 WARNING                    #
##############################################
#
# This file is auto generated by the resource
#   module builder playbook.
#
# Do not edit this file manually.
#
# Changes to this file will be over written
#   by the resource module builder.
#
# Changes should be made in the model used to
#   generate this file or in the resource module
#   builder template.
#
##############################################

"""
The module file for eos_interfaces
"""

from __future__ import absolute_import, division, print_function


__metaclass__ = type


DOCUMENTATION = """
module: eos_interfaces
short_description: Interfaces resource module
description:
  - This module manages the interface attributes of Arista EOS interfaces.
version_added: 1.0.0
author:
  - Nathaniel Case (@Qalthos)
notes:
  - Tested against Arista EOS 4.24.6F
  - This module works with connection C(network_cli).
    See U(https://docs.ansible.com/ansible/latest/network/user_guide/platform_eos.html)
options:
  config:
    description: The provided configuration
    type: list
    elements: dict
    suboptions:
      name:
        description:
          - Full name of the interface, e.g. GigabitEthernet1.
        type: str
        required: True
      description:
        description:
          - Interface description
        type: str
      duplex:
        description:
          - Interface link status. Applicable for Ethernet interfaces only.
          - Values other than C(auto) must also set I(speed).
          - Ignored when I(speed) is set above C(1000).
        type: str
      enabled:
        description:
          - Administrative state of the interface.
          - Set the value to C(true) to administratively enable the interface or C(false)
            to disable it.
        type: bool
      mtu:
        description:
          - MTU for a specific interface. Must be an even number between 576 and 9216.
            Applicable for Ethernet interfaces only.
        type: int
      speed:
        description:
          - Interface link speed. Applicable for Ethernet interfaces only.
        type: str
      mode:
        description:
          - Manage Layer2 or Layer3 state of the interface. Applicable for Ethernet
            and port channel interfaces only.
        choices:
          - layer2
          - layer3
        type: str
  running_config:
    description:
      - This option is used only with state I(parsed).
      - The value of this option should be the output received from the EOS device by
        executing the command B(show running-config | section ^interface).
      - The state I(parsed) reads the configuration from C(running_config) option and
        transforms it into Ansible structured data as per the resource module's argspec
        and the value is then returned in the I(parsed) key within the result.
    type: str
  state:
    choices:
      - merged
      - replaced
      - overridden
      - deleted
      - parsed
      - rendered
      - gathered
    default: merged
    description:
      - The state of the configuration after module completion.
    type: str
"""

EXAMPLES = """
# Using merged

# Before state:
# -------------
#
# test#show running-config | section interface
# interface Ethernet1
# !
# interface Ethernet2
# !
# interface Management1
#    ip address dhcp
#    dhcp client accept default-route

- name: Merge provided configuration with device configuration
  arista.eos.eos_interfaces:
    config:
      - name: Ethernet1
        enabled: true
        mode: layer3
      - name: Ethernet2
        description: Configured by Ansible
        enabled: false
    state: merged

# Task Output
# -----------
#
# before:
# - enabled: true
#   name: Ethernet1
# - enabled: true
#   name: Ethernet2
# - enabled: true
#   name: Management1
# commands:
# - interface Ethernet1
# - no switchport
# - interface Ethernet2
# - shutdown
# - description Configured by Ansible
# after:
# - enabled: true
#   mode: layer3
#   name: Ethernet1
# - description: Configured by Ansible
#   enabled: false
#   name: Ethernet2
# - enabled: true
#   name: Management1

# After state:
# ------------
#
# test#show running-config | section interface
# interface Ethernet1
#    no switchport
# !
# interface Ethernet2
#    description Configured by Ansible
#    shutdown
# !
# interface Management1
#    ip address dhcp
#    dhcp client accept default-route

# Using replaced

# Before state:
# -------------
#
# test#show running-config | section interface
# interface Ethernet1
#    no switchport
# !
# interface Ethernet2
#    description Configured by Ansible
#    shutdown
# !
# interface Management1
#    ip address dhcp
#    dhcp client accept default-route

- name: Replaces device configuration of listed interfaces with provided configuration
  arista.eos.eos_interfaces:
    config:
      - name: Ethernet1
        enabled: true
      - name: Ethernet2
        description: Configured by Ansible
        enabled: false
    state: replaced

# Task Output
# -----------
#
# before:
# - enabled: true
#   mode: layer3
#   name: Ethernet1
# - description: Configured by Ansible
#   enabled: false
#   name: Ethernet2
# - enabled: true
#   name: Management1
# commands:
# - interface Ethernet1
# - switchport
# after:
# - enabled: true
#   name: Ethernet1
# - description: Configured by Ansible
#   enabled: false
#   name: Ethernet2
# - enabled: true
#   name: Management1

# After state:
# ------------
#
# test#show running-config | section interface
# interface Ethernet1
# !
# interface Ethernet2
#    description Configured by Ansible
#    shutdown
# !
# interface Management1
#    ip address dhcp
#    dhcp client accept default-route

# Using overridden

# Before state:
# -------------
#
# test#show running-config | section interface
# interface Ethernet1
# !
# interface Ethernet2
#    description Configured by Ansible
#    shutdown
# !
# interface Management1
#    ip address dhcp
#    dhcp client accept default-route

- name: Overrides all device configuration with provided configuration
  arista.eos.eos_interfaces:
    config:
      - name: Ethernet1
        enabled: true
      - name: Ethernet2
        description: Configured by Ansible
        enabled: false
    state: overridden

# Task Output
# -----------
#
# before:
# - enabled: true
#   name: Ethernet1
# - description: Configured by Ansible
#   enabled: false
#   name: Ethernet2
# - enabled: true
#   name: Management1
# commands:
# - interface Management1
# - no shutdown
# after:
# - enabled: true
#   name: Ethernet1
# - description: Configured by Ansible
#   enabled: false
#   name: Ethernet2
# - enabled: true
#   name: Management1

# After state:
# ------------
#
# test#show running-config | section interface
# interface Ethernet1
# !
# interface Ethernet2
#    description Configured by Ansible
#    shutdown
# !
# interface Management1
#    ip address dhcp
#    dhcp client accept default-route

# Using deleted

# Before state:
# -------------
#
# test#show running-config | section interface
# interface Ethernet1
# !
# interface Ethernet2
#    description Configured by Ansible
#    shutdown
# !
# interface Management1
#    ip address dhcp
#    dhcp client accept default-route

- name: Delete or return interface parameters to default settings
  arista.eos.eos_interfaces:
    config:
      - name: Ethernet1
    state: deleted

# Task Output
# -----------
#
# before:
# - enabled: true
#   name: Ethernet1
# - description: Configured by Ansible
#   enabled: false
#   name: Ethernet2
# - enabled: true
#   name: Management1
# commands:
# - interface Ethernet1
# - no shutdown
# after:
# - enabled: true
#   name: Ethernet1
# - description: Configured by Ansible
#   enabled: false
#   name: Ethernet2
# - enabled: true
#   name: Management1

# After state:
# ------------
#
# test#show running-config | section interface
# interface Ethernet1
# !
# interface Ethernet2
#    description Configured by Ansible
#    shutdown
# !
# interface Management1
#    ip address dhcp
#    dhcp client accept default-route

# Using rendered

- name: Render the provided configuration into platform specific configuration lines
  arista.eos.eos_interfaces:
    config:
      - name: Ethernet1
        enabled: true
        mode: layer3
      - name: Ethernet2
        description: Configured by Ansible
        enabled: false
    state: rendered

# Module Execution Result:
# ------------------------
#
# rendered:
# - interface Ethernet1
# - no shutdown
# - no switchport
# - interface Ethernet2
# - shutdown
# - description Configured by Ansible

# Using Parsed

# File: parsed.cfg
# ----------------
#
# interface Ethernet1
#    description "Interface 1"
# !
# interface Ethernet2
#    description "Configured by Ansible"
#    shutdown
# !

- name: Parse the commands for provided configuration
  arista.eos.interfaces:
    running_config: "{{ lookup('file', 'parsed.cfg') }}"
    state: parsed

# Module Execution Result:
# ------------------------
#
# parsed:
#  - name: Ethernet1
#    enabled: True
#    mode: layer2
#  - name: Ethernet2
#    description: 'Configured by Ansible'
#    enabled: False
#    mode: layer2

# Using Gathered

# Before state:
# -------------
#
# test#show running-config | section interface
# interface Ethernet1
# !
# interface Ethernet2
#    description Configured by Ansible
#    shutdown
# !
# interface Management1
#    ip address dhcp
#    dhcp client accept default-route

- name: Gather interfaces facts from the device
  arista.eos.interfaces:
    state: gathered

# Module Execution Result:
# ------------------------
#
# gathered:
# - enabled: true
#   name: Ethernet1
# - description: Configured by Ansible
#   enabled: false
#   name: Ethernet2
# - enabled: true
#   name: Management1
"""

RETURN = """
before:
  description: The configuration prior to the module execution.
  returned: when I(state) is C(merged), C(replaced), C(overridden), C(deleted) or C(purged)
  type: dict
  sample: >
    This output will always be in the same format as the
    module argspec.
after:
  description: The resulting configuration after module execution.
  returned: when changed
  type: dict
  sample: >
    This output will always be in the same format as the
    module argspec.
commands:
  description: The set of commands pushed to the remote device.
  returned: when I(state) is C(merged), C(replaced), C(overridden), C(deleted) or C(purged)
  type: list
  sample:
    - interface Ethernet1
    - no shutdown
    - no switchport
rendered:
  description: The provided configuration in the task rendered in device-native format (offline).
  returned: when I(state) is C(rendered)
  type: list
  sample:
    - interface Ethernet1
    - no shutdown
    - no switchport
gathered:
  description: Facts about the network resource gathered from the remote device as structured data.
  returned: when I(state) is C(gathered)
  type: list
  sample: >
    This output will always be in the same format as the
    module argspec.
parsed:
  description: The device native config provided in I(running_config) option parsed into structured data as per module argspec.
  returned: when I(state) is C(parsed)
  type: list
  sample: >
    This output will always be in the same format as the
    module argspec.
"""


from ansible.module_utils.basic import AnsibleModule

from ansible_collections.arista.eos.plugins.module_utils.network.eos.argspec.interfaces.interfaces import (
    InterfacesArgs,
)
from ansible_collections.arista.eos.plugins.module_utils.network.eos.config.interfaces.interfaces import (
    Interfaces,
)


def main():
    """
    Main entry point for module execution

    :returns: the result form module invocation
    """

    required_if = [
        ("state", "merged", ("config",)),
        ("state", "replaced", ("config",)),
        ("state", "overridden", ("config",)),
        ("state", "rendered", ("config",)),
        ("state", "parsed", ("running_config",)),
    ]
    mutually_exclusive = [("config", "running_config")]

    module = AnsibleModule(
        argument_spec=InterfacesArgs.argument_spec,
        required_if=required_if,
        supports_check_mode=True,
        mutually_exclusive=mutually_exclusive,
    )

    result = Interfaces(module).execute_module()
    module.exit_json(**result)


if __name__ == "__main__":
    main()
