// Copyright 2017 Google Inc.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//
////////////////////////////////////////////////////////////////////////////////

// Definitions for common cryptographic enum types.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.36.10
// 	protoc        v3.21.12
// source: common.proto

package common_go_proto

import (
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	reflect "reflect"
	sync "sync"
	unsafe "unsafe"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

type EllipticCurveType int32

const (
	EllipticCurveType_UNKNOWN_CURVE EllipticCurveType = 0
	EllipticCurveType_NIST_P256     EllipticCurveType = 2
	EllipticCurveType_NIST_P384     EllipticCurveType = 3
	EllipticCurveType_NIST_P521     EllipticCurveType = 4
	EllipticCurveType_CURVE25519    EllipticCurveType = 5
)

// Enum value maps for EllipticCurveType.
var (
	EllipticCurveType_name = map[int32]string{
		0: "UNKNOWN_CURVE",
		2: "NIST_P256",
		3: "NIST_P384",
		4: "NIST_P521",
		5: "CURVE25519",
	}
	EllipticCurveType_value = map[string]int32{
		"UNKNOWN_CURVE": 0,
		"NIST_P256":     2,
		"NIST_P384":     3,
		"NIST_P521":     4,
		"CURVE25519":    5,
	}
)

func (x EllipticCurveType) Enum() *EllipticCurveType {
	p := new(EllipticCurveType)
	*p = x
	return p
}

func (x EllipticCurveType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (EllipticCurveType) Descriptor() protoreflect.EnumDescriptor {
	return file_common_proto_enumTypes[0].Descriptor()
}

func (EllipticCurveType) Type() protoreflect.EnumType {
	return &file_common_proto_enumTypes[0]
}

func (x EllipticCurveType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use EllipticCurveType.Descriptor instead.
func (EllipticCurveType) EnumDescriptor() ([]byte, []int) {
	return file_common_proto_rawDescGZIP(), []int{0}
}

type EcPointFormat int32

const (
	EcPointFormat_UNKNOWN_FORMAT EcPointFormat = 0
	EcPointFormat_UNCOMPRESSED   EcPointFormat = 1
	EcPointFormat_COMPRESSED     EcPointFormat = 2
	// Like UNCOMPRESSED but without the \x04 prefix. Crunchy uses this format.
	// DO NOT USE unless you are a Crunchy user moving to Tink.
	EcPointFormat_DO_NOT_USE_CRUNCHY_UNCOMPRESSED EcPointFormat = 3
)

// Enum value maps for EcPointFormat.
var (
	EcPointFormat_name = map[int32]string{
		0: "UNKNOWN_FORMAT",
		1: "UNCOMPRESSED",
		2: "COMPRESSED",
		3: "DO_NOT_USE_CRUNCHY_UNCOMPRESSED",
	}
	EcPointFormat_value = map[string]int32{
		"UNKNOWN_FORMAT":                  0,
		"UNCOMPRESSED":                    1,
		"COMPRESSED":                      2,
		"DO_NOT_USE_CRUNCHY_UNCOMPRESSED": 3,
	}
)

func (x EcPointFormat) Enum() *EcPointFormat {
	p := new(EcPointFormat)
	*p = x
	return p
}

func (x EcPointFormat) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (EcPointFormat) Descriptor() protoreflect.EnumDescriptor {
	return file_common_proto_enumTypes[1].Descriptor()
}

func (EcPointFormat) Type() protoreflect.EnumType {
	return &file_common_proto_enumTypes[1]
}

func (x EcPointFormat) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use EcPointFormat.Descriptor instead.
func (EcPointFormat) EnumDescriptor() ([]byte, []int) {
	return file_common_proto_rawDescGZIP(), []int{1}
}

type HashType int32

const (
	HashType_UNKNOWN_HASH HashType = 0
	HashType_SHA1         HashType = 1 // Using SHA1 for digital signature is deprecated but HMAC-SHA1 is
	// fine.
	HashType_SHA384 HashType = 2
	HashType_SHA256 HashType = 3
	HashType_SHA512 HashType = 4
	HashType_SHA224 HashType = 5
)

// Enum value maps for HashType.
var (
	HashType_name = map[int32]string{
		0: "UNKNOWN_HASH",
		1: "SHA1",
		2: "SHA384",
		3: "SHA256",
		4: "SHA512",
		5: "SHA224",
	}
	HashType_value = map[string]int32{
		"UNKNOWN_HASH": 0,
		"SHA1":         1,
		"SHA384":       2,
		"SHA256":       3,
		"SHA512":       4,
		"SHA224":       5,
	}
)

func (x HashType) Enum() *HashType {
	p := new(HashType)
	*p = x
	return p
}

func (x HashType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (HashType) Descriptor() protoreflect.EnumDescriptor {
	return file_common_proto_enumTypes[2].Descriptor()
}

func (HashType) Type() protoreflect.EnumType {
	return &file_common_proto_enumTypes[2]
}

func (x HashType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use HashType.Descriptor instead.
func (HashType) EnumDescriptor() ([]byte, []int) {
	return file_common_proto_rawDescGZIP(), []int{2}
}

var File_common_proto protoreflect.FileDescriptor

const file_common_proto_rawDesc = "" +
	"\n" +
	"\fcommon.proto\x12\x12google.crypto.tink*c\n" +
	"\x11EllipticCurveType\x12\x11\n" +
	"\rUNKNOWN_CURVE\x10\x00\x12\r\n" +
	"\tNIST_P256\x10\x02\x12\r\n" +
	"\tNIST_P384\x10\x03\x12\r\n" +
	"\tNIST_P521\x10\x04\x12\x0e\n" +
	"\n" +
	"CURVE25519\x10\x05*j\n" +
	"\rEcPointFormat\x12\x12\n" +
	"\x0eUNKNOWN_FORMAT\x10\x00\x12\x10\n" +
	"\fUNCOMPRESSED\x10\x01\x12\x0e\n" +
	"\n" +
	"COMPRESSED\x10\x02\x12#\n" +
	"\x1fDO_NOT_USE_CRUNCHY_UNCOMPRESSED\x10\x03*V\n" +
	"\bHashType\x12\x10\n" +
	"\fUNKNOWN_HASH\x10\x00\x12\b\n" +
	"\x04SHA1\x10\x01\x12\n" +
	"\n" +
	"\x06SHA384\x10\x02\x12\n" +
	"\n" +
	"\x06SHA256\x10\x03\x12\n" +
	"\n" +
	"\x06SHA512\x10\x04\x12\n" +
	"\n" +
	"\x06SHA224\x10\x05BY\n" +
	"\x1ccom.google.crypto.tink.protoP\x01Z7github.com/tink-crypto/tink-go/v2/proto/common_go_protob\x06proto3"

var (
	file_common_proto_rawDescOnce sync.Once
	file_common_proto_rawDescData []byte
)

func file_common_proto_rawDescGZIP() []byte {
	file_common_proto_rawDescOnce.Do(func() {
		file_common_proto_rawDescData = protoimpl.X.CompressGZIP(unsafe.Slice(unsafe.StringData(file_common_proto_rawDesc), len(file_common_proto_rawDesc)))
	})
	return file_common_proto_rawDescData
}

var file_common_proto_enumTypes = make([]protoimpl.EnumInfo, 3)
var file_common_proto_goTypes = []any{
	(EllipticCurveType)(0), // 0: google.crypto.tink.EllipticCurveType
	(EcPointFormat)(0),     // 1: google.crypto.tink.EcPointFormat
	(HashType)(0),          // 2: google.crypto.tink.HashType
}
var file_common_proto_depIdxs = []int32{
	0, // [0:0] is the sub-list for method output_type
	0, // [0:0] is the sub-list for method input_type
	0, // [0:0] is the sub-list for extension type_name
	0, // [0:0] is the sub-list for extension extendee
	0, // [0:0] is the sub-list for field type_name
}

func init() { file_common_proto_init() }
func file_common_proto_init() {
	if File_common_proto != nil {
		return
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: unsafe.Slice(unsafe.StringData(file_common_proto_rawDesc), len(file_common_proto_rawDesc)),
			NumEnums:      3,
			NumMessages:   0,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_common_proto_goTypes,
		DependencyIndexes: file_common_proto_depIdxs,
		EnumInfos:         file_common_proto_enumTypes,
	}.Build()
	File_common_proto = out.File
	file_common_proto_goTypes = nil
	file_common_proto_depIdxs = nil
}
