; NOTE: Assertions have been autogenerated by utils/update_test_checks.py UTC_ARGS: --version 4
; RUN: opt < %s -passes=nary-reassociate -S | FileCheck %s

; Test that NaryReassociate's tryReassociatedBinaryOp() propagates the
; debug location to new `add` and `mul` from the original binary operator
; they replaced (`%3` in both `@add_reassociate` and `@mul_reassociate`).

define void @add_reassociate(i32 %a, i32 %b, i32 %c) !dbg !5 {
; CHECK-LABEL: define void @add_reassociate(
; CHECK-SAME: i32 [[A:%.*]], i32 [[B:%.*]], i32 [[C:%.*]]) !dbg [[DBG5:![0-9]+]] {
; CHECK-NEXT:    [[TMP1:%.*]] = add i32 [[A]], [[C]]
; CHECK-NEXT:    call void @foo(i32 [[TMP1]])
; CHECK-NEXT:    [[TMP2:%.*]] = add i32 [[TMP1]], [[B]], !dbg [[DBG8:![0-9]+]]
; CHECK-NEXT:    call void @foo(i32 [[TMP2]])
; CHECK-NEXT:    ret void
;
  %1 = add i32 %a, %c
  call void @foo(i32 %1)
  %2 = add i32 %b, %c
  %3 = add i32 %a, %2, !dbg !11
  call void @foo(i32 %3)
  ret void
}

define void @mul_reassociate(i32 %a, i32 %b, i32 %c) !dbg !14 {
; CHECK-LABEL: define void @mul_reassociate(
; CHECK-SAME: i32 [[A:%.*]], i32 [[B:%.*]], i32 [[C:%.*]]) !dbg [[DBG9:![0-9]+]] {
; CHECK-NEXT:    [[TMP1:%.*]] = mul i32 [[A]], [[C]]
; CHECK-NEXT:    call void @foo(i32 [[TMP1]])
; CHECK-NEXT:    [[TMP2:%.*]] = mul i32 [[TMP1]], [[B]], !dbg [[DBG10:![0-9]+]]
; CHECK-NEXT:    call void @foo(i32 [[TMP2]])
; CHECK-NEXT:    ret void
;
  %1 = mul i32 %a, %c
  call void @foo(i32 %1)
  %2 = mul i32 %a, %b
  %3 = mul i32 %2, %c, !dbg !18
  call void @foo(i32 %3)
  ret void
}

declare void @foo(i32)

!llvm.dbg.cu = !{!0}
!llvm.debugify = !{!2, !3}
!llvm.module.flags = !{!4}

!0 = distinct !DICompileUnit(language: DW_LANG_C, file: !1, producer: "debugify", isOptimized: true, runtimeVersion: 0, emissionKind: FullDebug)
!1 = !DIFile(filename: "test.ll", directory: "/")
!2 = !{i32 12}
!3 = !{i32 0}
!4 = !{i32 2, !"Debug Info Version", i32 3}
!5 = distinct !DISubprogram(name: "add_reassociate", linkageName: "add_reassociate", scope: null, file: !1, line: 1, type: !6, scopeLine: 1, spFlags: DISPFlagDefinition | DISPFlagOptimized, unit: !0)
!6 = !DISubroutineType(types: !7)
!7 = !{}
!11 = !DILocation(line: 4, column: 1, scope: !5)
!14 = distinct !DISubprogram(name: "mul_reassociate", linkageName: "mul_reassociate", scope: null, file: !1, line: 7, type: !6, scopeLine: 7, spFlags: DISPFlagDefinition | DISPFlagOptimized, unit: !0)
!18 = !DILocation(line: 10, column: 1, scope: !14)

;.
; CHECK: [[META0:![0-9]+]] = distinct !DICompileUnit(language: DW_LANG_C, file: [[META1:![0-9]+]], producer: "debugify", isOptimized: true, runtimeVersion: 0, emissionKind: FullDebug)
; CHECK: [[META1]] = !DIFile(filename: "test.ll", directory: {{.*}})
; CHECK: [[DBG5]] = distinct !DISubprogram(name: "add_reassociate", linkageName: "add_reassociate", scope: null, file: [[META1]], line: 1, type: [[META6:![0-9]+]], scopeLine: 1, spFlags: DISPFlagDefinition | DISPFlagOptimized, unit: [[META0]])
; CHECK: [[META6]] = !DISubroutineType(types: [[META7:![0-9]+]])
; CHECK: [[META7]] = !{}
; CHECK: [[DBG8]] = !DILocation(line: 4, column: 1, scope: [[DBG5]])
; CHECK: [[DBG9]] = distinct !DISubprogram(name: "mul_reassociate", linkageName: "mul_reassociate", scope: null, file: [[META1]], line: 7, type: [[META6]], scopeLine: 7, spFlags: DISPFlagDefinition | DISPFlagOptimized, unit: [[META0]])
; CHECK: [[DBG10]] = !DILocation(line: 10, column: 1, scope: [[DBG9]])
;.
