/* This file is part of libhud-qt
 * Copyright 2013 Canonical Ltd.
 *
 * libhud-qt is free software: you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License version 3,
 * as published by the Free Software Foundation.
 *
 * libhud-qt is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranties of
 * MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR
 * PURPOSE.  See the GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include "quit-action.h"

// needed for glib includes.
#undef signals
#include <libhud-2/hud.h>

using namespace Ubuntu::HUD;

QuitAction::QuitAction(QObject *parent)
    : PredefinedAction(parent)
{
    Action::setIdentifier("ActionQuit");
    Action::setLabel("Quit");
    Action::setDescription("Quit the application.");

    HudActionDescription *desc;
    _actionDescription((void**)&desc);
    hud_action_description_set_attribute_value(desc, "hud-toolbar-item", g_variant_new_string("quit"));

    qWarning("%s:\n"
             "\tQuitAction is deprecated as Quit-button has been removed from the HUD UI.\n"
             "\tPlease, remove QuitAction from your code ASAP as it will be removed from the final 1.0 API.",
             __PRETTY_FUNCTION__);
}

