/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

#include <QtGui>

#include <Metview.h>
#include "MvQService.h"
#include "MvQX11Application.h"
#include "MacroEdit.h"
#include "MvMain.h"

using namespace std;


class MacroEditorApplication;

// Globals

int          ac;
char       **av;




// ----------------------------------------------------------------------
// MacroEditorApplication
// This is the main application class for the macro editor. It is a
// standard MvApplication because we don't need any Qt user interface
// at this point - that is created when the service is called.
// ----------------------------------------------------------------------

class MacroEditorApplication : public MvApplication
{
public:
    // Constructor
    MacroEditorApplication(int& ac, char** av, const char* name=NULL);

    // Destructor
    virtual ~MacroEditorApplication() {};
};


MacroEditorApplication::MacroEditorApplication (int& ac, char** av, const char* name)
 : MvApplication(ac, av, name)
{
//    setQuitOnLastWindowClosed (false);
}




// ==========================================================================================



// -------------------------------------------------------------------------
// MacroEditorService
// This is service for the macro editor. When serve() called, we create an
// MvQX11Application and pass it the path to the file we have been given.
// We then start its event loop. When the editor is quit, it will exit the
// serve() function.
// -------------------------------------------------------------------------

class MacroEditorService : public MvQService {

public:

    // Constructor
    MacroEditorService(const char *name);

    // Destructor
    ~MacroEditorService();

    void serve(MvRequest&,MvRequest&);
};


MacroEditorService::MacroEditorService(const char *name) : MvQService(name)
{
}


MacroEditorService::~MacroEditorService()
{
}

void MacroEditorService::serve(MvRequest &in, MvRequest &out)
{
    cout << "--------------MacroEditorService::serve()--------------" << endl;
    in.print();    


    // create the qt application

    MvQX11Application app(ac, av);



    // set up some parameters so that the application settings can be
    // loaded and saved consistently. If we do this, then we do not need
    // to do anything in the QSettings constructor.

    QCoreApplication::setOrganizationName   ("ECMWF");
    QCoreApplication::setOrganizationDomain ("ecmwf.int");
    QCoreApplication::setApplicationName    ("MacroEditor");

    QString appName("Metview Macro Editor");
    QString fileName;
    QString language;
  
    //Get verb
    string verb = in.getVerb();    
   
    if(verb == "MACROEDIT")
    {        
        const char *cFileName = in("PATH");  // get the path to the macro from the request
        fileName=QString(cFileName);

        const char *cLanguage = in("LANGUAGE");  // get the programming language
        language=QString(cLanguage);
    }
    else
    {
        const char *cFileName = in("PATH");  // get the path to the macro from the request
        if(cFileName)
            fileName=QString(cFileName);    
        else
            return;

        if(verb == "KML")
            language="MAGML";
        else
            language="NOTE";
    }

        
    MacroEdit editor (appName);         // create the editor instance itself

    editor.loadTextFile(fileName);
    editor.setLanguage(language);
    editor.autoInsertLicence();
    editor.show();
    editor.metview_dnd();
	
    //Listen to the mars event loop!
    //setupSocketNotifier();
    
    //Enter the app loop

    app.exec();    
}




// -------------------------------------------------------------------------
// main
// The program entry point. Start an MacroEditorApplication and the
// MacroEditorService.
// -------------------------------------------------------------------------

int main(int argc, char **argv)
{
    ac = argc;
    av = argv;
    
    MacroEditorApplication app(argc, argv, "macroedit");

    QString fileName = "";

    if (argc > 1)
    {
        fileName = argv[argc-1]; // take the last thing on the command line as the file to load
    }

    MacroEditorService service("MACROEDIT");  // create the service
    MacroEditorService service1("KML");
    MacroEditorService service2("RTTOV_OUTPUT_FILE");

    app.run();    
}
