/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

#ifndef ExternalTextEditor_H
#include "ExternalTextEditor.h"
#endif

#ifndef EditorFactory_H
#include "EditorFactory.h"
#endif


ExternalTextEditor::ExternalTextEditor(const IconClass& name,const string& kind):
	ExternalEditor(name,kind)
{
}

ExternalTextEditor::~ExternalTextEditor()
{
}

string ExternalTextEditor::command() 
{
    char buf[1024];
	string s = current_->path().str();
	sprintf(buf,"$METVIEW_EDITOR \"%s\"",s.c_str());
	return (buf);
}


static EditorMaker<ExternalTextEditor> editorMaker("ExternalTextEditor");
