/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

// File FamilyHelper.h
// Baudouin Raoult - ECMWF Jul 99

#ifndef FamilyHelper_H
#define FamilyHelper_H

#ifndef Language_H
#include "Language.h"
#endif

#ifndef Parameter_H
#include "Parameter.h"
#endif


class FamilyHelper : 
	public ParameterScanner,
	public LanguageScanner {
public:

// -- Exceptions
	// None

// -- Contructors


// -- Destructor


// -- Convertors
	// None

// -- Operators
	// None

// -- Methods
	
	const string& keyword() const;
	bool validate(Request&) const;
	const vector<string>& params() const;
	const vector<string>& values(const string&) ;//const;
	const vector<string>& beau(const string&) ;//const;

// -- Overridden methods
	// None

// -- Class members
	// None

// -- Class methods

	static FamilyHelper& find(const IconClass&);

	// Uncomment for persistent, remove otherwise
	// static os_typespec* get_os_typespec();

protected:

// -- Members
	// None

// -- Methods

	FamilyHelper(const IconClass&);
	virtual ~FamilyHelper(); // Change to virtual if base class  
	
	// void print(ostream&) const; // Change to virtual if base class	

// -- Overridden methods
	// None

// -- Class members
	// None

// -- Class methods
	// None

private:

// No copy allowed

	FamilyHelper(const FamilyHelper&);
	FamilyHelper& operator=(const FamilyHelper&);

// -- Members

	string                      keyword_;
	map<string,string>	        names_;
	const IconClass&            class_;
	vector<string>              params_;
	map<string,vector<string> > values_;
	map<string,vector<string> > beau_;


// -- Methods

// -- Overridden methods


	// From LanguageScanner
	virtual void next(const Parameter&);

	// From ParameterScanner
	virtual void next(const Parameter&, const char*,const char*);


// -- Class members
	// None

// -- Class methods
	// None

// -- Friends

	//friend ostream& operator<<(ostream& s,const FamilyHelper& p)
	//	{ p.print(s); return s; }

};

inline void destroy(FamilyHelper**) {}

// If persistent, uncomment, otherwise remove
//#ifdef _ODI_OSSG_
//OS_MARK_SCHEMA_TYPE(FamilyHelper);
//#endif

#endif
