/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

// File InternalTask.h
// Baudouin Raoult - ECMWF Jul 99

#ifndef InternalTask_H
#define InternalTask_H

#ifndef Task_H
#include "Task.h"
#endif

#ifndef Action_H
#include "Action.h"
#endif

#ifndef ReplyObserver_H
#include "ReplyObserver.h"
#endif

#include "TaskObserver.h"
#include "IconObject.h"
#include "Dependancy.h"



class InternalTask : public TaskObserver, public Task {
public:

// -- Exceptions
	// None

// -- Contructors

	InternalTask(const Action&,IconObject*);

// -- Destructor

	virtual ~InternalTask(); // Change to virtual if base class

// -- Convertors
	// None

// -- Operators


// -- Methods
	virtual void addContext (const Request&) { };

// -- Overridden methods
	// None

// -- Class members
	// None

// -- Class methods
	// None

	// Uncomment for persistent, remove otherwise
	// static os_typespec* get_os_typespec();

protected:

// -- Members
	// None

// -- Methods
	
	 void print(ostream&) const; // Change to virtual if base class	

// -- Overridden methods
	// None

// -- Class members
	// None

// -- Class methods
	// None

private:

// No copy allowed

	InternalTask(const InternalTask&);
	InternalTask& operator=(const InternalTask&);

// -- Members

	Action      action_;
	IconObjectH object_;
	bool        error_;
	int         waiting_;

	typedef map<TaskH,DependancyH> Map;
	Map tasks_;

// -- Methods

	void check();

// -- Overridden methods

	// From Task
	virtual void start();

	// From TaskObserver

	virtual void success(Task*,const Request&);
	virtual void failure(Task*);

// -- Class members
	// None

// -- Class methods
	// None

// -- Friends

	//friend ostream& operator<<(ostream& s,const InternalTask& p)
	//	{ p.print(s); return s; }

};

inline void destroy(InternalTask**) {}

// If persistent, uncomment, otherwise remove
//#ifdef _ODI_OSSG_
//OS_MARK_SCHEMA_TYPE(InternalTask);
//#endif

#endif
