/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

// File MacroParam.h
// Baudouin Raoult - ECMWF Jul 99

#ifndef MacroParam_H
#define MacroParam_H

#ifndef Basic_H
#include "Basic.h"
#endif

#include <string>
using std::string;

#ifndef MacroParamState_H
#include "MacroParamState.h"
#endif



class MacroParam : public Basic {
public:

// -- Exceptions
	// None

// -- Contructors

	MacroParam(Folder* parent,
		const IconClass& kind, const string& name,
		IconInfo* info);

// -- Destructor

	virtual ~MacroParam(); // Change to virtual if base class

// -- Convertors
	// None

// -- Operators
	// None

// -- Methods

	MacroParamState* state() const;
	void state(MacroParamState*);

// -- Overridden methods
	// None

// -- Class members
	// None

// -- Class methods
	// None

	// Uncomment for persistent, remove otherwise
	// static os_typespec* get_os_typespec();

protected:

// -- Members
	// None

// -- Methods
	
	// void print(ostream&) const; // Change to virtual if base class	

// -- Overridden methods
	// None

// -- Class members
	// None

// -- Class methods
	// None

private:

// No copy allowed

	MacroParam(const MacroParam&);
	MacroParam& operator=(const MacroParam&);

// -- Members

	MacroParamStateH state_;


// -- Methods


// -- Overridden methods

	Language& language() const;
	Request fullRequest() const;
	void request(const Request&);
	Request request() const;

// -- Class members
	// None

// -- Class methods
	// None

// -- Friends

	//friend ostream& operator<<(ostream& s,const MacroParam& p)
	//	{ p.print(s); return s; }

};

inline void destroy(MacroParam**) {}

// If persistent, uncomment, otherwise remove
//#ifdef _ODI_OSSG_
//OS_MARK_SCHEMA_TYPE(MacroParam);
//#endif

#endif
