/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

#ifndef Netscape_H
#include "Netscape.h"
#endif

#ifndef ConfigLoader_H
#include "ConfigLoader.h"
#endif

#ifndef IconClass_H
#include "IconClass.h"
#endif

#ifndef Action_H
#include "Action.h"
#endif

#ifndef Service_H
#include "Service.h"
#endif

#ifndef Request_H
#include "Request.h"
#endif

#ifndef Path_H
#include "Path.h"
#endif


//=================================================================

static map<string,string> web;

void Netscape::callNetscape(const Request& r)
{
	const IconClass& c = IconClass::find(r.getVerb());
	Action a("execute");	

	Service* service = c.service(a);
	MvApplication::callService(service->name().c_str(),r,0);

}

void Netscape::showURL(const string& url)
{
	cout << "Netscape::showURL " << url << endl;

	Request r("WEBACCESS");
	r("URL") = url.c_str();

	callNetscape(r);

}

void Netscape::showPage(const string& url)
{
	cout << "Netscape::showPage " << url << endl;
	showURL(web[url]);
}

void Netscape::showPage(const string& url,const string& page)
{
	cout << "Netscape::showPage " << url  << " - " << page << endl;
	showURL(web[url] + "/" + page);
}

void Netscape::savePage(const Path& path,const string& type)
{
	Request r("WEBACCESS");
	r("SAVE") = path.str().c_str();
	r("TYPE") = type.c_str();
	callNetscape(r);
}

void Netscape::load(request* r)
{
	const char* n = get_value(r,"page",0); 
	const char* u = get_value(r,"url",0); 
	if(n && u) web[n] = u;
}

static SimpleLoader<Netscape> loadClasses("web",1);
