/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

// File TextLine.h
// Baudouin Raoult - ECMWF Jul 99

#ifndef PlotModHelp_H
#define PlotModHelp_H

#ifndef RequestPanelHelp_H
#include "RequestPanelHelp.h"
#endif

#ifndef Request_H
#include "Request.h"
#endif

#ifndef ReplyObserver_H
#include "ReplyObserver.h"
#endif

#ifndef MessageObserver_H
#include "MessageObserver.h"
#endif

class PlotModHelp: public DialogHelp, public ReplyObserver, public MessageObserver {
public:

// -- Contructors

	PlotModHelp(Widget, RequestPanel&, const Parameter&);

// -- Destructor

	virtual ~PlotModHelp(); 

private:

// No copy allowed

	PlotModHelp(const PlotModHelp&);
	PlotModHelp& operator=(const PlotModHelp&);

// -- Members
	
	Request request_;

// -- Overridden methods

	// From DialogHelp

	virtual void start();

	// From ReplyObserver 

	void reply(const Request&, int);
	void progress(const Request&);
	void message(const string&);

	// From MessageObserver 

        void message(const Request& );

	// From RequestPanelItem
	virtual void set(Request&);
       	
};

#endif
