/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

// File QtMacroEditor.h
// Iain Russell - ECMWF Jan 2010
// based on:
//   File MacroEditor.h
//   Baudouin Raoult - ECMWF Jul 99

#ifndef QtMacroEditor_H
#define QtMacroEditor_H



class QtMacroEditor;

class MacroEditorObserver : public ReplyObserver {
public:

	MacroEditorObserver (QtMacroEditor &editor, string &path);
	virtual ~MacroEditorObserver(); // Change to virtual if base class

	virtual void start();

	// From ReplyObserver
	virtual void reply(const Request&, int);
	virtual void progress(const Request&);  
	virtual void message(const string&);

protected:

	 void print(ostream&) const; // Change to virtual if base class	

private:

// No copy allowed
    MacroEditorObserver(const MacroEditorObserver&);
	MacroEditorObserver& operator=(const MacroEditorObserver&);


    QtMacroEditor &editor_;
    string         path_;

// -- Overridden methods

	// From Task
};





class QtMacroEditor :public Editor {
public:

// -- Exceptions
	// None

// -- Contructors

	QtMacroEditor(const IconClass&,const string&);

// -- Destructor

	virtual ~QtMacroEditor(); // Change to virtual if base class

// -- Convertors
	// None

// -- Operators
	// None

// -- Methods

// -- Overridden methods


// -- Class members
	// None

// -- Class methods
	// None

	// Uncomment for persistent, remove otherwise
	// static os_typespec* get_os_typespec();

protected:

// -- Members
	// None

// -- Methods
	
	// void print(ostream&) const; // Change to virtual if base class	

// -- Overridden methods
	// None

// -- Class members
	// None

// -- Class methods
	// None

private:

// No copy allowed

	QtMacroEditor(const QtMacroEditor&);
	QtMacroEditor& operator=(const QtMacroEditor&);

// -- Members

// -- Methods

// -- Overridden methods
	virtual void edit(void);


// -- Class members
    //ReplyObserver replyObserver;
    MacroEditorObserver *replyObserver_;

// -- Class methods
	// None

// -- Friends

	//friend ostream& operator<<(ostream& s,const MacroEditor& p)
	//	{ p.print(s); return s; }

};

inline void destroy(QtMacroEditor**) {}

// If persistent, uncomment, otherwise remove
//#ifdef _ODI_OSSG_
//OS_MARK_SCHEMA_TYPE(MacroEditor);
//#endif

#endif
