/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

// File Service.h
// Baudouin Raoult - ECMWF Jul 99

#ifndef Service_H
#define Service_H

#include "inc_iostream.h"
#include "inc_stl.h"
using std::string;

class IconObject;
class Action;

class Task;

class Service {
public:

// -- Exceptions
	// None

// -- Contructors

	Service(const string&);

// -- Destructor

	virtual ~Service(); // Change to virtual if base class

// -- Convertors
	// None

// -- Operators
	// None
	string name();
	
// -- Methods

	virtual Task* task(const Action&,IconObject*) = 0;

// -- Overridden methods
	// None

// -- Class members
	// None

// -- Class methods
	// None

	static Service* find(const string&);

protected:

// -- Members
	
	string name_;

// -- Methods
	
	virtual void print(ostream&) const; // Change to virtual if base class	

// -- Overridden methods
	// None

// -- Class members
	// None

// -- Class methods
	// None

private:

// No copy allowed

	Service(const Service&);
	Service& operator=(const Service&);

// -- Members
	// None

// -- Methods
	// None

// -- Overridden methods
	// None

// -- Class members
	// None

// -- Class methods
	// None

// -- Friends

	friend ostream& operator<<(ostream& s,const Service& p)
		{ p.print(s); return s; }

};

inline void destroy(Service**) {}

// If persistent, uncomment, otherwise remove
//#ifdef _ODI_OSSG_
//OS_MARK_SCHEMA_TYPE(Service);
//#endif

#endif
