/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

#include "inc_iostream.h"

#ifndef Tools_H
#include "Tools.h"
#endif

#ifndef ConfigLoader_H
#include "ConfigLoader.h"
#endif

#ifndef Request_H
#include "Request.h"
#endif
#ifndef XMLabel_H
#include "XMLabel.h"
#endif

#ifndef Request_H
#include "Request.h"
#endif

#include <Xm/PushB.h>

static vector<Tools*> tools;

Tools::Tools(request* r):
	request_(r)
{
}

Tools::~Tools()
{
	// Not called
}

static void toolCB(Widget, XtPointer o, XtPointer)
{
	((Tools*)o)->start();
}

void Tools::make(Widget menu)
{
	for (vector<Tools*>::iterator j = tools.begin(); j != tools.end(); ++j ) 
	{
		Widget w = XmCreatePushButton(menu, (char*) get_value((*j)->request_, "name", 0), 0, 0);
		XMLabel(w).set(get_value((*j)->request_, "label", 0));
		XtAddCallback(w, XmNactivateCallback, toolCB, *j);
		XtManageChild(w);
	}

}


void Tools::start()
{
	cout << "Tools::start " << get_value(request_, "service", 0) << endl;
	Request r(get_value(request_, "action", 0));

	MvApplication::callService(get_value(request_, "service", 0), r, 0);
}


void Tools::load(request* r)
{
	tools.push_back(new Tools(r));
}


static SimpleLoader<Tools> loadClasses("interface_tool",1);
