/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

// File XMList.h
// Baudouin Raoult - ECMWF Jul 99

#ifndef XMList_H
#define XMList_H

#include "inc_stl.h"
using std::string;

#include <Xm/Xm.h>

class Path;

class XMList {
public:

// -- Exceptions
	// None

// -- Contructors

	XMList(Widget);

// -- Destructor

	~XMList(); // Change to virtual if base class

// -- Convertors
	// None

// -- Operators
	// None

// -- Methods

	void clear();
	void add(const string&);
	void add(const string&,bool bold);
	void add(const vector<string>&);
	void select(const string&);
	void select(const vector<string>&);
	void deselect();
	void showSelection();
	void multiple();
	bool exists(const string&);     

	void addMissing(const vector<string>&);
	void remove(const string&);
	void remove(const vector<string>&);

	vector<string> selection();
	vector<string> values();

	void sort();

// -- Overridden methods
	// None

// -- Class members
	// None

// -- Class methods
	// None

	// Uncomment for persistent, remove otherwise
	// static os_typespec* get_os_typespec();

protected:

// -- Members
	// None

// -- Methods
	
	// void print(ostream&) const; // Change to virtual if base class	

// -- Overridden methods
	// None

// -- Class members
	// None

// -- Class methods
	// None

private:

// No copy allowed

	XMList(const XMList&);
	XMList& operator=(const XMList&);

// -- Members
	
	Widget list_;

// -- Methods
	// None

// -- Overridden methods
	// None

// -- Class members
	// None

// -- Class methods
	// None

// -- Friends

	//friend ostream& operator<<(ostream& s,const XMList& p)
	//	{ p.print(s); return s; }

};

inline void destroy(XMList**) {}

// If persistent, uncomment, otherwise remove
//#ifdef _ODI_OSSG_
//OS_MARK_SCHEMA_TYPE(XMList);
//#endif

#endif
