/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

// File XPalette.h
// Baudouin Raoult - ECMWF Jul 99

#ifndef XPalette_H
#define XPalette_H

#include <Xm/Xm.h>
#include <string>
using std::string;

struct request;
struct RGBColor;
struct HSLColor;


class PaletteScanner {
public:
	virtual void next(const string&) = 0;
};

class XPalette {
public:

	XPalette(int);
	~XPalette();

// -- Class members

	
	static Pixel pixel(const RGBColor&);
	static Pixel pixel(const HSLColor&);

	static Pixel  pixel(const string&); // Name is X name
	static Pixel  magics(const string&); // Name is Magics name

	static void convert(const RGBColor&,HSLColor&);
	static void convert(const HSLColor&,RGBColor&);

	// Names are magics names

	static void convert(const string&,RGBColor&);
	static bool convert(const RGBColor&,string&);
	static bool exists(const string&);


	//---

	static void scan(PaletteScanner&);


	static void load(request*);



// -- Class methods

	// Uncomment for persistent, remove otherwise
	// static os_typespec* get_os_typespec();

protected:

// -- Members


// -- Methods
	
	// void print(ostream&) const; // Change to virtual if base class	

// -- Overridden methods
	// None

// -- Class members
	// None

// -- Class methods
	// None

private:

// No copy allowed

	XPalette(const XPalette&);
	XPalette& operator=(const XPalette&);

// -- Members

// -- Methods
	// None

// -- Overridden methods

// -- Class members
	// None

// -- Class methods
	// None

// -- Friends

	//friend ostream& operator<<(ostream& s,const XPalette& p)
	//	{ p.print(s); return s; }

};

inline void destroy(XPalette**) {}

// If persistent, uncomment, otherwise remove
//#ifdef _ODI_OSSG_
//OS_MARK_SCHEMA_TYPE(XPalette);
//#endif

#endif
