/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

#ifndef CAROUSELP_H
#define CAROUSELP_H

#include <Xm/XmP.h>
#include <Xm/DrawingAP.h>

typedef struct _CarouselClassPart {
    int         ignore;
} CarouselClassPart;

typedef struct _CarouselClassRec {
    CoreClassPart       core_class;
    CompositeClassPart  composite_class;
    ConstraintClassPart constraint_class;
    XmManagerClassPart  manager_class;
    XmDrawingAreaClassPart  drawing_area_class;
    CarouselClassPart     carousel_class;
} CarouselClassRec;

extern CarouselClassRec carouselClassRec;

typedef struct {
	Widget  left;
	Widget  right;
	Widget  line;
	int		columns;
	int		rows;
	int     speed;
	int     offset;
	int     child_width;
	int     child_height;
	int     margin;
	Boolean radio_behaviour;
} CarouselPart;


typedef struct _CarouselRec {
    CorePart            core;
    CompositePart       composite;
    ConstraintPart      constraint;
    XmManagerPart       manager;
    XmDrawingAreaPart   drawing_area;
    CarouselPart            carousel;
}  CarouselRec;



#endif /* CAROUSELP_H */



