/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

#ifndef MvQAbstractSearchLine_H
#define MvQAbstractSearchLine_H

#include <QColor>
#include <QWidget>

class QColor;
class QHBoxLayout;
class QLabel;
class QLineEdit;
class QPushButton;

using namespace std;

class MvQAbstractSearchLine : public QWidget
{
   Q_OBJECT

public:
	MvQAbstractSearchLine(QString,QWidget *parent=0);
	~MvQAbstractSearchLine(); 
	virtual void clear();

public slots:	
	virtual void slotFind(QString)=0;
	virtual void slotFindNext()=0;
	virtual void slotFindPrev()=0;

protected:
	void updateButtons(bool);

	QLabel* label_;
	QHBoxLayout* layout_;
	QLineEdit*   searchLine_;
	QPushButton* nextPb_;
	QPushButton* prevPb_;

	bool status_;

	QColor   oriColour_;	
	QColor   redColour_;
	QColor   greenColour_;
};


#endif