/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

#ifndef MvQObstatScatterData_H
#define MvQObstatScatterData_H

#include <vector>

#include <QDateTime>
#include <QStringList>

class MvKeyProfile;

using namespace std;

class MvQScatterItem
{
public:
	MvQScatterItem();
	~MvQScatterItem();

	void setArea(int area) {area_=area;}
	void setLevel(int level) {level_=level;}
	void setFlag(int flag) {flag_=flag;}
	void setParamX(int paramX) {paramX_=paramX;}
	void setParamY(int paramY) {paramY_=paramY;}
	void setStartX(float startX) {startX_=startX;}
	void setStartY(float startY) {startY_=startY;}
	void setDX(float dX) {dX_=dX;}
	void setDY(float dY) {dY_=dY;}
	void setNX(int nX) {nX_=nX;}
	void setNY(int nY) {nY_=nY;}
	void setData(float* data) {data_=data;}
	void setTitleX(QString titleX) {titleX_=titleX;}
	void setTitleY(QString titleY) {titleY_=titleY;}

	void setMinX(float f) {minX_=f;}
	void setMaxX(float f) {maxX_=f;}
	void setMinY(float f) {minY_=f;}
	void setMaxY(float f) {maxY_=f;}
	void setSumX(float f) {sumX_=f;}
	void setSumY(float f) {sumY_=f;}	
	void setSumXX(float f) {sumXX_=f;}
	void setSumYY(float f) {sumYY_=f;}
	void setSumXY(float f) {sumXY_=f;}
	void setSumDiffSqr(float f) {sumDiffSqr_=f;}
	void setSourceDataNum(int n) {sourceDataNum_=n;}

        int area() {return area_;}
	int level() {return level_;}
	int flag() {return flag_;}
	int paramX() {return paramX_;}
	int paramY() {return paramY_;}
	float startX() {return startX_;}
	float startY() {return startY_;}
	float endX() {return startX_+dX_*(nX_+1);}
	float endY() {return startY_+dY_*(nY_+1);}
	float dX() {return dX_;}
	float dY() {return dY_;}
	int nX() {return nX_;}
	int nY() {return nY_;}
	float* data() {return data_;}	
	QString titleX() {return titleX_;}
	QString titleY() {return titleY_;}

	float minX() {return minX_;}
	float maxX() {return maxX_;}
	float minY() {return minY_;}
	float maxY() {return maxY_;}
	float sumX() {return sumX_;}
	float sumY() {return sumY_;}	
	float sumXX() {return sumXX_;}
	float sumYY() {return sumYY_;}
	float sumXY() {return sumXY_;}
	float sumDiffSqr() {return sumDiffSqr_;}
	int sourceDataNum() {return sourceDataNum_;}

	void writeDataMatrixToNc(QString,bool);
 	void computeMeanForRows(QVector<float> &,QVector<float> &);
	void computeMeanForColumns(QVector<float> &,QVector<float> &);

protected:
	void writeDataMatrixToNc(string,vector<float>&,vector<float>&,vector<float>&);

	float *data_;

	int area_;
	int level_;
	int flag_;
	int paramX_;
	int paramY_;
	float startX_;
	float startY_;
	float dX_;
	float dY_;
	int nX_;
	int nY_;	

	QString titleX_;
	QString titleY_;
	QString areaName_;

	float maxX_;
	float minX_;
	float maxY_;
	float minY_;
	float sumX_;
	float sumY_;
	float sumXX_;
	float sumYY_;
	float sumXY_;
	float sumDiffSqr_;
	int sourceDataNum_;
};


class MvQScatterBlock
{
public:
	MvQScatterBlock();
	~MvQScatterBlock();
	void addItem(MvQScatterItem *item) {items_ << item;}
	
	void setStartDate(QDateTime d) {startDate_=d;}
	void setEndDate(QDateTime d) {endDate_=d;}
	void setParams(QMap<int,QString>& params) {params_=params;}	
	void setSatId(int id) {satId_=id;}
	void setSensorId(int id) {sensorId_=id;}	
	void setAreaNames(QStringList lst) {areaNames_=lst;}
	void setTitle(QString t) {title_=t;}
	QList<MvQScatterItem*> items() {return items_;}
	int itemNum() {return items_.count();}


	QDateTime startDate() {return startDate_;} 
	QDateTime endDate() {return endDate_;}
	int satId() {return satId_;}
	int sensorId() {return sensorId_;}
	QStringList areaNames() {return areaNames_;}
	QString title() {return title_;}
	void loadKeyProfile(MvKeyProfile*);

protected:
	QDateTime startDate_;
	QDateTime endDate_;
	int satId_;
	int sensorId_;
	//int itemNum_;
	//int channelNum_;
	//int flagNum_;
	//int areaNum_;
	QString title_;		
	QStringList areaNames_;
	QMap<int,QString> params_;


	QList<MvQScatterItem*> items_;

};


class MvQObstatScatterData
{
public:
	MvQObstatScatterData();
	~MvQObstatScatterData();

	void loadData();
	void loadKeyProfile(MvKeyProfile*);
	void setFileName(QString);
	QString fileName() {return fileName_;}
	int itemNum() {return itemNum_;}
	MvQScatterItem* item(int);
	MvQScatterBlock* blockOfItem(int);
	MvQScatterBlock* block(int);


	
protected:
	void clearData();

	QString fileName_;
	QList<MvQScatterBlock*>  blocks_;
	int itemNum_;
};


#endif
