/*
 This Software is provided under the Zope Public License (ZPL) Version 2.1.

 Copyright (c) 2014 by the mingw-w64 project

 See the AUTHORS file for the list of contributors to the mingw-w64 project.

 This license has been certified as open source. It has also been designated
 as GPL compatible by the Free Software Foundation (FSF).

 Redistribution and use in source and binary forms, with or without
 modification, are permitted provided that the following conditions are met:

   1. Redistributions in source code must retain the accompanying copyright
      notice, this list of conditions, and the following disclaimer.
   2. Redistributions in binary form must reproduce the accompanying
      copyright notice, this list of conditions, and the following disclaimer
      in the documentation and/or other materials provided with the
      distribution.
   3. Names of the copyright holders must not be used to endorse or promote
      products derived from this software without prior written permission
      from the copyright holders.
   4. The right to distribute this software or to use it for any purpose does
      not give you the right to use Servicemarks (sm) or Trademarks (tm) of
      the copyright holders.  Use of them is covered by separate agreement
      with the copyright holders.
   5. If any files are modified, you must cause the modified files to carry
      prominent notices stating that you changed the files and the date of
      any change.

 Disclaimer

 THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS ``AS IS'' AND ANY EXPRESSED
 OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO
 EVENT SHALL THE COPYRIGHT HOLDERS BE LIABLE FOR ANY DIRECT, INDIRECT,
 INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA,
 OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
 EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

#include "softmath_private.h"

double sin(double x)
{
    double result = 0.0, neg = (x < 0) ? -1 : 1;
    int n, quadrant;

    int x_class = fpclassify(x);
    if (x_class == FP_NAN)
    {
        errno = EDOM;
        __mingw_raise_matherr (_DOMAIN, "sin", x, 0.0, x);
        return x;
    }
    else if (x_class == FP_INFINITE)
    {
        errno = EDOM;
        __mingw_raise_matherr (_DOMAIN, "sin", x, 0.0, NAN);
        return NAN;
    }

    x *= neg;
    quadrant = (int)(x / M_PI_2) % 4;

    x = bsd__ieee754_fmod(x, M_PI_2);
    if (quadrant == 1 || quadrant == 3)
        x = M_PI_2 - x;

    for(n = 0; n < 6; n++)
    {
        double sign = (n % 2 == 0) ? 1 : -1;
        result += sign * (bsd__ieee754_pow(x, ((2 * n) + 1)) / softmath_fact((2 * n) + 1));
    }

    if (quadrant == 2 || quadrant == 3)
        result *= -1;

    return neg * result;
}
