import unittest
import calc_release_version


class TestVersionSort(unittest.TestCase):
    def test_version_sort(self):
        # At time of writing, `input_tags` is the output of `git tag -l "1.*"`:
        input_tags = ["1.0.0", "1.0.2", "1.1.0", "1.1.0-rc0", "1.1.10", "1.1.11", "1.1.2", "1.1.4", "1.1.5", "1.1.6", "1.1.7", "1.1.8", "1.1.9", "1.10.0", "1.10.1", "1.10.2", "1.10.3", "1.11.0", "1.12.0", "1.13.0", "1.13.1", "1.14.0", "1.14.1", "1.15.0", "1.15.1", "1.15.2", "1.15.3", "1.16.0", "1.16.1", "1.16.2", "1.17.0", "1.17.0-beta", "1.17.0-beta2", "1.17.0-rc0", "1.17.1", "1.17.2", "1.17.3", "1.17.4", "1.17.5", "1.17.6", "1.17.7", "1.18.0", "1.18.0-alpha", "1.18.0-alpha2", "1.19.0", "1.19.1", "1.19.2", "1.2.0", "1.2.0-beta", "1.2.0-beta1", "1.2.0-rc0", "1.2.1", "1.2.2", "1.2.3", "1.2.4", "1.20.0", "1.20.1", "1.21.0", "1.21.1", "1.21.2", "1.22.0", "1.22.0-beta0", "1.22.1", "1.22.2", "1.23.0",
                      "1.23.1", "1.23.2", "1.23.3", "1.23.4", "1.23.5", "1.24.0", "1.24.1", "1.24.2", "1.24.3", "1.24.4", "1.3.0", "1.3.0-beta0", "1.3.0-rc0", "1.3.1", "1.3.2", "1.3.3", "1.3.4", "1.3.5", "1.3.6", "1.4.0", "1.4.0-beta0", "1.4.0-beta1", "1.4.1", "1.4.2", "1.4.3", "1.5.0", "1.5.0-rc0", "1.5.0-rc1", "1.5.0-rc2", "1.5.0-rc3", "1.5.0-rc4", "1.5.0-rc6", "1.5.1", "1.5.2", "1.5.3", "1.5.4", "1.5.5", "1.6.0", "1.6.0-rc0", "1.6.1", "1.6.2", "1.6.3", "1.7.0", "1.7.0-rc0", "1.7.0-rc1", "1.7.0-rc2", "1.8.0", "1.8.0-rc0", "1.8.0-rc1", "1.8.1", "1.8.2", "1.9.0", "1.9.0+dfsg", "1.9.0-rc0", "1.9.0-rc1", "1.9.1", "1.9.2", "1.9.2+dfsg", "1.9.3", "1.9.3+dfsg", "1.9.4", "1.9.4+dfsg", "1.9.5", "1.9.5+dfsg"]
        expected_tags = ['1.0.0', '1.0.2', '1.1.0-rc0', '1.1.0', '1.1.2', '1.1.4', '1.1.5', '1.1.6', '1.1.7', '1.1.8', '1.1.9', '1.1.10', '1.1.11', '1.2.0-beta', '1.2.0-beta1', '1.2.0-rc0', '1.2.0', '1.2.1', '1.2.2', '1.2.3', '1.2.4', '1.3.0-beta0', '1.3.0-rc0', '1.3.0', '1.3.1', '1.3.2', '1.3.3', '1.3.4', '1.3.5', '1.3.6', '1.4.0-beta0', '1.4.0-beta1', '1.4.0', '1.4.1', '1.4.2', '1.4.3', '1.5.0-rc0', '1.5.0-rc1', '1.5.0-rc2', '1.5.0-rc3', '1.5.0-rc4', '1.5.0-rc6', '1.5.0', '1.5.1', '1.5.2', '1.5.3', '1.5.4', '1.5.5', '1.6.0-rc0', '1.6.0', '1.6.1', '1.6.2', '1.6.3', '1.7.0-rc0', '1.7.0-rc1', '1.7.0-rc2', '1.7.0', '1.8.0-rc0', '1.8.0-rc1', '1.8.0', '1.8.1', '1.8.2', '1.9.0-rc0', '1.9.0-rc1',
                         '1.9.0', '1.9.0+dfsg', '1.9.1', '1.9.2', '1.9.2+dfsg', '1.9.3', '1.9.3+dfsg', '1.9.4', '1.9.4+dfsg', '1.9.5', '1.9.5+dfsg', '1.10.0', '1.10.1', '1.10.2', '1.10.3', '1.11.0', '1.12.0', '1.13.0', '1.13.1', '1.14.0', '1.14.1', '1.15.0', '1.15.1', '1.15.2', '1.15.3', '1.16.0', '1.16.1', '1.16.2', '1.17.0-beta', '1.17.0-beta2', '1.17.0-rc0', '1.17.0', '1.17.1', '1.17.2', '1.17.3', '1.17.4', '1.17.5', '1.17.6', '1.17.7', '1.18.0-alpha', '1.18.0-alpha2', '1.18.0', '1.19.0', '1.19.1', '1.19.2', '1.20.0', '1.20.1', '1.21.0', '1.21.1', '1.21.2', '1.22.0-beta0', '1.22.0', '1.22.1', '1.22.2', '1.23.0', '1.23.1', '1.23.2', '1.23.3', '1.23.4', '1.23.5', '1.24.0', '1.24.1', '1.24.2', '1.24.3', '1.24.4']
        got_tags = sorted(input_tags, key=calc_release_version.Version)
        self.assertEqual(got_tags, expected_tags)


if __name__ == "__main__":
    unittest.main()
