# Node Foundation TSC Meeting 2015-06-17

## Links

* **Audio Recording**: https://soundcloud.com/node-foundation/tsc-meeting-2015-06-17
* **GitHub Issue**: https://github.com/nodejs/node-convergence-archive/issues/56
* **Original Minutes Google Doc**: https://docs.google.com/document/d/1d4mAJgm06rpPWLDqhZcxsRnKMrS92Ip4CW2akOyeIL4

## Agenda

Extracted from **tsc-agenda** labelled issues and pull requests prior to meeting.

### nodejs/node

* Create a security team [#48](https://github.com/nodejs/node-convergence-archive/issues/48)

### nodejs/io.js

* Nominating Shigeki Ohtsu @shigeki to the TC [#1501](https://github.com/nodejs/io.js/issues/1501)
* Nominating Brian White @mscdex to the TC [#1500](https://github.com/nodejs/io.js/issues/1500)
* on working with proposals from the API WG [#1993](https://github.com/nodejs/io.js/issues/1993)
* zlib: prevent uncaught exception in zlibBuffer [#1993](https://github.com/nodejs/io.js/issues/1811)
* Proposal: Release Process [#1997](https://github.com/nodejs/io.js/issues/1997)

### joyent/node

* Nominating new collaborators to this repository [#25481](https://github.com/joyent/node/issues/25481)

## Minutes


### Present

* Rod Vagg (TSC)
* Colin Ihrig (TSC)
* Chris Dickinson (TSC)
* Michael Dawson (TSC)
* Mikeal Rogers
* Steven R. Loomis (TSC)
* Bert Belder (TSC)
* Alexis Campailla (TSC)
* Julien Gilli (TSC)
* Shigeki Ohtsu
* Jeremiah Senkpiel (TSC)
* Brian White
* Trevor Norris (TSC)
* Domenic Denicola
* Fedor Indutny (TSC)

### Review of the previous meeting

* Add working group state per Project Lifecycle
* Chrome 43 released; time for V8 4.3
* TSC needs to elect a board representative.
* Nominating new collaborators to this repository
* Node should not automatically change rlimits
* New OpenSSL version about to be released, with fixed for logjam
* Repurpose previous node.js TSC meeting as LTS WG meeting
* 3.0 upgrade documentation 
* Rebasing on top of the 'next' branch (not on the agenda)
* Workers PR from Petka

### Standup:

* Rod: build, productive work on improving the ci and build convergence, ci now does linting before running the tests, also improving the io.js make file so that less logic for releases is contained in jenkins
* Colin: reviewing issues and pr’s, landed a cluster patch to not use --debug_port on cluster workers by default
* Chris: NodeConf, got great feedback there. PR for code coverage incoming soon, spun up the docs WG.
  * http://neversaw.us/scratch/node-coverage/ – code coverage
  * https://github.com/nodejs/docs 
* Michael: Reviewing OpenSSL changes for LogJam; PPC LE & BE work nearly complete, some OpenSSL blockers (EC related)--working towards including PPC in CI
* Mikeal: running NodeConf and writing up feedback & foundation work
* Steven: getting back on board
* Bert: libuv work for multi-worker on Windows (https://github.com/libuv/libuv/pull/396), found a potential libuv/Windows contributor at NodeConf, NF board meeting
* Alexis: Working on build & CI convergence with Rod, CI can now automatically decide what options to use for different node versions, and porting node-accept-pull-request CI job.
* Julien: time off, launching nodejs.org updates for NF launch, working on changes for 0.10/0.12 releases, onboarded two new collaborators for joyent/node - https://github.com/nodejs/LTS/wiki/Breaking-changes-between-v0.12-and-next-LTS-release
* Shigeki: Working on upgrading OpenSSL, the upgrade process is becoming much simpler, landed the CINNIC whitelist
* Jeremiah: NodeConf - brought back good feedback, helping spin up the Diversity WG, integrating timers heap impl, struggling with bugs
* Brian: not much, triage & PR review
* Trevor: reviewing, commenting, merging, PR to next branch allowing passing ArrayBuffers to Buffers constructor
* Domenic: reviewing, some work with Trevor, discussing release procedure
* Fedor: Reviewing issues(?), working on http/2 in node-spdy

### Nominating Shigeki Ohtsu @shigeki to the TC [#1501](https://github.com/nodejs/io.js/issues/1501)
### Nominating Brian White @mscdex to the TC [#1500](https://github.com/nodejs/io.js/issues/1500)

Called for a vote, got +1's for both candidates from each of: Chris, Rod, Bert, Colin, Trevor, Jeremiah, Julien, Michael, Alexis

### on working with proposals from the API WG [#1993](https://github.com/nodejs/io.js/issues/1993)

* Trevor: started discussions back in advisory board before io.js existed, large companies wanted “official Node.js compatibility” at both module and JS layer. Some dissenting voices in Joyent that prevented things proceeding. After io.js happened the formal discussion ended but informal discussion continued, e.g. in https://github.com/nodejs/nan/issues/349, aim at the C++ level is to reduce API turn-over. Companies involved have their own VMs and want to maintain them for their own purposes (e.g. Chakra, JVM).
* Trevor: interested in starting a WG or piggy-backing Addon API WG.
* Domenic: would like more clarity on what this thing could be, is it libuv.js? is it a VM abstraction layer?
* Bert: would be good to scope this work
* Trevor: there’s one interest group--concerned with binary addons and not having to ship new versions with each new Node release. Another interest group is concerned with something akin to a process.bindings abstraction layer so you could put the Node JS layer on top of whatever runtime chosen.
* Bert: standardising the process.bindings API might be easiest but standardising the C++ API has more beneifits because it solves the v8-upgrade-breaks-addons problem.
* Rod: https://github.com/nodejs/nan/issues/373 is an issue in NAN for organising a meeting for the various groups interested in exploring C++ API compatibility, specifically for addons.

### zlib: prevent uncaught exception in zlibBuffer [#1811](https://github.com/nodejs/io.js/issues/1811)

* Trevor: Issue #1811 is potentially CVE-worthy, it’s been fixed but what is the process for going forward with a CVE if necessary?
* Rod: security@nodejs.org has an expanded team and security@iojs.org redirects there as well. That team should be delegated to for discussion--if you have concerns then email them and let them be responsible for deciding how to proceed.
* ACTION: Trevor to email summary of potential security concern to security@nodejs.org for further discussion amongst that group. Potentially also backporting to 0.10 and 0.12.

### Proposal: Release Process [#1997](https://github.com/nodejs/io.js/issues/1997)

* Mikeal:
  - next branch to be released on a more regular timeline
need to message to users that are on the “next” branch that there is a tradeoff between new V8 (features + perf) and being able to use native modules
  - bring next to current, current to LTS
* Domenic:
  - core of the proposal:
    - pseudo-LTS
    - maintain V8 version for ourselves
    - don’t backport any breaking changes from master, only features and patches
    - release this with name that implies “use this to work with native modules and features” ???? (CD - lost track here)
    - active dev happens here
* Trevor: Naming is confusing; why isn’t it sufficient to say “this release is LTS”?
* Mikeal: We don’t want LTS to mean “this is stable”, we want it to mean “I can use this for five years”
* Trevor: But that’s the same thing, isn’t it?
* Rod: Using the term LTS is counterproductive (leave it to the LTS working group) – it distracts
* Trevor: one year span before [V8] is merged – that sounds like LTS
* Domenic: This is a new release channel/train
* Mikeal: We need “stable for a year” / “new features in V8, no native modules” / “stable for five years”
  we stick with semver
  (CD: Mikeal could you fill this out further?)
* Domenic: We don’t need to move away from semver for the next branch
Yearly releases pick a version that aligns
* Mikeal: don’t call it canary, get a codename – increment one, two, three or five over a year – when we merge into master we choose a new name
* CD: Could not capture entirety of discussion – moved a bit fast for me.
* Bert: there is no ideal answer here. Would like mikeal and domenic to continue discussion and come back with something to vote on.

## Next meeting

Next week, 2015-06-24
