#pragma once
#include <QDockWidget>
#include <qmenu.h>
#include <QTabWidget>
#include <QVBoxLayout>
#include <obs-frontend-api.h>
#include "downstream-keyer.hpp"
#include "obs-websocket-api.h"

class DownstreamKeyerDock : public QWidget {
	Q_OBJECT
private:
	QTabWidget *tabs;
	int outputChannel;
	bool loaded = false;
	bool closing = false;
	obs_view_t *view = nullptr;
	obs_canvas_t *canvas = nullptr;
	std::string viewName;
	get_transitions_callback_t get_transitions = nullptr;
	void *get_transitions_data = nullptr;

	void Save(obs_data_t *data);
	void Load(obs_data_t *data);
	QString GetScene(QString dskName);
	bool SwitchDSK(QString dskName, QString sceneName);
	bool AddScene(QString dskName, QString sceneName, int insertBeforeRow);
	bool RemoveScene(QString dskName, QString sceneName);
	bool SetTie(QString dskName, bool tie);
	bool SetTransition(const QString &chars, const char *transition, int duration, transitionType tt);
	bool AddExcludeScene(QString dskName, const char *sceneName);
	bool RemoveExcludeScene(QString dskName, const char *sceneName);

	void ClearKeyers();
	void AddDefaultKeyer();
	void ConfigClicked();
	void SceneChanged();
	void AddTransitionMenu(QMenu *tm, enum transitionType transition_type);
	void AddExcludeSceneMenu(QMenu *tm);
private slots:
	void Add(QString name = "");
	void Rename();
	void Remove(int index = -1);

public:
	DownstreamKeyerDock(QWidget *parent = nullptr, int outputChannel = 7, obs_view_t *view = nullptr,
			    obs_canvas_t *canvas = nullptr, const char *view_name = nullptr);
	~DownstreamKeyerDock();

	void SetTransitions(get_transitions_callback_t get_transitions = nullptr, void *get_transitions_data = nullptr);

	inline obs_view_t *GetView() { return view; }
	inline obs_canvas_t *GetCanvas() { return canvas; }

	static void frontend_event(enum obs_frontend_event event, void *data);
	static void frontend_save_load(obs_data_t *save_data, bool saving, void *data);

	static void get_downstream_keyers(obs_data_t *request_data, obs_data_t *response_data, void *param);
	static void get_downstream_keyer(obs_data_t *request_data, obs_data_t *response_data, void *param);
	static void add_downstream_keyer(obs_data_t *request_data, obs_data_t *response_data, void *param);
	static void remove_downstream_keyer(obs_data_t *request_data, obs_data_t *response_data, void *param);
	static void get_scene(obs_data_t *request_data, obs_data_t *response_data, void *param);
	static void change_scene(obs_data_t *request_data, obs_data_t *response_data, void *param);
	static void add_scene(obs_data_t *request_data, obs_data_t *response_data, void *param);
	static void remove_scene(obs_data_t *request_data, obs_data_t *response_data, void *param);
	static void set_tie(obs_data_t *request_data, obs_data_t *response_data, void *param);
	static void set_transition(obs_data_t *request_data, obs_data_t *response_data, void *param);
	static void add_exclude_scene(obs_data_t *request_data, obs_data_t *response_data, void *param);
	static void remove_exclude_scene(obs_data_t *request_data, obs_data_t *response_data, void *param);
};
